/*---------------------------
    JS INDEX
    ===================
    01. Banner Slider
    02. Experience Tag Counter
    03. Progress bar
    04. Team Slider
    05. Post Slider
    06. Testimonial Slider
    07. Video Popup
    08. Portfolio isotope
    09. Portfolio Slider
    10. Client Logos Slider
    11. Counter Boxes

-----------------------------*/

(function($) {
	'use strict';
	// ===== 01.  Banner Slider
	var bannerSlider = function($scope, $) {
		$scope.find('.yankee-bannner-widget').each(function() {
			var $selector = $(this),
				$slider = $selector.find('.yankee-banner-slider'),
				$arrow = $selector.data('arrow'),
				$dots = $selector.data('dots'),
				$autoplay = $selector.data('autoplay'),
				$autoplayt = $selector.data('autoplayt'),
				$fade = $selector.data('fade');

			$slider.on('init', function(e, slick) {
				var firstAnimatingElements = $slider.find(
					'[data-animation]'
				);
				slideanimate(firstAnimatingElements);
			});

			$slider.on('beforeChange', function(
				e,
				slick,
				currentSlide,
				nextSlide
			) {
				var animatingElements = $(
					'div.slick-slide[data-slick-index="' + nextSlide + '"]'
				).find('[data-animation]');
				slideanimate(animatingElements);
			});

			$slider.not('.slick-initialized').slick({
				infinite: true,
				slidesToShow: 1,
				slidesToScroll: 1,
				autoplay: $autoplay,
				autoplaySpeed: $autoplayt,
				speed: 500,
				arrows: $arrow,
				fade: $fade,
				dots: $dots,
				swipe: true,
				nextArrow: '<button class="slick-arrow next-arrow">Next</button>',
				prevArrow: '<button class="slick-arrow prev-arrow">Prev</button>',
				responsive: [{
					breakpoint: 768,
					settings: {
						arrows: false
					}
				}],
			});

			$slider.find('.video-btn').magnificPopup({
				type: 'iframe',
			});
		});
	};

	function slideanimate(elements) {
		var animationEndEvents =
			'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
		elements.each(function() {
			var $this = $(this);
			var animationDelay = $this.data('delay');
			var animationType = 'animated ' + $this.data('animation');
			$this.css({
				'animation-delay': animationDelay,
				'-webkit-animation-delay': animationDelay,
			});
			$this
				.addClass(animationType)
				.one(animationEndEvents, function() {
					$this.removeClass(animationType);
				});
		});
	}

	// ===== 02. Progress bar
	var progressBar = function($scope, $) {
		$scope.find('.yankee-progress-bars').each(function() {
			var $selector = $(this);

			$selector.bind('inview', function(
				event,
				visible,
				visiblePartX,
				visiblePartY
			) {
				if (visible) {
					$.each($('.single-progress-bar'), function() {
						var counter = $(this).find('.progress-counter'),
							count = $(this).find('.count'),
							dataCount = $(this).attr('data-percentage'),
							progressbar = $(this).find('.progress-line'),
							progressbarV = $(this).find('.progressbarV');

						// Set counter css
						counter.css('left', dataCount + '%');
						counter.css('top', '50%');

						// set counter
						$({
							Counter: 0
						}).animate({
							Counter: dataCount
						}, {
							duration: 2000,
							easing: 'swing',
							step: function() {
								count.text(Math.ceil(this.Counter));
							},
						});

						// progressbar css
						progressbar.css('width', dataCount + '%');
						progressbarV.css('left', dataCount + '%');

					});

					$(this).unbind('inview');
				}
			});
		});
	};

	// ===== 03. Team Slider
	var teamSlider = function($scope, $) {
		$scope.find('.yankee-team-slider').each(function() {
			var $selector = $(this),
				$lgitem = $selector.data('lgitem'),
				$mditem = $selector.data('mditem'),
				$smitem = $selector.data('smitem'),
				$xsitem = $selector.data('xsitem'),
				$arrow = $selector.data('arrow'),
				$dots = $selector.data('dots'),
				$autoplay = $selector.data('autoplay'),
				$autoplayt = $selector.data('autoplayt');

			$selector.not('.slick-initialized').slick({
				infinite: true,
				slidesToShow: $lgitem,
				slidesToScroll: 1,
				autoplay: $autoplay,
				autoplaySpeed: $autoplayt,
				speed: 500,
				arrows: $arrow,
				fade: false,
				dots: $dots,
				swipe: true,
				nextArrow: '<button class="slick-arrow next-arrow"><i class="far fa-angle-right"></i></button>',
				prevArrow: '<button class="slick-arrow prev-arrow"><i class="far fa-angle-left"></i></button>',
				responsive: [{
					breakpoint: 992,
					settings: {
						slidesToShow: $mditem,
					}
				}, {
					breakpoint: 768,
					settings: {
						slidesToShow: $smitem,
					}
				}, {
					breakpoint: 576,
					settings: {
						slidesToShow: $xsitem,
					}
				}],
			});
		});
	};

	// ===== 04. Post Slider
	var postSlider = function($scope, $) {
		$scope.find('.yankee-post-slider').each(function() {
			var $selector = $(this),
				$lgitem = $selector.data('lgitem'),
				$mditem = $selector.data('mditem'),
				$smitem = $selector.data('smitem'),
				$xsitem = $selector.data('xsitem'),
				$arrow = $selector.data('arrow'),
				$dots = $selector.data('dots'),
				$autoplay = $selector.data('autoplay'),
				$autoplayt = $selector.data('autoplayt');

			$selector.not('.slick-initialized').slick({
				infinite: true,
				slidesToShow: $lgitem,
				slidesToScroll: 1,
				autoplay: $autoplay,
				autoplaySpeed: $autoplayt,
				speed: 500,
				arrows: $arrow,
				fade: false,
				dots: $dots,
				swipe: true,
				nextArrow: '<button class="slick-arrow next-arrow"><i class="far fa-angle-right"></i></button>',
				prevArrow: '<button class="slick-arrow prev-arrow"><i class="far fa-angle-left"></i></button>',
				responsive: [{
					breakpoint: 992,
					settings: {
						slidesToShow: $mditem,
					}
				}, {
					breakpoint: 768,
					settings: {
						slidesToShow: $smitem,
					}
				}, {
					breakpoint: 576,
					settings: {
						slidesToShow: $xsitem,
					}
				}],
			});
		});
	};

	// ===== 05. Testimonial Slider
	var testimonialSlider = function($scope, $) {
		$scope.find('.yankee-testimonial-slider').each(function() {
			var $selector = $(this),
				$lgitem = $selector.data('lgitem'),
				$mditem = $selector.data('mditem'),
				$smitem = $selector.data('smitem'),
				$xsitem = $selector.data('xsitem'),
				$arrow = $selector.data('arrow'),
				$dots = $selector.data('dots'),
				$autoplay = $selector.data('autoplay'),
				$autoplayt = $selector.data('autoplayt');

			$selector.not('.slick-initialized').slick({
				infinite: true,
				slidesToShow: $lgitem,
				slidesToScroll: 1,
				autoplay: $autoplay,
				autoplaySpeed: $autoplayt,
				speed: 500,
				arrows: $arrow,
				fade: false,
				dots: $dots,
				swipe: true,
				nextArrow: '<button class="slick-arrow next-arrow"><i class="far fa-angle-right"></i></button>',
				prevArrow: '<button class="slick-arrow prev-arrow"><i class="far fa-angle-left"></i></button>',
				responsive: [{
					breakpoint: 992,
					settings: {
						slidesToShow: $mditem,
					}
				}, {
					breakpoint: 768,
					settings: {
						slidesToShow: $smitem,
					}
				}, {
					breakpoint: 576,
					settings: {
						slidesToShow: $xsitem,
					}
				}],
			});
		});
	};

	// ===== 06. Video Popup
	var videoPopup = function($scope, $) {
		$scope.find('.yankee-video').each(function() {
			var $selector = $(this).find('.popup-video');

			$selector.magnificPopup({
				type: 'iframe',
			});
		});
	};

	// ===== 07. Portfolio isotope
	var portfolioIsotope = function($scope, $) {
		$('.yankee-portfolio-widgets').imagesLoaded(function() {
			$('.portfolio-filter').each(function() {
				var iso = new Isotope(this, {
					itemSelector: '.grid-item',
					percentPosition: true,
					masonry: {
						columnWidth: '.grid-sizer',
					},
				});

				var filtersElem = $(this).parent().find('.portfolio-nav ul');
				filtersElem.on('click', function(event) {
					var filterValue = event.target.getAttribute('data-filter');
					iso.arrange({
						filter: filterValue
					});
				});

				var filterItem = $(this).parent().find('.portfolio-nav ul li');
				filterItem.on('click', function(e) {
					filterItem.removeClass('active');
					$(this).addClass('active');
				});
			});
		});
	};

	// ===== 08. Portfolio Slider
	var portfolioSlider = function($scope, $) {
		$scope.find('.portfolio-slider').each(function() {
			var $selector = $(this),
				$arrow = $selector.data('arrow'),
				$dots = $selector.data('dots'),
				$autoplay = $selector.data('autoplay'),
				$autoplayt = $selector.data('autoplayt');

			$selector.not('.slick-initialized').not('.portfolio-filter').slick({
				infinite: true,
				slidesToShow: 1,
				slidesToScroll: 1,
				autoplay: $autoplay,
				autoplaySpeed: $autoplayt,
				speed: 500,
				arrows: $arrow,
				fade: false,
				dots: $dots,
				centerMode: true,
				centerPadding: '30%',
				swipe: true,
				nextArrow: '<button class="slick-arrow next-arrow"><i class="far fa-angle-right"></i></button>',
				prevArrow: '<button class="slick-arrow prev-arrow"><i class="far fa-angle-left"></i></button>',
				responsive: [{
					breakpoint: 1350,
					settings: {
						centerPadding: '25%',
					}
				}, {
					breakpoint: 992,
					settings: {
						centerPadding: '20%',
					}
				}, {
					breakpoint: 768,
					settings: {
						centerPadding: '10%',
					}
				}, {
					breakpoint: 576,
					settings: {
						centerPadding: '0',
					}
				}],
			});
		});
	};

	// ===== 09. Client Logos Slider
	var clientSlider = function($scope, $) {
		$scope.find('.yankee-client-logos').each(function() {
			var $selector = $(this),
				$lgitem = $selector.data('lgitem'),
				$lgsmitem = $selector.data('lgsmitem'),
				$mditem = $selector.data('mditem'),
				$smitem = $selector.data('smitem'),
				$xsitem = $selector.data('xsitem'),
				$arrow = $selector.data('arrow'),
				$dots = $selector.data('dots'),
				$autoplay = $selector.data('autoplay'),
				$autoplayt = $selector.data('autoplayt');

			$selector.not('.slick-initialized').not('.portfolio-filter').slick({
				infinite: true,
				slidesToShow: $lgitem,
				slidesToScroll: 1,
				autoplay: $autoplay,
				autoplaySpeed: $autoplayt,
				speed: 500,
				arrows: $arrow,
				fade: false,
				dots: $dots,
				swipe: true,
				nextArrow: '<button class="slick-arrow next-arrow"><i class="far fa-angle-right"></i></button>',
				prevArrow: '<button class="slick-arrow prev-arrow"><i class="far fa-angle-left"></i></button>',
				responsive: [{
					breakpoint: 1200,
					settings: {
						slidesToShow: $lgsmitem,
					}
				}, {
					breakpoint: 992,
					settings: {
						slidesToShow: $mditem,
					}
				}, {
					breakpoint: 768,
					settings: {
						slidesToShow: $smitem,
					}
				}, {
					breakpoint: 576,
					settings: {
						slidesToShow: $xsitem,
					}
				}],
			});
		});
	};

	// ===== 10. Counter Boxes
	var counterBoxes = function($scope, $) {
		$scope.find('.counter-box').each(function() {
			var $selector = $(this);

			$selector.bind('inview', function(
				event,
				visible,
				visiblePartX,
				visiblePartY
			) {
				if (visible) {
					$(this)
						.find('.count')
						.each(function() {
							var $this = $(this);
							$({
								Counter: 0
							}).animate({
								Counter: $this.text()
							}, {
								duration: 3000,
								easing: 'swing',
								step: function() {
									$this.text(Math.ceil(this.Counter));
								},
							});
						});
					$(this).unbind('inview');
				}
			});
		});
	};

	/*-----------------------------
	===  Elementor JS Hooks ===
	------------------------------*/
	$(window).on("elementor/frontend/init", function() {
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-banner-slider.default", bannerSlider);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-progress-bar.default", progressBar);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-team-slider.default", teamSlider);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-post-slider.default", postSlider);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-testimonial-slider.default", testimonialSlider);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-video.default", videoPopup);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-portfolio-filter.default", portfolioIsotope);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-portfolio-slider.default", portfolioSlider);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-client-logos.default", clientSlider);
		elementorFrontend.hooks.addAction("frontend/element_ready/yankee-counter-boxes.default", counterBoxes);
	});
})(jQuery);