<?php

namespace PostType;

class Portfolio {

    /**
     * @var string
     * Set post type params
     */
    private $type = 'portfolios';
    private $slug = 'portfolio';
    private $name = 'Portfolios';
    private $singular_name = 'Portfolio';
    private $icon = 'dashicons-portfolio';

    /**
     * Register post type
     */
    public function register() {
        $opt = get_option( 'yankee_options' );
        $slug = !empty( $opt['portfolio_slug'] ) ? strtolower( str_replace( ' ', '', $opt['portfolio_slug'] ) ) : $this->slug;

        $labels = [
            'name'                  => esc_html_x( 'Portfolios', 'Post Type General Name', 'yankee-toolkit' ),
            'singular_name'         => esc_html_x( 'Portfolio', 'Post Type Singular Name', 'yankee-toolkit' ),
            'add_new'               => esc_html__( 'Add New ', 'yankee-toolkit' ),
            'add_new_item'          => esc_html__( 'Add New ', 'yankee-toolkit' ) . $this->singular_name,
            'edit_item'             => esc_html__( 'Edit ', 'yankee-toolkit' ) . $this->singular_name,
            'new_item'              => esc_html__( 'New ', 'yankee-toolkit' ) . $this->singular_name,
            'all_items'             => esc_html__( 'All ', 'yankee-toolkit' ) . $this->name,
            'view_item'             => esc_html__( 'View ', 'yankee-toolkit' ) . $this->singular_name,
            'view_items'            => esc_html__( 'View ', 'yankee-toolkit' ) . $this->name,
            'search_items'          => esc_html__( 'Search ', 'yankee-toolkit' ) . $this->name,
            'not_found'             => esc_html__( 'No ', 'yankee-toolkit' ) . strtolower( $this->name ) . esc_html__( ' found', 'yankee-toolkit' ),
            'not_found_in_trash'    => esc_html__( 'No ', 'yankee-toolkit' ) . strtolower( $this->name ) . esc_html__( ' found in Trash', 'yankee-toolkit' ),
            'parent_item_colon'     => '',
            'menu_name'             => $this->name,
            'featured_image'        => $this->singular_name . esc_html__( ' Image', 'yankee-toolkit' ),
            'set_featured_image'    => esc_html__( 'Set ', 'yankee-toolkit' ) . $this->singular_name . esc_html__( ' Image', 'yankee-toolkit' ),
            'remove_featured_image' => esc_html__( 'Remove ', 'yankee-toolkit' ) . $this->singular_name . esc_html__( ' Image', 'yankee-toolkit' ),
            'use_featured_image'    => esc_html__( 'Use as ', 'yankee-toolkit' ) . $this->singular_name . esc_html__( ' Image', 'yankee-toolkit' ),
        ];

        $args = [
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => [ 'slug' => $slug ],
            'capability_type'    => 'post',
            'has_archive'        => false,
            'hierarchical'       => true,
            'menu_position'      => 8,
            'supports'           => [ 'title', 'editor', 'thumbnail' ],
            'yarpp_support'      => true,
            'menu_icon'          => $this->icon,
        ];

        register_post_type( $this->type, $args );

        // Register custom taxonomy
        register_taxonomy( $this->type . '_cat', $this->type, [
            'public'            => true,
            'hierarchical'      => true,
            'show_admin_column' => true,
            'show_in_nav_menus' => false,
            'rewrite'           => [
                'slug'       => 'portfolio-category',
                'with_front' => true,
            ],
            'labels'            => [
                'name' => $this->singular_name . esc_html__( ' Categories', 'yankee-toolkit' ),
            ],
        ] );
    }

    public function __construct() {
        // Register the post type
        add_action( 'init', [ $this, 'register' ] );
    }

}

new Portfolio();