<div class="container-fluid container-1500">
    <div class="yankee-banner-slider banner-style-two">
        <?php foreach ( $settings['banners'] as $banner ):
            $image = wp_get_attachment_image_url( $banner['banner_image']['id'], $settings['thumbnail_size'] );
            if ( ! $image ) {
                $image = $banner['banner_image']['url'];
            }

            ?>
            <div class="single-banner"<?php if ( $image ) : ?> style="background-image: url(<?php echo esc_url( $image ) ?>);" <?php endif; ?>>
                <div class="container">
                    <div class="banner-text <?php echo esc_attr($banner['text_align']) ?>">
                        <?php
                            if( $banner['banner_tags'] ) {
                                printf( '<ul class="banner-tags" data-animation="%1$s" data-delay="0.3s">%2$s</ul>',
                                    esc_attr( $settings['tags_animation'] ),
                                    wp_kses_post( $banner['banner_tags'] )
                                );
                            }

                            if ( $banner['title_type'] == 'dual-title' ) {
                                if ( $banner['dual_title_1'] || $banner['dual_title_2'] ) {
                                    printf( '<%1$s class="banner-title dual-title" data-animation="%2$s" data-delay="0.5s">%3$s <span>%4$s</span></%1$s>',
                                        tag_escape( $banner['title_tag'] ),
                                        esc_attr( $settings['title_animation'] ),
                                        esc_html( $banner['dual_title_1'] ),
                                        esc_html( $banner['dual_title_2'] )
                                    );
                                }
                            } else {
                                if ( $banner['normal_title'] ) {
                                    printf( '<%1$s class="banner-title normal-title" data-animation="%2$s" data-delay="0.5s">%3$s</%1$s>',
                                        tag_escape( $banner['title_tag'] ),
                                        esc_attr( $settings['title_animation'] ),
                                        esc_html( $banner['normal_title'] )
                                    );
                                }
                            }

                            if ( $banner['use_btn'] == 'yes' || $banner['use_video_btn'] == 'yes' ) : ?>
                                <ul class="banner-btns">
                                    <?php if( $banner['use_btn'] == 'yes' && $banner['btn_url']['url'] ) : ?>
                                        <li data-animation="<?php echo esc_attr( $settings['btn_one_animation'] ) ?>" data-delay="0.7s">
                                            <a class="banner-btn" href="<?php echo esc_url( $banner['btn_url']['url'] )?>">
                                                <?php
                                                    echo esc_html( $banner['btn_text'] );

                                                    if ( $banner['btn_icon']['value'] ) {
                                                        printf( '<i class="%1$s"></i>',
                                                            esc_attr( $banner['btn_icon']['value'] )
                                                        );
                                                    }
                                                ?>
                                            </a>
                                        </li>
                                    <?php endif; if( $banner['use_video_btn'] == 'yes' && $banner['video_btn_url']['url'] ) : ?>
                                        <li data-animation="<?php echo esc_attr( $settings['btn_two_animation'] ) ?>" data-delay="0.7s">
                                            <a class="video-btn popup-video" href="<?php echo esc_url( $banner['video_btn_url']['url'] )?>"><i class="fas fa-play"></i></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            <?php endif;
                        ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>