<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Plugin;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Advanced_Tab extends Widget_Base {

    public function get_name() {
        return 'yankee-advanced-tab';
    }

    public function get_title() {
        return esc_html__( 'Advanced Tab', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-tabs';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'advanced', 'tab'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Advanced Tabs', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'nav_style', [
                'label'   => esc_html__( 'Tab Style', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style-one' => esc_html__( 'Style One', 'yankee-toolkit' ),
                    'style-two' => esc_html__( 'Style Two', 'yankee-toolkit' ),
                ],
                'default' => 'style-one',
            ]
        );

        $this->add_control(
            'button_position', [
                'label'   => esc_html__( 'Button Position', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'button-top'    => esc_html__( 'Top', 'yankee-toolkit' ),
                    'button-bottom' => esc_html__( 'Bottom', 'yankee-toolkit' ),
                ],
                'default' => 'button-bottom',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'nav_heading',
            [
                'label' => esc_html__( 'Navs', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $repeater->add_control(
            'nav_title', [
                'label'       => esc_html__( 'Nav Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Time Track Options', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'nav_dec', [
                'label'       => esc_html__( 'Nav Description', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => esc_html__( 'Get solid solutions from our end', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'icon_type',
            [
                'label'     => esc_html__( 'Icon Type', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'font',
                'options'   => [
                    'font'  => esc_html__( 'Font Icon', 'yankee-toolkit' ),
                    'image' => esc_html__( 'Image Icon', 'yankee-toolkit' ),
                ],
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'font_icon',
            [
                'label'            => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'far fa-smile-wink',
                    'library' => 'fa-regular',
                ],
                'condition'        => [
                    'icon_type' => 'font',
                ],
            ]
        );

        $repeater->add_control(
            'image_icon',
            [
                'label'     => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $repeater->add_control(
            'nav_content_heading',
            [
                'label'     => esc_html__( 'Content', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'content_type', [
                'label'   => esc_html__( 'Content Type', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'content'  => esc_html__( 'Content', 'yankee-toolkit' ),
                    'template' => esc_html__( 'Templates', 'yankee-toolkit' ),
                ],
                'default' => 'content',
            ]
        );

        $repeater->add_control(
            'template_id',
            [
                'label'     => esc_html__( 'Select Template', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => $this->select_saved_template(),
                'condition' => [
                    'content_type' => 'template',
                ],
            ]
        );

        $repeater->add_control(
            'tab_content',
            [
                'label'      => esc_html__( 'Content', 'yankee-toolkit' ),
                'type'       => Controls_Manager::WYSIWYG,
                'default'    => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusm od tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris.', 'yankee-toolkit' ),
                'show_label' => true,
                'condition'  => [
                    'content_type' => 'content',
                ],
            ]
        );

        $this->add_control(
            'advanced_tabs', [
                'label'       => esc_html__( 'Tabs', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{nav_title}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Tab Nav Area', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'nav_area_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yanke-advanced-tab .tabs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_area_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yanke-advanced-tab .tabs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_area_text_align',
            [
                'label'     => esc_html__( 'Button Align', 'yankee-toolkit' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'     => [
                        'title' => esc_html__( 'Center', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'flex-end'   => [
                        'title' => esc_html__( 'Right', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns' => 'justify-content: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_nav_button_style',
            [
                'label' => esc_html__( 'Nav Button', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'nav_button_gap',
            [
                'label'      => esc_html__( 'Button Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li' => 'padding: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns'    => 'margin: -{{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_button_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label'     => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'nav_button_title_typography',
                'selector' => '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a .title',
            ]
        );

        $this->add_responsive_control(
            'title_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'desc_heading',
            [
                'label'     => esc_html__( 'Description', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'nav_button_title_desc_typography',
                'selector' => '{{WRAPPER}} .yanke-advanced-tab.style-two .advanced-tab-btns li a .nav-desc',
            ]
        );

        $this->start_controls_tabs( 'nav_btn_tabs' );

        $this->start_controls_tab(
            'nav_button_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'nav_normal_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_normal_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_normal_icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a .icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'nav_button_hormal_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a',
            ]
        );

        $this->add_responsive_control(
            'button_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'nav_button_hover_tab',
            ['label' => esc_html__( 'Active', 'yankee-toolkit' )]
        );

        $this->add_control(
            'nav_hover_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a.active, {{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a.active::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_hover_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_hover_icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a.active .icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_hover_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .advanced-tab-btns li a.active' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'content_area',
            [
                'label' => esc_html__( 'Content', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yanke-advanced-tab .tab-content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yanke-advanced-tab .tab-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yanke-advanced-tab .tab-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();
        $dynamic_id = rand( 9, 999999 );

        if ( !empty( $settings['advanced_tabs'] ) ): ?>

            <div class="yanke-advanced-tab <?php echo esc_attr( $settings['button_position'] .' '. $settings['nav_style'] ) ?>">
                <div class="tab-content">
                    <?php foreach ( $settings['advanced_tabs'] as $index => $tab ) :
                        $item_content_count = $index + 1;

                        $content_setting_key = $this->get_repeater_setting_key( 'tab_content', 'tabs', $index );

                        $this->add_render_attribute( $content_setting_key, [
                            'class' => ['tab-pane fade'],
                            'id'    => 'tab-'. $dynamic_id . $item_content_count .'',
                            'role'  => 'tabpanel'
                        ] );

                        if ( $item_content_count == 1 ) {
                            $this->add_render_attribute( $content_setting_key, [
                                'class'         => ['show active'],
                            ] );
                        }
                    ?>
                        <div <?php echo $this->get_render_attribute_string( $content_setting_key ) ?>>
                            <?php
                                if( $tab['content_type'] == 'template' ) {
                                    echo Plugin::$instance->frontend->get_builder_content( $tab['template_id'] );
                                } else {
                                    echo wp_kses_post( wpautop( $tab['tab_content'] ) );
                                }
                            ?>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="tabs-btn">
                    <ul class="nav advanced-tab-btns" role="tablist">
                        <?php foreach ( $settings['advanced_tabs'] as $index => $tab ):

                            $item_title_count = $index + 1;

                            $title_setting_key = $this->get_repeater_setting_key( 'nav_title', 'advanced_tabs', $index );

                            $this->add_render_attribute( $title_setting_key, [
                                'class'       => ['nav-link'],
                                'data-toggle' => 'tab',
                                'href'        => '#tab-'. $dynamic_id . $item_title_count .''
                            ] );

                            if ( $item_title_count == 1 ) {
                                $this->add_render_attribute( $title_setting_key, [
                                    'class' => ['active'],
                                ] );
                            }
                        ?>

                        <li class="nav-item" role="presentation">
                            <a <?php echo $this->get_render_attribute_string( $title_setting_key ) ?>>
                                <?php
                                    if( $tab['icon_type'] == 'image' && !empty( $tab['image_icon']['url'] ) ) {
                                        printf( '<span class="icon"><img src="%1$s"></span>',
                                            esc_url( $tab['image_icon']['url'] )
                                        );
                                    } elseif ( $tab['font_icon']['value'] ) {
                                        printf( '<span class="icon"><i class="%1$s"></i></span>',
                                            esc_attr( $tab['font_icon']['value'] )
                                        );
                                    }

                                    if ( $tab['nav_title'] ) {
                                        printf( '<span class="title">%1$s</span>',
                                            esc_html( $tab['nav_title'] )
                                        );
                                    }

                                    if ( $tab['nav_dec'] ) {
                                        printf( '<span class="nav-desc">%1$s</span>',
                                            esc_html( $tab['nav_dec'] )
                                        );
                                    }
                                ?>
                            </a>
                        </li>

                        <?php endforeach;?>
                    </ul>
                </div>
            </div>

        <?php endif;
    }

    protected function select_saved_template() {
        $args = [
            'post_type'   => 'elementor_library',
            'numberposts' => -1,
            'orderby'     => 'title',
            'order'       => 'ASC',
        ];

        $query_query = get_posts( $args );

        $posts = [];

        if ( $query_query ) {
            foreach ( $query_query as $query ) {
                $posts[$query->ID] = $query->post_title;
            }
        }

        return $posts;
    }

}