<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Banner_Slider extends Widget_Base {

    public function get_name() {
        return 'yankee-banner-slider';
    }

    public function get_title() {
        return esc_html__( 'Banner Slider', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_style_depends() {
        return ['yankee-toolkit', 'animations', 'slick', 'magnific-popup'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'slick', 'magnific-popup'];
    }

    public function get_keywords() {
        return ['yankee', 'slider', 'banner', 'hero'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Banners', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'banner_style',
            [
                'label'   => esc_html__( 'Banner Style', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-one',
                'options' => [
                    'style-one'   => esc_html__( 'Style One', 'yankee-toolkit' ),
                    'style-two'   => esc_html__( 'Style Two', 'yankee-toolkit' ),
                    'style-three' => esc_html__( 'Style Three', 'yankee-toolkit' ),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title_type',
            [
                'label'   => esc_html__( 'Title Tyle', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'normal-title',
                'options' => [
                    'normal-title' => esc_html__( 'Normal Title', 'yankee-toolkit' ),
                    'dual-title'   => esc_html__( 'Dual Title', 'yankee-toolkit' ),
                ],
            ]
        );

        $repeater->add_control(
            'normal_title', [
                'label'       => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'condition'   => [
                    'title_type' => 'normal-title',
                ],
            ]
        );

        $repeater->add_control(
            'dual_title_1', [
                'label'       => esc_html__( 'Title One', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'condition'   => [
                    'title_type' => 'dual-title',
                ],
            ]
        );

        $repeater->add_control(
            'dual_title_2', [
                'label'       => esc_html__( 'Title Two', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'condition'   => [
                    'title_type' => 'dual-title',
                ],
            ]
        );

        $repeater->add_control(
            'title_tag',
            [
                'label'       => esc_html__( 'Title HTML Tag', 'yankee-toolkit' ),
                'type'        => Controls_Manager::CHOOSE,
                'label_block' => true,
                'options'     => [
                    'h1' => [
                        'title' => __( 'H1', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'     => 'h1',
                'toggle'      => false,
            ]
        );

        $repeater->add_control(
            'hr1',
            [
                'type'  => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $repeater->add_control(
            'banner_tags', [
                'label'       => esc_html__( 'Tags', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => '<li>DIGITAL PRODUCT</li><li>UIX SOLUTIONS</li><li>CONSULTANCY</li>',
                'description' => esc_html__( 'Wrap up every list item with li tag (<li>Tag Name</li>).', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'banner_image',
            [
                'label'   => esc_html__( 'Banner Background', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->start_controls_tabs( 'banner_btns' );

        $repeater->start_controls_tab(
            'text_btn_tab',
            ['label' => esc_html__( 'Text Button', 'yankee-toolkit' )]
        );

        $repeater->add_control(
            'use_btn',
            [
                'label'        => esc_html__( 'Show Text Button', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'No', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $repeater->add_control(
            'btn_text',
            [
                'label'       => esc_html__( 'Button Text', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Learn More', 'yankee-toolkit' ),
                'condition'   => [
                    'use_btn' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'btn_url',
            [
                'label'       => esc_html__( 'Button URL', 'yankee-toolkit' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'condition'   => [
                    'use_btn' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'btn_icon',
            [
                'label'       => esc_html__( 'Button Icon', 'yankee-toolkit' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'   => [
                    'use_btn' => 'yes',
                ],
                'default'     => [
                    'value'   => 'far fa-plus',
                    'library' => 'fa-regular',
                ],
            ]
        );

        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            'video_btn_tab',
            ['label' => esc_html__( 'Video Button', 'yankee-toolkit' )]
        );

        $repeater->add_control(
            'use_video_btn',
            [
                'label'        => esc_html__( 'Show video Button', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'No', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $repeater->add_control(
            'video_btn_url',
            [
                'label'       => esc_html__( 'Video URL', 'yankee-toolkit' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'condition'   => [
                    'use_video_btn' => 'yes',
                ],
            ]
        );

        $repeater->end_controls_tab();

        $repeater->add_control(
            'text_align',
            [
                'label'     => esc_html__( 'Text Align', 'yankee-toolkit' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'text-left'   => [
                        'title' => esc_html__( 'Left', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'text-center' => [
                        'title' => esc_html__( 'Center', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'text-right'  => [
                        'title' => esc_html__( 'Right', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'separator' => 'before',
            ]
        );

        $repeater->end_controls_tabs();

        $this->add_control(
            'banners', [
                'label'  => esc_html__( 'Banner items', 'yankee-toolkit' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail',
                'default'   => 'full',
                'separator' => 'before',
                'exclude'   => [
                    'custom',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'portfolio_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'arrow',
            [
                'label'   => esc_html__( 'Arrow?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'dots',
            [
                'label'   => esc_html__( 'Dots?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'fade',
            [
                'label'   => esc_html__( 'Fade?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'   => esc_html__( 'Autoplay?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]

        );

        $this->add_control(
            'autoplay_time',
            [
                'label'     => esc_html__( 'Autoplay Time', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => '5000',
                'condition' => [
                    'autoplay' => 'true',
                ],
                'options'   => [
                    '1000'  => esc_html__( '1s', 'yankee-toolkit' ),
                    '2000'  => esc_html__( '2s', 'yankee-toolkit' ),
                    '3000'  => esc_html__( '3s', 'yankee-toolkit' ),
                    '4000'  => esc_html__( '4s', 'yankee-toolkit' ),
                    '5000'  => esc_html__( '5s', 'yankee-toolkit' ),
                    '6000'  => esc_html__( '6s', 'yankee-toolkit' ),
                    '7000'  => esc_html__( '7s', 'yankee-toolkit' ),
                    '8000'  => esc_html__( '8s', 'yankee-toolkit' ),
                    '9000'  => esc_html__( '9s', 'yankee-toolkit' ),
                    '10000' => esc_html__( '10s', 'yankee-toolkit' ),
                    '11000' => esc_html__( '11s', 'yankee-toolkit' ),
                    '12000' => esc_html__( '12s', 'yankee-toolkit' ),
                    '13000' => esc_html__( '13s', 'yankee-toolkit' ),
                    '14000' => esc_html__( '14s', 'yankee-toolkit' ),
                    '15000' => esc_html__( '15s', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_animations',
            [
                'label' => esc_html__( 'Animation', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
			'important_note',
			[
				'label' => esc_html__( 'Important Note', 'yankee-toolkit' ),
				'type' => Controls_Manager::RAW_HTML,
				'raw' => esc_html__( 'Animation will work after page reload', 'yankee-toolkit' ),
			]
		);

        $this->add_control(
            'title_animation',
            [
                'label'       => esc_html__( 'Title Animation', 'yankee-toolkit' ),
                'type'        => Controls_Manager::ANIMATION,
                'label_block' => true,
                'default'     => 'fadeInUp',
            ]
        );

        $this->add_control(
            'tags_animation',
            [
                'label'       => esc_html__( 'Tags Animation', 'yankee-toolkit' ),
                'type'        => Controls_Manager::ANIMATION,
                'label_block' => true,
                'default'     => 'fadeInDown',
            ]
        );

        $this->add_control(
            'btn_one_animation',
            [
                'label'       => esc_html__( 'Text Btn Animation', 'yankee-toolkit' ),
                'type'        => Controls_Manager::ANIMATION,
                'label_block' => true,
                'default'     => 'fadeInLeft',
            ]
        );

        $this->add_control(
            'btn_two_animation',
            [
                'label'       => esc_html__( 'Video Btn Animation', 'yankee-toolkit' ),
                'type'        => Controls_Manager::ANIMATION,
                'label_block' => true,
                'default'     => 'fadeInRight',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Slider', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'slider_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-bannner-widget .single-banner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slider_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-bannner-widget .single-banner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'overly_color',
            [
                'label'     => esc_html__( 'Overly Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .single-banner::before'                  => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .yankee-bannner-widget .banner-style-three .banner-text::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'overly_color_opacity',
            [
                'label'     => esc_html__( 'Overly Opacity', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .single-banner::before' => 'opacity: {{SIZE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__( 'Content', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .banner-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'dual_titlsse_color', [
                'label'     => esc_html__( 'Dual Title Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .banner-title span' => '-webkit-text-stroke: 2px {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .yankee-bannner-widget .banner-title',
            ]
        );

        $this->add_control(
            'title_tag_heading',
            [
                'label'     => esc_html__( 'Title Tag', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_tag_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .banner-tags' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_tag_typography',
                'selector' => '{{WRAPPER}} .yankee-bannner-widget .banner-tags',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__( 'Button', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'banner_style_btns' );

        $this->start_controls_tab(
            'text_btn_style_tab',
            ['label' => esc_html__( 'Text Button', 'yankee-toolkit' )]
        );

        $this->add_control(
            'button_text_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .banner-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .banner-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_text_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-bannner-widget .banner-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_heading',
            [
                'label'     => esc_html__( 'Hover', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_text_hover_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .banner-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_hover_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .banner-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'video_btn_style_tab',
            ['label' => esc_html__( 'Video Button', 'yankee-toolkit' )]
        );

        $this->add_control(
            'button_video_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .video-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_video_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .video-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_video_width',
            [
                'label'      => esc_html__( 'width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 150,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-bannner-widget .video-btn' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_video_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 150,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-bannner-widget .video-btn' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_video_heading',
            [
                'label'     => esc_html__( 'Hover', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_video_hover_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .video-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_video_hover_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-bannner-widget .video-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_tab();

    }
    protected function render() {
        $settings = $this->get_settings();
        if ( !empty( $settings['banners'] ) ): ?>

            <div class="yankee-bannner-widget" data-arrow="<?php echo esc_attr( $settings['arrow'] ) ?>" data-dots="<?php echo esc_attr( $settings['dots'] ) ?>" data-fade="<?php echo esc_attr( $settings['fade'] ) ?>" data-autoplay="<?php echo esc_attr( $settings['autoplay'] ) ?>" data-autoplayt="<?php echo esc_attr( $settings['autoplay_time'] ) ?>">
                <?php
                    if ( $settings['banner_style'] == 'style-one' ) {
                        include 'banner-parts/banner-one.php';
                    } elseif ( $settings['banner_style'] == 'style-two' ) {
                        include 'banner-parts/banner-two.php';
                    } elseif ( $settings['banner_style'] == 'style-three' ) {
                        include 'banner-parts/banner-three.php';
                    } else {
                        echo '<div class="alert alert-primary"> Select a banner style </div>';
                    }
                ?>
            </div>

        <?php endif;
    }
}