<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Client_logos extends Widget_Base {

    public function get_name() {
        return 'yankee-client-logos';
    }

    public function get_title() {
        return esc_html__( 'Client Logos', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_style_depends() {
        return ['yankee-toolkit', 'slick'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'slick'];
    }

    public function get_keywords() {
        return ['yankee', 'brand', 'carousel', 'slider', 'logos', 'client'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Client Logos', 'yankee-toolkit' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__( 'Logo title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Company name', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'company_url',
            [
                'label'       => esc_html__( 'URL', 'yankee-toolkit' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        $repeater->add_control(
            'company_logo',
            [
                'label'       => esc_html__( 'Logo Image', 'yankee-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'logos', [
                'label'       => esc_html__( 'Items', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'team_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'items_heading',
            [
                'label'     => esc_html__( 'Show Items', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'desktop_item',
            [
                'label'   => esc_html__( 'Desktop', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '5',
                'options' => [
                    '1'  => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4'  => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5'  => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6'  => esc_html__( '6 column', 'yankee-toolkit' ),
                    '7'  => esc_html__( '7 column', 'yankee-toolkit' ),
                    '8'  => esc_html__( '8 column', 'yankee-toolkit' ),
                    '9'  => esc_html__( '9 column', 'yankee-toolkit' ),
                    '10' => esc_html__( '10 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'desktop_sm_item',
            [
                'label'       => esc_html__( 'Desktop (Small)', 'yankee-toolkit' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => '4',
                'options'     => [
                    '1'  => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4'  => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5'  => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6'  => esc_html__( '6 column', 'yankee-toolkit' ),
                    '7'  => esc_html__( '7 column', 'yankee-toolkit' ),
                    '8'  => esc_html__( '8 column', 'yankee-toolkit' ),
                    '9'  => esc_html__( '9 column', 'yankee-toolkit' ),
                    '10' => esc_html__( '10 column', 'yankee-toolkit' ),
                ],
                'description' => esc_html__( 'Item under 1200px.', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'tablet_item',
            [
                'label'   => esc_html__( 'Tablet', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1'  => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4'  => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5'  => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6'  => esc_html__( '6 column', 'yankee-toolkit' ),
                    '7'  => esc_html__( '7 column', 'yankee-toolkit' ),
                    '8'  => esc_html__( '8 column', 'yankee-toolkit' ),
                    '9'  => esc_html__( '9 column', 'yankee-toolkit' ),
                    '10' => esc_html__( '10 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_item',
            [
                'label'   => esc_html__( 'Mobile', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1'  => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4'  => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5'  => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6'  => esc_html__( '6 column', 'yankee-toolkit' ),
                    '7'  => esc_html__( '7 column', 'yankee-toolkit' ),
                    '8'  => esc_html__( '8 column', 'yankee-toolkit' ),
                    '9'  => esc_html__( '9 column', 'yankee-toolkit' ),
                    '10' => esc_html__( '10 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_sm_item',
            [
                'label'   => esc_html__( 'Mobile(Small)', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1'  => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4'  => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5'  => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6'  => esc_html__( '6 column', 'yankee-toolkit' ),
                    '7'  => esc_html__( '7 column', 'yankee-toolkit' ),
                    '8'  => esc_html__( '8 column', 'yankee-toolkit' ),
                    '9'  => esc_html__( '9 column', 'yankee-toolkit' ),
                    '10' => esc_html__( '10 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'arrow',
            [
                'label'     => esc_html__( 'Arrow?', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'false',
                'options'   => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'dots',
            [
                'label'   => esc_html__( 'Dots?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'   => esc_html__( 'Autoplay?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]

        );

        $this->add_control(
            'autoplay_time',
            [
                'label'     => esc_html__( 'Autoplay Time', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => '5000',
                'condition' => [
                    'autoplay' => 'true',
                ],
                'options'   => [
                    '1000'  => esc_html__( '1s', 'yankee-toolkit' ),
                    '2000'  => esc_html__( '2s', 'yankee-toolkit' ),
                    '3000'  => esc_html__( '3s', 'yankee-toolkit' ),
                    '4000'  => esc_html__( '4s', 'yankee-toolkit' ),
                    '5000'  => esc_html__( '5s', 'yankee-toolkit' ),
                    '6000'  => esc_html__( '6s', 'yankee-toolkit' ),
                    '7000'  => esc_html__( '7s', 'yankee-toolkit' ),
                    '8000'  => esc_html__( '8s', 'yankee-toolkit' ),
                    '9000'  => esc_html__( '9s', 'yankee-toolkit' ),
                    '10000' => esc_html__( '10s', 'yankee-toolkit' ),
                    '11000' => esc_html__( '11s', 'yankee-toolkit' ),
                    '12000' => esc_html__( '12s', 'yankee-toolkit' ),
                    '13000' => esc_html__( '13s', 'yankee-toolkit' ),
                    '14000' => esc_html__( '14s', 'yankee-toolkit' ),
                    '15000' => esc_html__( '15s', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Testimonial Box', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'testimonial_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-testimonial-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'testimonial_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-testimonial-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'testimonial_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_heading',
            [
                'label' => esc_html__( 'Name', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .testimonial-info .name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typography',
                'selector' => '{{WRAPPER}} .yankee-testimonial-slider .testimonial-info .name',
            ]
        );

        $this->add_control(
            'position_heading',
            [
                'label'     => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'position_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .testimonial-info .job' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'position_typography',
                'selector' => '{{WRAPPER}} .yankee-testimonial-slider .testimonial-info .job',
            ]
        );

        $this->add_control(
            'content_heading',
            [
                'label'     => esc_html__( 'Content', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typography',
                'selector' => '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial p',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'testimonial_image',
            [
                'label' => esc_html__( 'Image', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'width',
            [
                'label'          => __( 'Width', 'yankee-toolkit' ),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .yankee-client-logos img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'space',
            [
                'label'          => __( 'Max Width', 'yankee-toolkit' ),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .yankee-client-logos img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label'          => __( 'Height', 'yankee-toolkit' ),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units'     => ['px', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .yankee-client-logos img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'image_border',
                'selector'  => '{{WRAPPER}} .yankee-client-logos img',
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => __( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-client-logos img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'image_effects' );

        $this->start_controls_tab( 'normal',
            [
                'label' => __( 'Normal', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'opacity',
            [
                'label'     => __( 'Opacity', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'max'  => 1,
                        'min'  => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .yankee-client-logos img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab( 'hover',
            [
                'label' => __( 'Hover', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'opacity_hover',
            [
                'label'     => __( 'Opacity', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'max'  => 1,
                        'min'  => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .yankee-client-logos img:hover' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        if ( ! empty( $settings['logos'] ) ) : ?>

            <div class="yankee-client-logos row" data-lgitem="<?php echo esc_attr( $settings['desktop_item'] ) ?>" data-lgsmitem="<?php echo esc_attr( $settings['desktop_sm_item'] ) ?>" data-mditem="<?php echo esc_attr( $settings['tablet_item'] ) ?>" data-smitem="<?php echo esc_attr( $settings['mobile_item'] ) ?>" data-xsitem="<?php echo esc_attr( $settings['mobile_sm_item'] ) ?>" data-arrow="<?php echo esc_attr( $settings['arrow'] ) ?>" data-dots="<?php echo esc_attr( $settings['dots'] ) ?>" data-autoplay="<?php echo esc_attr( $settings['autoplay'] ) ?>" data-autoplayt="<?php echo esc_attr( $settings['autoplay_time'] ) ?>">

                <?php foreach ( $settings['logos'] as $logo ) : ?>
                    <div class="single-logo col">
                        <a href="<?php echo esc_url( $logo['company_url']['url'] ) ?>" target="_blank">
                            <?php if( !empty( $logo['company_logo']['url'] ) ) : ?>
                                <img src="<?php echo esc_url( $logo['company_logo']['url'] ) ?>" alt="<?php echo esc_html( $logo['title'] ) ?>">
                            <?php endif; ?>
                        </a>
                    </div>
                <?php endforeach; ?>

            </div>
        <?php endif;
    }
}