<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Counter_Boxes extends Widget_Base {

    public function get_name() {
        return 'yankee-counter-boxes';
    }

    public function get_title() {
        return esc_html__( 'Counter Boxes', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-counter';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'jquery-inview'];
    }

    public function get_keywords() {
        return ['yankee', 'counter', 'box'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Counter', 'yankee-toolkit' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label'       => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Counter Title', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'counter_number',
            [
                'label'   => esc_html__( 'Number', 'yankee-toolkit' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 3500,
            ]
        );

        $repeater->add_control(
            'counter_suffix',
            [
                'label'     => esc_html__( 'Number Suffix', 'yankee-toolkit' ),
                'type'      => Controls_Manager::TEXT,
                'default'   => '+',
                'selectors' => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box .count::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
            'font_icon',
            [
                'label'            => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'far fa-smile-wink',
                    'library' => 'fa-regular',
                ],
            ]
        );

        $this->add_control(
            'counter_boxes', [
                'label'       => esc_html__( 'Counter Boxes', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'column_heading',
            [
                'label'     => esc_html__( 'Column', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'desktop_col',
            [
                'label'   => esc_html__( 'Desktop', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-lg-3',
                'options' => [
                    'col-lg-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-lg-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-lg-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-lg-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'tablet_col',
            [
                'label'   => esc_html__( 'Tablet', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-md-6',
                'options' => [
                    'col-md-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-md-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-md-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-md-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_col',
            [
                'label'   => esc_html__( 'Mobile', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-sm-6',
                'options' => [
                    'col-sm-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-sm-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-sm-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-sm-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_sm_col',
            [
                'label'   => esc_html__( 'Mobile(Small)', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-12',
                'options' => [
                    'col-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Counter Box', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label'   => esc_html__( 'Text Align', 'yankee-toolkit' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'icon-content',
            [
                'label' => esc_html__( 'Icon', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_heading',
            [
                'label' => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box .icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label'      => esc_html__( 'Size', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box .icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label'     => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .yankee-counter-boxes .counter-box .title',
            ]
        );

        $this->add_control(
            'counter_heading',
            [
                'label'     => esc_html__( 'Counter', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'counter_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box .count' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'counter_typography',
                'selector' => '{{WRAPPER}} .yankee-counter-boxes .counter-box .count',
            ]
        );

        $this->add_responsive_control(
            'counter_bottom_gap',
            [
                'label'     => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box .count' => 'margin-bottom: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'counter_suff_heading',
            [
                'label'     => esc_html__( 'Counter Suffix', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'counter_suff_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-counter-boxes .counter-box .count::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'counter_suff_typography',
                'selector' => '{{WRAPPER}} .yankee-counter-boxes .counter-box .count::after',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        $column = $settings['desktop_col'] .' '. $settings['tablet_col'] .' '. $settings['mobile_col'] .' '. $settings['mobile_sm_col'];

        if ( ! empty( $settings['counter_boxes'] ) ) : ?>
            <div class="yankee-counter-boxes row" <?php if( !empty( $box['counter_suffix'] ) ) : ?>data-before="<?php echo esc_attr( $box['counter_suffix'] ) ?>"<?php endif; ?>>
                <?php foreach ( $settings['counter_boxes'] as $box ) : ?>
                    <div class="<?php echo esc_attr( $column ) ?>">
                        <div class="counter-box">
                            <?php
                                if( !empty( $box['font_icon']['value'] ) ) {
                                    printf( '<div class="icon"><i class="%1$s"></i></div>',
                                        esc_attr( $box['font_icon']['value'] )
                                    );
                                }

                                if( !empty( $box['counter_number'] ) ) {
                                    printf( '<span class="count">%1$s</span>',
                                        esc_attr( $box['counter_number'] )
                                    );
                                }

                                if( !empty( $box['title'] ) ) {
                                    printf( '<span class="title">%1$s</span>',
                                        esc_attr( $box['title'] )
                                    );
                                }
                            ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif;
    }
}