<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Feature_Box extends Widget_Base {

    public function get_name() {
        return 'yankee-feature-box';
    }

    public function get_title() {
        return esc_html__( 'Feature Boxes', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'icon', 'iconic', 'box', 'feature'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Items', 'yankee-toolkit' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label'       => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Security & Location', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'title_tag',
            [
                'label'       => esc_html__( 'Title HTML Tag', 'yankee-toolkit' ),
                'type'        => Controls_Manager::CHOOSE,
                'label_block' => true,
                'options'     => [
                    'h2' => [
                        'title' => __( 'H2', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'     => 'h5',
                'toggle'      => false,
            ]
        );

        $repeater->add_control(
            'use_title_link',
            [
                'label'        => esc_html__( 'Use title as link?', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'No', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $repeater->add_control(
            'title_url',
            [
                'label'     => esc_html__( 'Url', 'yankee-toolkit' ),
                'type'      => Controls_Manager::URL,
                'default'   => [
                    'url' => '#',
                ],
                'condition' => [
                    'use_title_link' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'desc', [
                'label'       => esc_html__( 'Description', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => esc_html__( 'Lorem ipsum dolor sit ame t, consectetur adipisicing el it, sed do eiusm od tem.', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'hr',
            [
                'type'  => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $repeater->add_control(
            'icon_type',
            [
                'label'   => esc_html__( 'Icon Type', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'font'  => esc_html__( 'Font Icon', 'yankee-toolkit' ),
                    'image' => esc_html__( 'Image Icon', 'yankee-toolkit' ),
                ],
            ]
        );

        $repeater->add_control(
            'font_icon',
            [
                'label'            => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'far fa-smile-wink',
                    'library' => 'fa-regular',
                ],
                'condition'        => [
                    'icon_type' => 'font',
                ],
            ]
        );

        $repeater->add_control(
            'image_icon',
            [
                'label'     => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $repeater->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'yankee-toolkit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .icon' => 'color: {{VALUE}}',
                ],
                'condition'        => [
                    'icon_type' => 'font',
                ],
			]
        );

        $repeater->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__( 'Icon Background', 'yankee-toolkit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .icon' => 'background-color: {{VALUE}}',
                ],
                'condition'        => [
                    'icon_type' => 'font',
                ],
			]
        );

        $repeater->add_control(
            'hr2',
            [
                'type'  => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->add_control(
            'feature_boxes', [
                'label'       => esc_html__( 'Box items', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'column_heading',
            [
                'label'     => esc_html__( 'Column', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'desktop_col',
            [
                'label'   => esc_html__( 'Desktop', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-lg-12',
                'options' => [
                    'col-lg-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-lg-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-lg-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-lg-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'tablet_col',
            [
                'label'   => esc_html__( 'Tablet', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-md-12',
                'options' => [
                    'col-md-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-md-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-md-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-md-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_col',
            [
                'label'   => esc_html__( 'Mobile', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-sm-12',
                'options' => [
                    'col-sm-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-sm-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-sm-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_sm_col',
            [
                'label'   => esc_html__( 'Mobile(Small)', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-12',
                'options' => [
                    'col-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Feature box', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_align',
            [
                'label'     => esc_html__( 'Text Align', 'yankee-toolkit' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'text-left'   => [
                        'title' => esc_html__( 'Left', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'text-center' => [
                        'title' => esc_html__( 'Center', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'text-right'  => [
                        'title' => esc_html__( 'Right', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'text-left',
            ]
        );

        $this->add_control(
            'icon_position',
            [
                'label'   => esc_html__( 'Icon Position', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'icon-top',
                'options' => [
                    'icon-top'    => esc_html__( 'Icon Top', 'yankee-toolkit' ),
                    'icon-left'  => esc_html__( 'Icon Left', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'hr3',
            [
                'type'  => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'box_tabs' );

        $this->start_controls_tab(
            'box_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'box_normal_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'box_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'box_hoverl_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'icon_style_setting',
            [
                'label' => esc_html__( 'Icon', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_width',
            [
                'label'      => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .icon' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box.icon-left' => 'grid-template-columns: {{SIZE}}{{UNIT}} 1fr;',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .icon' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label'      => esc_html__( 'Size', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .icon img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__( 'Content', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hr4',
            [
                'type'  => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .title, {{WRAPPER}} .yankee-feature-boxes .feature-box .title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box:hover .title, {{WRAPPER}} .yankee-feature-boxes .feature-box:hover .title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .yankee-feature-boxes .feature-box .title',
            ]
        );

        $this->add_responsive_control(
            'title_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hr5',
            [
                'type'  => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->add_control(
            'dec_heading',
            [
                'label' => esc_html__( 'Description', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'desc_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes .feature-box:hover p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'desc_typography',
                'selector' => '{{WRAPPER}} .yankee-feature-boxes .feature-box p',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        $column = $settings['desktop_col'] .' '. $settings['tablet_col'] .' '. $settings['mobile_col'] .' '. $settings['mobile_sm_col'];

        if ( ! empty( $settings['feature_boxes'] ) ) : ?>
            <div class="yankee-feature-boxes row">
                <?php foreach ( $settings['feature_boxes'] as $index => $box ) : ?>
                    <div class="<?php echo esc_attr( $column ) ?>">
                        <div class="feature-box <?php echo esc_attr( $settings['text_align'] ) .' '. esc_attr( $settings['icon_position'] ) .' '. esc_attr( 'elementor-repeater-item-' . $box['_id'] . '' );  ?>">
                            <div class="icon">
                                <?php if( $box['icon_type'] == 'font' ) : ?>
                                    <i class="<?php echo esc_attr( $box['font_icon']['value'] ); ?>"></i>
                                <?php endif; if( $box['icon_type'] == 'image' ) : ?>
                                    <img src="<?php echo esc_attr( $box['image_icon']['url'] ); ?>" alt="<?php echo esc_attr( $box['title'] ); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="desc">
                                <?php

                                    $target = $box['title_url']['is_external'] ? ' target="_blank"' : '';
                                    $nofollow = $box['title_url']['nofollow'] ? ' rel="nofollow"' : '';

                                    if( $box['title'] ) {
                                        if ( $box['title_url']['url'] && $box['use_title_link'] == 'yes' ) {
                                            printf( '<%1$s class="title"><a href="%2$s" %3$s %4$s>%5$s</a></%1$s>',
                                                tag_escape( $box['title_tag'] ),
                                                esc_url( $box['title_url']['url'] ),
                                                $target,
                                                $nofollow,
                                                esc_html( $box['title'] )
                                            );
                                        } else {
                                            printf( '<%1$s class="title">%2$s</%1$s>',
                                                tag_escape( $box['title_tag'] ),
                                                esc_html( $box['title'] )
                                            );
                                        }
                                    }

                                    if( $box['desc'] ) {
                                        echo wpautop( esc_html( $box['desc'] ) );
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif;
    }
}