<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Iconic_Box extends Widget_Base {

    public function get_name() {
        return 'yankee-iconic-box';
    }

    public function get_title() {
        return esc_html__( 'Iconic Boxes', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'icon', 'iconic', 'box', 'feature'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Items', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'icon_style',
            [
                'label'   => esc_html__( 'Style', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-one',
                'options' => [
                    'style-one' => esc_html__( 'Style One', 'yankee-toolkit' ),
                    'style-two' => esc_html__( 'Style Two', 'yankee-toolkit' ),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label'       => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Level Research', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'title_tag',
            [
                'label'       => esc_html__( 'Title HTML Tag', 'yankee-toolkit' ),
                'type'        => Controls_Manager::CHOOSE,
                'label_block' => true,
                'options'     => [
                    'h1' => [
                        'title' => __( 'H1', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'     => 'h4',
                'toggle'      => false,
            ]
        );

        $repeater->add_control(
            'hr',
            [
                'type'  => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $repeater->add_control(
            'icon_type',
            [
                'label'   => esc_html__( 'Icon Type', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'font'  => esc_html__( 'Font Icon', 'yankee-toolkit' ),
                    'image' => esc_html__( 'Image Icon', 'yankee-toolkit' ),
                ],
            ]
        );

        $repeater->add_control(
            'font_icon',
            [
                'label'            => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'far fa-smile-wink',
                    'library' => 'fa-regular',
                ],
                'condition'        => [
                    'icon_type' => 'font',
                ],
            ]
        );

        $repeater->add_control(
            'image_icon',
            [
                'label'     => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $repeater->add_control(
            'hr2',
            [
                'type'  => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->add_control(
            'iconic_boxes', [
                'label'       => esc_html__( 'Box items', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'column_heading',
            [
                'label'     => esc_html__( 'Column', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'desktop_col',
            [
                'label'   => esc_html__( 'Desktop', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '5',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4' => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5' => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6' => esc_html__( '6 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'tablet_col',
            [
                'label'   => esc_html__( 'Tablet', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4' => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5' => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6' => esc_html__( '6 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_col',
            [
                'label'   => esc_html__( 'Mobile', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4' => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5' => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6' => esc_html__( '6 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_sm_col',
            [
                'label'   => esc_html__( 'Mobile(Small)', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4' => esc_html__( '4 column', 'yankee-toolkit' ),
                    '5' => esc_html__( '5 column', 'yankee-toolkit' ),
                    '6' => esc_html__( '6 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Icon box', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label'   => esc_html__( 'Text Align', 'yankee-toolkit' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'box_tabs' );

        $this->start_controls_tab(
            'box_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'box_normal_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this-> end_controls_tab();

        $this->start_controls_tab(
            'box_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'box_hoverl_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'box_hoverl_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box::before' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this-> end_controls_tab();

        $this-> end_controls_tabs();

        $this-> end_controls_section();

        $this->start_controls_section(
            'content_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_heading',
            [
                'label' => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box .icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box:hover .icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label'      => esc_html__( 'Size', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-iconic-boxes .icon-box:hover .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .yankee-iconic-boxes .icon-box .title',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        if ( ! empty( $settings['iconic_boxes'] ) ) : ?>
            <div class="yankee-iconic-boxes<?php if ( $settings['icon_style'] == 'style-two' ) : ?> masonry-layout<?php endif; ?> lg-<?php echo esc_attr( $settings['desktop_col'] ) ?> md-<?php echo esc_attr( $settings['tablet_col'] ) ?> sm-<?php echo esc_attr( $settings['mobile_col'] ) ?> xs-<?php echo esc_attr( $settings['mobile_sm_col'] ) ?>">
                <?php foreach ( $settings['iconic_boxes'] as $index => $box ) : ?>
                    <div class="icon-box">
                        <div class="icon">
                            <?php if( $box['icon_type'] == 'font' ) : ?>
                                <i class="<?php echo esc_attr( $box['font_icon']['value'] ); ?>"></i>
                            <?php endif; if( $box['icon_type'] == 'image' ) : ?>
                                <img src="<?php echo esc_attr( $box['image_icon']['url'] ); ?>" alt="<?php echo esc_attr( $box['title'] ); ?>">
                            <?php endif; ?>
                        </div>
                        <?php
                            if( $box['title'] ) {
                                printf( '<%1$s class="title">%2$s</%1$s>',
                                    tag_escape( $box['title_tag'] ),
                                    esc_html( $box['title'] )
                                );
                            }
                        ?>
                    </div>

                <?php endforeach; ?>
            </div>
        <?php endif;
    }
}