<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Testimonial_Slider extends Widget_Base {

    public function get_name() {
        return 'yankee-testimonial-slider';
    }

    public function get_title() {
        return esc_html__( 'Testimonial Slider', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_style_depends() {
        return ['yankee-toolkit', 'slick'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'slick'];
    }

    public function get_keywords() {
        return ['yankee', 'testimonial', 'carousel', 'slider'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Testimonial', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label'   => esc_html__( 'Style', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-one',
                'options' => [
                    'style-one' => esc_html__( 'Style One', 'yankee-toolkit' ),
                    'style-two' => esc_html__( 'Style Two', 'yankee-toolkit' ),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'testimonial_content',
            [
                'label'   => esc_html__( 'Content', 'yankee-toolkit' ),
                'type'    => Controls_Manager::TEXTAREA,
                'rows'    => '10',
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'testimonial_image',
            [
                'label'   => esc_html__( 'Choose Image', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'testimonial_name',
            [
                'label'   => esc_html__( 'Name', 'yankee-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__( 'John Doe', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'testimonial_job',
            [
                'label'   => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__( 'Designer', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'testimonials', [
                'label'       => esc_html__( 'Testimonial items', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{testimonial_name}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'team_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'items_heading',
            [
                'label' => esc_html__( 'Show Items', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'desktop_item',
            [
                'label'   => esc_html__( 'Desktop', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4' => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'tablet_item',
            [
                'label'   => esc_html__( 'Tablet', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4' => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_item',
            [
                'label'   => esc_html__( 'Mobile', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_sm_item',
            [
                'label'   => esc_html__( 'Mobile(Small)', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'hr1', [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'arrow',
            [
                'label'   => esc_html__( 'Arrow?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'dots',
            [
                'label'   => esc_html__( 'Dots?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'   => esc_html__( 'Autoplay?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]

        );

        $this->add_control(
            'autoplay_time',
            [
                'label'     => esc_html__( 'Autoplay Time', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => '5000',
                'condition' => [
                    'autoplay' => 'true',
                ],
                'options'   => [
                    '1000'  => esc_html__( '1s', 'yankee-toolkit' ),
                    '2000'  => esc_html__( '2s', 'yankee-toolkit' ),
                    '3000'  => esc_html__( '3s', 'yankee-toolkit' ),
                    '4000'  => esc_html__( '4s', 'yankee-toolkit' ),
                    '5000'  => esc_html__( '5s', 'yankee-toolkit' ),
                    '6000'  => esc_html__( '6s', 'yankee-toolkit' ),
                    '7000'  => esc_html__( '7s', 'yankee-toolkit' ),
                    '8000'  => esc_html__( '8s', 'yankee-toolkit' ),
                    '9000'  => esc_html__( '9s', 'yankee-toolkit' ),
                    '10000' => esc_html__( '10s', 'yankee-toolkit' ),
                    '11000' => esc_html__( '11s', 'yankee-toolkit' ),
                    '12000' => esc_html__( '12s', 'yankee-toolkit' ),
                    '13000' => esc_html__( '13s', 'yankee-toolkit' ),
                    '14000' => esc_html__( '14s', 'yankee-toolkit' ),
                    '15000' => esc_html__( '15s', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Testimonial Box', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'testimonial_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-testimonial-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'testimonial_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-testimonial-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'testimonial_background',
                'label'    => esc_html__( 'Background', 'yankee-toolkit' ),
                'types'    => ['classic'],
                'selector' => '{{WRAPPER}} .yankee-testimonial-slider',
            ]
        );

        $this->add_control(
            'item_heading',
            [
                'label'     => esc_html__( 'Items', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'testimonial_item_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'testimonial_item_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'testimonial_item_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'testimonial_item_shadow',
                'selector' => '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_heading',
            [
                'label' => esc_html__( 'Name', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .testimonial-info .name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typography',
                'selector' => '{{WRAPPER}} .yankee-testimonial-slider .testimonial-info .name',
            ]
        );

        $this->add_control(
            'position_heading',
            [
                'label'     => esc_html__( 'Position', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'position_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .testimonial-info .job' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'position_typography',
                'selector' => '{{WRAPPER}} .yankee-testimonial-slider .testimonial-info .job',
            ]
        );

        $this->add_control(
            'content_heading',
            [
                'label'     => esc_html__( 'Content', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typography',
                'selector' => '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial p',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'testimonial_image',
            [
                'label' => esc_html__( 'Image', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image_size',
            [
                'label'      => __( 'Image Size', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 20,
                        'max' => 500,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-testimonial-slider .testimonial-img img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'image_border',
                'selector'  => '{{WRAPPER}} .yankee-testimonial-slider .testimonial-img img',
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => __( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-testimonial-slider .testimonial-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'quote_heading',
            [
                'label'     => esc_html__( 'Quote Icon', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'layout_style' => 'style-two',
                ],
            ]
        );

        $this->add_control(
            'quote_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial .testimonial-img::after' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'layout_style' => 'style-two',
                ],
            ]
        );

        $this->add_control(
            'quote_bg_color',
            [
                'label'     => esc_html__( 'Background color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-testimonial-slider .single-testimonial .testimonial-img::after' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'layout_style' => 'style-two',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        if ( ! empty( $settings['testimonials'] ) ) : ?>

            <div class="yankee-testimonial-slider row <?php echo esc_attr( $settings['layout_style'] ) ?>" data-lgitem="<?php echo esc_attr( $settings['desktop_item'] ) ?>" data-mditem="<?php echo esc_attr( $settings['tablet_item'] ) ?>" data-smitem="<?php echo esc_attr( $settings['mobile_item'] ) ?>" data-xsitem="<?php echo esc_attr( $settings['mobile_sm_item'] ) ?>" data-arrow="<?php echo esc_attr( $settings['arrow'] ) ?>" data-dots="<?php echo esc_attr( $settings['dots'] ) ?>" data-autoplay="<?php echo esc_attr( $settings['autoplay'] ) ?>" data-autoplayt="<?php echo esc_attr( $settings['autoplay_time'] ) ?>">
                <?php foreach ( $settings['testimonials'] as $testi ) : ?>

                <div class="col">
                    <div class="single-testimonial">
                        <?php if( $testi['testimonial_image']['url'] ) : ?>
                            <div class="testimonial-img">
                                <img src="<?php echo esc_url( $testi['testimonial_image']['url'] ) ?>" alt="<?php echo esc_html( $testi['testimonial_name'] ) ?>">
                            </div>
                        <?php endif; ?>
                        <div class="testimonial-content">
                            <?php
                                if( $testi['testimonial_content'] ) {
                                    echo wpautop( esc_html( $testi['testimonial_content'] ) );
                                }
                            ?>
                            <div class="testimonial-info">
                                <?php
                                    if( $testi['testimonial_name'] ) {
                                        printf( '<h4 class="name">%1$s</h4>',
                                            esc_html( $testi['testimonial_name'] )
                                        );
                                    }

                                    if( $testi['testimonial_job'] ) {
                                        printf( '<span class="job">%1$s</span>',
                                            esc_html( $testi['testimonial_job'] )
                                        );
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php endforeach; ?>
            </div>
        <?php endif;
    }
}