<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Video extends Widget_Base {

    public function get_name() {
        return 'yankee-video';
    }

    public function get_title() {
        return esc_html__( 'Video', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-youtube';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'magnific-popup'];
    }

    public function get_keywords() {
        return ['yankee', 'video', 'youtube'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Video', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'btn_position',
            [
                'label'   => esc_html__( 'Video Button Position', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'center',
                'options' => [
                    'top' => esc_html__( 'Top', 'yankee-toolkit' ),
                    'bottom' => esc_html__( 'Bottom', 'yankee-toolkit' ),
                    'left' => esc_html__( 'Left', 'yankee-toolkit' ),
                    'right' => esc_html__( 'Right', 'yankee-toolkit' ),
                    'center' => esc_html__( 'Center', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'video_url',
            [
                'label'       => esc_html__( 'Video Url', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'video_thumb',
            [
                'label'   => esc_html__( 'Video thumb', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail',
                'default'   => 'full',
                'separator' => 'before',
                'exclude'   => [
                    'custom',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Video', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'video_width',
            [
                'label'          => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .yankee-video' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_height',
            [
                'label'          => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .yankee-video' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'play_icon_style',
            [
                'label' => esc_html__( 'Play Icon', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'play_icon_width',
            [
                'label'          => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 150,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .yankee-video .popup-video' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'play_icon_height',
            [
                'label'          => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 150,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .yankee-video .popup-video' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'play_icon_size',
            [
                'label'          => esc_html__( 'Icon Size', 'yankee-toolkit' ),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .yankee-video .popup-video i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'play_icon_tabs' );

        $this->start_controls_tab(
            'play_icon_normal',
            [
                'label' => esc_html__( 'Normal', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .yankee-video .popup-video' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .yankee-video .popup-video' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pulse_color',
            [
                'label'     => esc_html__( 'Pulse Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .yankee-video .popup-video::before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'play_icon_Hover',
            [
                'label' => esc_html__( 'Hover', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .yankee-video .popup-video:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_hover_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .yankee-video .popup-video:hover' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pulse_hover_color',
            [
                'label'     => esc_html__( 'Pulse Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .yankee-video .popup-video:hover::before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();

        $image_one = wp_get_attachment_image_url( $settings['video_thumb']['id'], $settings['thumbnail_size'] );
        if ( !$image_one ) {
            $image_one = $settings['video_thumb']['url'];
        }
        if ( $settings['video_url'] ) { ?>
                <div class="yankee-video <?php echo esc_attr( $settings['btn_position'] ) ?>" <?php if ( $image_one ): ?>style="background-image: url(<?php echo esc_url( $image_one ) ?>);" <?php endif;?>>
                    <a href="<?php echo esc_url( $settings['video_url'] ) ?>" class="popup-video">
                        <i class="fas fa-play"></i>
                    </a>
                </div>
        <?php }
    }
}