<?php

/**
 * Registering meta boxes
 *
 * Using Meta Box plugin: https://codestarframework.com/
 *
 * @see https://codestarframework.com/documentation/

 */

if ( !defined( 'ABSPATH' ) ) {die;}

if ( class_exists( 'CSF' ) ) {

    // Page Meta
    $page_prefix = 'yankee_page_metaboxes';

    CSF::createMetabox( $page_prefix, [
        'title'     => esc_html__( 'Yankee Page Options', 'yankee-toolkit' ),
        'post_type' => 'page',
    ] );

    CSF::createSection( $page_prefix, [
        'title'  => esc_html__( 'Page Layout', 'yankee-toolkit' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Page Layout', 'yankee-toolkit' ),
            ],
            [
                'type'    => 'image_select',
                'id'      => 'page_layout',
                'title'   => esc_html__( 'Layout', 'yankee-toolkit' ),
                'options' => [
                    'boxed-layout'     => plugins_url( 'img/boxed-layout.jpg', __FILE__ ),
                    'fullwidth-layout' => plugins_url( 'img/fullwidth-layout.jpg', __FILE__ ),
                ],
                'default' => 'boxed-layout',
                'desc'    => esc_html__( 'Select Page layout. Boxed or Full Width', 'yankee-toolkit' ),
            ],
            [
                'type'    => 'image_select',
                'id'      => 'page_sidebar',
                'title'   => esc_html__( 'Sidebar', 'yankee-toolkit' ),
                'options' => [
                    'left-sidebar'  => plugins_url( 'img/left-sidebar.jpg', __FILE__ ),
                    'right-sidebar' => plugins_url( 'img/right-sidebar.jpg', __FILE__ ),
                    'no-sidebar'    => plugins_url( 'img/no-sidebar.jpg', __FILE__ ),
                ],
                'default' => 'no-sidebar',
                'desc'    => esc_html__( 'Select Page Sidebar. Left sidebar or right sidebar or No sidebar', 'yankee-toolkit' ),
            ],
            [
                'id'    => 'remove_padding',
                'type'  => 'switcher',
                'title' => esc_html__( 'Remove Page Padding', 'yankee-toolkit' ),
                'desc'  => esc_html__( 'It will Remove default padding(Top, Bottom, Left, Right) of this page', 'yankee-toolkit' ),
            ],
        ],
    ] );

    CSF::createSection( $page_prefix, [
        'title'  => esc_html__( 'Page Heading', 'yankee-toolkit' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Page Heading', 'yankee' ),
            ],
            [
                'id'      => 'page_heading',
                'type'    => 'button_set',
                'title'   => esc_html__( 'Enable Page Heading?', 'yankee' ),
                'options' => [
                    'enabled'  => esc_html( 'Enabled', 'yankee' ),
                    'disabled' => esc_html( 'Disabled', 'yankee' ),
                ],
                'default' => 'enabled',
            ],
            [
                'type'       => 'text',
                'id'         => 'page_title_tag',
                'title'      => esc_html__( 'Title tag', 'yankee-toolkit' ),
                'default'    => esc_html__( 'Welcome to our company', 'yankee-toolkit' ),
                'dependency' => [
                    'page_heading', '==', 'enabled',
                ],
            ],
            [
                'id'         => 'use_page_custom_title',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Custom Title?', 'yankee' ),
                'desc'       => esc_html__( 'Use custom title instead of the page title', 'yankee-toolkit' ),
                'dependency' => [
                    'page_heading', '==', 'enabled',
                ],
            ],
            [
                'type'       => 'text',
                'id'         => 'page_custom_title',
                'title'      => esc_html__( 'Custom Title', 'yankee-toolkit' ),
                'default'    => esc_html__( 'Custom title', 'yankee-toolkit' ),
                'dependency' => [
                    [
                        'page_heading', '==', 'enabled',
                    ],
                    [
                        'use_page_custom_title', '==', 'true',
                    ],
                ],
            ],
        ],
    ] );

    CSF::createSection( $page_prefix, [
        'title'  => esc_html__( 'Header', 'yankee-toolkit' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Header', 'yankee' ),
            ],
            [
                'type'    => 'image_select',
                'id'      => 'page_header_layout',
                'title'   => esc_html__( 'Layout', 'yankee-toolkit' ),
                'options' => [
                    'header-one'   => plugins_url( 'img/header-one.png', __FILE__ ),
                    'header-two'   => plugins_url( 'img/header-two.png', __FILE__ ),
                    'header-three' => plugins_url( 'img/header-three.png', __FILE__ ),
                    'header-four'  => plugins_url( 'img/header-four.png', __FILE__ ),
                ],
                'default' => 'boxed-layout',
                'desc'    => esc_html__( 'Select A header style if you want to use a different header for this page', 'yankee-toolkit' ),
            ],
            [
                'id'    => 'page_sticky_header',
                'type'  => 'switcher',
                'title' => esc_html__( 'Sticky header', 'yankee' ),
                'desc'  => esc_html__( 'It will stick header at the top when page scrolling', 'yankee-toolkit' ),
            ],
        ],
    ] );

    CSF::createSection( $page_prefix, [
        'title'  => esc_html__( 'Footer', 'yankee-toolkit' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Footer', 'yankee' ),
            ],
            [
                'id'            => 'page_footer_template',
                'type'          => 'select',
                'title'         => esc_html__( 'Select Footer', 'yankee' ),
                'placeholder'   => esc_html__( 'Select Footer', 'yankee' ),
                'options'       => 'posts',
                'empty_message' => esc_html__( 'No Footer Template Found. You can create footer template from Footer>Add New ', 'yankee' ),
                'query_args'    => [
                    'post_type' => 'footer',
                ],
                'desc'          => esc_html__( 'Select a Footer template if you want to use different footer for this page.', 'yankee' ),
            ],
        ],
    ] );

    // Post Meta (Gallery)
    $galley_post_prefix = 'yankee_post_gallry_meta';

    CSF::createMetabox( $galley_post_prefix, [
        'title'        => esc_html__( 'Yankee Galley Options', 'yankee-toolkit' ),
        'post_type'    => 'post',
        'post_formats' => 'gallery',
    ] );

    CSF::createSection( $galley_post_prefix, [
        'fields' => [
            [
                'id'    => 'post_gallery',
                'type'  => 'gallery',
                'title' => esc_html( 'Gallery Images', 'yankee' ),
                'desc'  => esc_html__( 'Choose your Gallery Images', 'yankee-toolkit' ),
            ],
        ],
    ] );

    // Post Meta(Link)
    $link_post_prefix = 'yankee_post_link_meta';

    CSF::createMetabox( $link_post_prefix, [
        'title'        => esc_html__( 'Yankee Link Options', 'yankee-toolkit' ),
        'post_type'    => 'post',
        'post_formats' => 'link',
    ] );

    CSF::createSection( $link_post_prefix, [
        'fields' => [
            [
                'id'    => 'post_link_url',
                'type'  => 'text',
                'title' => esc_html__( 'Link', 'yankee-toolkit' ),
                'desc'  => esc_html__( 'Type your link. Example: https://webtend.net', 'yankee-toolkit' ),
            ],
            [
                'id'    => 'post_link_text',
                'type'  => 'text',
                'title' => esc_html__( 'Link Text', 'yankee-toolkit' ),
            ],
        ],
    ] );

    // Post Meta(Quote)
    $quote_post_prefix = 'yankee_post_quote_meta';

    CSF::createMetabox( $quote_post_prefix, [
        'title'        => esc_html__( 'Yankee Quote Options', 'yankee-toolkit' ),
        'post_type'    => 'post',
        'post_formats' => 'quote',
    ] );

    CSF::createSection( $quote_post_prefix, [
        'fields' => [
            [
                'id'    => 'post_quote_text',
                'type'  => 'textarea',
                'title' => esc_html__( 'Quote', 'yankee-toolkit' ),
            ],
            [
                'id'    => 'post_quote_author',
                'type'  => 'text',
                'title' => esc_html__( 'Quote Author Name', 'yankee-toolkit' ),
            ],
        ],
    ] );

    // Post Meta(Video)
    $video_post_prefix = 'yankee_post_video_meta';

    CSF::createMetabox( $video_post_prefix, [
        'title'        => esc_html__( 'Yankee Video Options', 'yankee-toolkit' ),
        'post_type'    => 'post',
        'post_formats' => 'video',
    ] );

    CSF::createSection( $video_post_prefix, [
        'fields' => [
            [
                'id'    => 'post_video_link',
                'type'  => 'text',
                'title' => esc_html__( 'Video Url', 'yankee-toolkit' ),
                'desc'  => esc_html__( 'Type your video url. Example: https://www.youtube.com/watch?v=pVE92TNDwUk', 'yankee-toolkit' ),
            ],
            [
                'id'      => 'post_video_bg',
                'type'    => 'media',
                'library' => 'image',
                'title'   => esc_html__( 'Video Background', 'yankee-toolkit' ),
                'desc'    => esc_html__( 'Add video Background Image', 'yankee-toolkit' ),
            ],
        ],
    ] );

    // Post Meta(Audio)
    $audio_post_prefix = 'yankee_post_audio_meta';

    CSF::createMetabox( $audio_post_prefix, [
        'title'        => esc_html__( 'Yankee Audio Options', 'yankee-toolkit' ),
        'post_type'    => 'post',
        'post_formats' => 'audio',
    ] );

    CSF::createSection( $audio_post_prefix, [
        'fields' => [
            [
                'id'      => 'post_audio_link',
                'type'    => 'media',
                'library' => 'audio',
                'title'   => esc_html__( 'Audio', 'yankee-toolkit' ),
                'desc'    => esc_html__( 'Select Audio file', 'yankee-toolkit' ),
            ],
        ],
    ] );

    // Team Meta
    $team_prefix = 'yankee_team_metaboxes';

    CSF::createMetabox( $team_prefix, [
        'title'     => esc_html__( 'Yankee Member Options', 'yankee-toolkit' ),
        'post_type' => 'team-members',
    ] );

    CSF::createSection( $team_prefix, [
        'fields' => [
            [
                'id'          => 'member_position',
                'type'        => 'text',
                'title'       => esc_html__( 'Position', 'yankee-toolkit' ),
                'placeholder' => esc_html__( 'Designer', 'yankee-toolkit' ),
                'desc'        => esc_html__( 'Type your memeber Post Position.', 'yankee-toolkit' ),
            ],
            [
                'id'    => 'short_info',
                'type'  => 'textarea',
                'title' => esc_html__( 'Short Info', 'yankee-toolkit' ),
                'desc'  => esc_html__( 'Share a little biographical information .', 'yankee-toolkit' ),
            ],
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'Member Information', 'yankee-toolkit' ),
            ],
            [
                'id'      => 'info_box_heading',
                'type'    => 'text',
                'title'   => esc_html__( 'Info Box Heading', 'yankee-toolkit' ),
                'default' => esc_html__( 'Get in touch', 'yankee-toolkit' ),
            ],
            [
                'id'      => 'info_box_heading_tag',
                'type'    => 'text',
                'title'   => esc_html__( 'Info Box Heading Tag', 'yankee-toolkit' ),
                'default' => esc_html__( 'Contact Me', 'yankee-toolkit' ),
            ],
            [
                'id'           => 'member_social_links',
                'type'         => 'group',
                'title'        => esc_html__( 'Social Links', 'yankee-toolkit' ),
                'button_title' => esc_html__( 'Add New icon', 'yankee-toolkit' ),
                'fields'       => [
                    [
                        'id'    => 'link_icon',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Icon', 'yankee-toolkit' ),
                    ],
                    [
                        'id'    => 'link_text',
                        'type'  => 'text',
                        'title' => esc_html__( 'Link', 'yankee-toolkit' ),
                    ],
                ],
            ],
            [
                'id'           => 'member_contact_info',
                'type'         => 'group',
                'title'        => esc_html__( 'Contact Info', 'yankee-toolkit' ),
                'button_title' => esc_html__( 'Add New info', 'yankee-toolkit' ),
                'fields'       => [
                    [
                        'id'    => 'info_text',
                        'type'  => 'text',
                        'title' => esc_html__( 'Information', 'yankee-toolkit' ),
                    ],
                    [
                        'id'    => 'info_link',
                        'type'  => 'text',
                        'title' => esc_html__( 'Link', 'yankee-toolkit' ),
                    ],
                    [
                        'id'    => 'info_icon',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Icon', 'yankee-toolkit' ),
                    ],
                ],
            ],
        ],
    ] );

    // Service Meta
    $service_prefix = 'yankee_service_metaboxes';

    CSF::createMetabox( $service_prefix, [
        'title'     => esc_html__( 'Yankee Service Options', 'yankee-toolkit' ),
        'post_type' => 'services',
    ] );

    CSF::createSection( $service_prefix, [
        'fields' => [
            [
                'type'    => 'image_select',
                'id'      => 'service_layout',
                'title'   => esc_html__( 'Layout', 'yankee-toolkit' ),
                'options' => [
                    'boxed-layout'     => plugins_url( 'img/boxed-layout.jpg', __FILE__ ),
                    'fullwidth-layout' => plugins_url( 'img/fullwidth-layout.jpg', __FILE__ ),
                ],
                'default' => 'boxed-layout',
                'desc'    => esc_html__( 'Select Page layout. Boxed or Full Width', 'yankee-toolkit' ),
            ],
            [
                'type'    => 'image_select',
                'id'      => 'service_sidebar',
                'title'   => esc_html__( 'Sidebar', 'yankee-toolkit' ),
                'options' => [
                    'left-sidebar'  => plugins_url( 'img/left-sidebar.jpg', __FILE__ ),
                    'right-sidebar' => plugins_url( 'img/right-sidebar.jpg', __FILE__ ),
                    'no-sidebar'    => plugins_url( 'img/no-sidebar.jpg', __FILE__ ),
                ],
                'default' => 'no-sidebar',
                'desc'    => esc_html__( 'Select Page Sidebar. Left sidebar or right sidebar or No sidebar', 'yankee-toolkit' ),
            ],
            [
                'id'    => 'service_remove_padding',
                'type'  => 'switcher',
                'title' => esc_html__( 'Remove Page Padding', 'yankee-toolkit' ),
                'desc'  => esc_html__( 'It will Remove default padding(Top, Bottom, Left, Right) of this page', 'yankee-toolkit' ),
            ],
        ],
    ] );

    // Portfolio Meta
    $portfolios_prefix = 'yankee_portfolios_metaboxes';

    CSF::createMetabox( $portfolios_prefix, [
        'title'     => esc_html__( 'Yankee Portfolio Options', 'yankee-toolkit' ),
        'post_type' => 'portfolios',
    ] );

    CSF::createSection( $portfolios_prefix, [
        'fields' => [
            [
                'type'    => 'image_select',
                'id'      => 'portfolio_layout',
                'title'   => esc_html__( 'Layout', 'yankee-toolkit' ),
                'options' => [
                    'boxed-layout'     => plugins_url( 'img/boxed-layout.jpg', __FILE__ ),
                    'fullwidth-layout' => plugins_url( 'img/fullwidth-layout.jpg', __FILE__ ),
                ],
                'default' => 'boxed-layout',
                'desc'    => esc_html__( 'Select Page layout. Boxed or Full Width', 'yankee-toolkit' ),
            ],
            [
                'type'    => 'image_select',
                'id'      => 'portfolio_sidebar',
                'title'   => esc_html__( 'Sidebar', 'yankee-toolkit' ),
                'options' => [
                    'left-sidebar'  => plugins_url( 'img/left-sidebar.jpg', __FILE__ ),
                    'right-sidebar' => plugins_url( 'img/right-sidebar.jpg', __FILE__ ),
                    'no-sidebar'    => plugins_url( 'img/no-sidebar.jpg', __FILE__ ),
                ],
                'default' => 'right-sidebar',
                'desc'    => esc_html__( 'Select Page Sidebar. Left sidebar or right sidebar or No sidebar', 'yankee-toolkit' ),
            ],
            [
                'id'    => 'portfolio_remove_padding',
                'type'  => 'switcher',
                'title' => esc_html__( 'Remove Page Padding', 'yankee-toolkit' ),
                'desc'  => esc_html__( 'It will Remove default padding(Top, Bottom, Left, Right) of this page', 'yankee-toolkit' ),
            ],
        ],
    ] );
}