<?php

/**
 * Use namespace to avoid conflict
 */
namespace PostType;

/**
 * Class TeamMembers
 * @package PostType
 *
 * Use actual name of post type for
 * easy readability.
 *
 * Potential conflicts removed by namespace
 */
class TeamMembers {

    /**
     * @var string
     * Set post type params
     */
    private $type = 'team-members';
    private $slug = 'teams';
    private $name = 'Team Members';
    private $singular_name = 'Team Member';
    private $icon = 'dashicons-businessperson';

    /**
     * Register post type
     */
    public function register() {
        $opt = get_option( 'yankee_options' );
        $slug = !empty( $opt['team_slug'] ) ? strtolower( str_replace( ' ', '', $opt['team_slug'] ) ) : $this->slug;

        $labels = [
            'name'                  => esc_html__( 'Team Members', 'yankee-toolkit' ),
            'singular_name'         => esc_html__( 'Team Member', 'yankee-toolkit' ),
            'add_new'               => esc_html__( 'Add New ', 'yankee-toolkit' ),
            'add_new_item'          => esc_html__( 'Add New ', 'yankee-toolkit' ) . $this->singular_name,
            'edit_item'             => esc_html__( 'Edit ', 'yankee-toolkit' ) . $this->singular_name,
            'new_item'              => esc_html__( 'New ', 'yankee-toolkit' ) . $this->singular_name,
            'all_items'             => esc_html__( 'All ', 'yankee-toolkit' ) . $this->name,
            'view_item'             => esc_html__( 'View ', 'yankee-toolkit' ) . $this->singular_name,
            'view_items'            => esc_html__( 'View ', 'yankee-toolkit' ) . $this->name,
            'search_items'          => esc_html__( 'Search ', 'yankee-toolkit' ) . $this->name,
            'not_found'             => esc_html__( 'No ', 'yankee-toolkit' ) . strtolower( $this->name ) . esc_html__( ' found', 'yankee-toolkit' ),
            'not_found_in_trash'    => esc_html__( 'No ', 'yankee-toolkit' ) . strtolower( $this->name ) . esc_html__( ' found in Trash', 'yankee-toolkit' ),
            'parent_item_colon'     => '',
            'menu_name'             => $this->name,
            'featured_image'        => esc_html__( 'Member image', 'yankee-toolkit' ),
            'set_featured_image'    => esc_html__( 'Set member image', 'yankee-toolkit' ),
            'remove_featured_image' => esc_html__( 'Remove member image', 'yankee-toolkit' ),
            'use_featured_image'    => esc_html__( 'Use as member image', 'yankee-toolkit' ),
        ];

        $args = [
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => ['slug' => $slug],
            'capability_type'    => 'post',
            'has_archive'        => false,
            'hierarchical'       => true,
            'menu_position'      => 8,
            'supports'           => ['title', 'editor', 'thumbnail'],
            'yarpp_support'      => true,
            'menu_icon'          => $this->icon,
        ];

        register_post_type( $this->type, $args );

    }

    public function __construct() {
        // Register the post type
        add_action( 'init', [$this, 'register'] );
    }

}

new TeamMembers();