<?php
/**
 * Widget: Yankee Contact Form
 */

function select_contact_form_7_posts() {
    $args = ['post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1];

    $form_list = [];

    if ( $categories = get_posts( $args ) ) {
        foreach ( $categories as $category ) {
            (int) $form_list[$category->ID] = $category->post_title;
        }
    } else {
        (int) $form_list['0'] = esc_html__( 'No contect From 7 form found', 'yankee-toolkit' );
    }
    return $form_list;
}

if ( class_exists( 'CSF' ) ) {
    CSF::createWidget( 'yankee_contact_form_widget', [
        'title'       => esc_html__( '*Yankee Contact Form', 'yankee-toolkit' ),
        'classname'   => 'yankee-contact-form',
        'description' => esc_html__( 'Show Contact form 7', 'yankee-toolkit' ),
        'fields'      => [
            [
                'id'      => 'title',
                'type'    => 'text',
                'title'   => esc_html( 'Title', 'yankee-toolkit' ),
                'default' => esc_html__( 'Get a quote', 'yankee-toolkit' ),
            ],
            [
                'id'      => 'title_tag',
                'type'    => 'text',
                'title'   => esc_html( 'Title Tag', 'yankee-toolkit' ),
                'default' => esc_html__( 'Appoinment', 'yankee-toolkit' ),
            ],
            [
                'id'      => 'contact_form',
                'type'    => 'select',
                'title'   => esc_html( 'Select Form', 'yankee-toolkit' ),
                'options' => select_contact_form_7_posts(),
            ],
        ],
    ] );

    // Front-end display of widget
    if ( !function_exists( 'yankee_contact_form_widget' ) ) {
        function yankee_contact_form_widget( $args, $instance ) {

            $allowed_html = array(
                'div' => array(
                    'id' => array(),
                    'class' => array(),
                ),
                'h3' => array(
                    'class' => array(),
                ),
                'h4' => array(
                    'class' => array(),
                ),
                'h5' => array(
                    'class' => array(),
                ),
                'h6' => array(
                    'class' => array(),
                ),
            );

            echo wp_kses($args['before_widget'], $allowed_html);

            if ( !empty( $instance['title_tag'] ) ) {
                printf( '<span class="title-tag">%1$s</span>',
                    esc_html( $instance['title_tag'] )
                );
            }

            if ( !empty( $instance['title'] ) ) {
                echo wp_kses($args['before_title'], $allowed_html) . apply_filters( 'widget_title', $instance['title'] ) . wp_kses($args['after_title'], $allowed_html);
            }

            if ( function_exists( 'wpcf7' ) ) {
                if ( !empty( $instance['contact_form'] ) )  {
                    echo do_shortcode( '[contact-form-7 id="' . $instance['contact_form'] . '" ]' );
                }
            }

            echo wp_kses($args['after_widget'], $allowed_html);
        }
    }
}