<?php
/**
 * Widget: Yankee Service List
 */

if ( class_exists( 'CSF' ) ) {
    CSF::createWidget( 'yankee_service_list_widget', [
        'title'       => esc_html__( '*Yankee Service List', 'yankee-toolkit' ),
        'classname'   => 'yankee-service-list',
        'description' => esc_html__( 'Show Services', 'yankee-toolkit' ),
        'fields'      => [
            [
                'id'      => 'title',
                'type'    => 'text',
                'title'   => esc_html( 'Title', 'yankee-toolkit' ),
                'default' => esc_html__( 'Recent Post', 'yankee-toolkit' ),
            ],
            [
                'id'      => 'post_count',
                'type'    => 'number',
                'title'   => esc_html( 'Number of Posts to Show', 'yankee-toolkit' ),
                'default' => '5',
            ],
        ],
    ] );

    // Front-end display of widget example 1
    if ( !function_exists( 'yankee_service_list_widget' ) ) {
        function yankee_service_list_widget( $args, $instance ) {


            $post_count = ( !empty( $instance['post_count'] ) ) ? absint( $instance['post_count'] ) : 5;

            $query = new WP_Query( apply_filters( 'widget_posts_args', array(
                'post_type' => 'services',
                'posts_per_page'      => $post_count,
                'no_found_rows'       => true,
                'post_status'         => 'publish',
                'ignore_sticky_posts' => true,
            ), $instance ) );

            if ( !$query->have_posts() ) {
                return;
            }

            $allowed_html = array(
                'div' => array(
                    'id' => array(),
                    'class' => array(),
                ),
                'h3' => array(
                    'class' => array(),
                ),
                'h4' => array(
                    'class' => array(),
                ),
                'h5' => array(
                    'class' => array(),
                ),
                'h6' => array(
                    'class' => array(),
                ),
            );

            echo wp_kses($args['before_widget'], $allowed_html);

            if ( !empty( $instance['title'] ) ) {
                echo wp_kses($args['before_title'], $allowed_html) . apply_filters( 'widget_title', $instance['title'] ) . wp_kses($args['after_title'], $allowed_html);
            } ?>

            <ul class="service-post-loop">
                <?php while ( $query->have_posts() ): $query->the_post(); ?>
                    <li>
                        <a href="<?php echo esc_url( get_the_permalink() ) ?>"><?php echo esc_html( get_the_title() ) ?></a>
                    </li>
                <?php endwhile; wp_reset_postdata(); ?>
            </ul>

            <?php echo wp_kses($args['after_widget'], $allowed_html);
        }
    }

}