<?php
/**
 * Widget: Yankee Social Links
 */

if ( class_exists( 'CSF' ) ) {
    // Recent Post Widget
    CSF::createWidget( 'yankee_social_link_widget', [
        'title'       => esc_html__( '*Yankee Social Links', 'yankee-toolkit' ),
        'classname'   => 'yankee-social-links',
        'description' => esc_html__( 'Add social links', 'yankee-toolkit' ),
        'fields'      => [
            [
                'id'      => 'title',
                'type'    => 'text',
                'title'   => esc_html( 'Title', 'yankee-toolkit' ),
                'default' => esc_html__( 'Never Miss News', 'yankee-toolkit' ),
            ],
            [
                'id'           => 'social_links',
                'type'         => 'group',
                'title'        => esc_html__( 'Social Links', 'yankee-toolkit' ),
                'button_title' => esc_html__( 'Add Links', 'yankee-toolkit' ),
                'fields'       => [
                    [
                        'id'    => 'social_icon',
                        'type'  => 'icon',
                        'title' => esc_html( 'Icon', 'yankee-toolkit' ),
                    ],
                    [
                        'id'    => 'social_url',
                        'type'  => 'text',
                        'title' => esc_html( 'Url', 'yankee-toolkit' ),
                    ],
                ],
            ],

        ],
    ] );

    // Front-end display of widget example 1
    if ( !function_exists( 'yankee_social_link_widget' ) ) {
        function yankee_social_link_widget( $args, $instance ) {
            $allowed_html = array(
                'div' => array(
                    'id' => array(),
                    'class' => array(),
                ),
                'h3' => array(
                    'class' => array(),
                ),
                'h4' => array(
                    'class' => array(),
                ),
                'h5' => array(
                    'class' => array(),
                ),
                'h6' => array(
                    'class' => array(),
                ),
            );

            echo wp_kses($args['before_widget'], $allowed_html);

            if ( !empty( $instance['title'] ) ) {
                echo wp_kses($args['before_title'], $allowed_html) . apply_filters( 'widget_title', $instance['title'] ) . wp_kses($args['after_title'], $allowed_html);
            }

            if ( !empty( $instance['social_links'] ) ) : ?>
                <ul>
                    <?php foreach ( $instance['social_links'] as $items ) : ?>
                        <li><a href="<?php echo esc_url( $items['social_url'] ) ?>"><i class="<?php echo esc_attr( $items['social_icon'] ) ?>"></i></a></li>
                    <?php endforeach; ?>
                </ul>
            <?php endif;
            echo wp_kses($args['after_widget'], $allowed_html);
        }
    }

}