<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_History_TimeLine extends Widget_Base {

    public function get_name() {
        return 'yankee-history-timeline';
    }

    public function get_title() {
        return esc_html__( 'History TimeLine', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-time-line';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'history', 'timeline'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'History TimeLine', 'yankee-toolkit' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'history_year', [
                'label'       => esc_html__( 'Year', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( '2000', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'divider_1',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'history_tag', [
                'label'       => esc_html__( 'Tag Line', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( '2005 - Get rewards', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'history_title', [
                'label'       => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => esc_html__( 'We Just recived an from drem co.', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'title_tag',
            [
                'label'       => esc_html__( 'Title HTML Tag', 'yankee-toolkit' ),
                'type'        => Controls_Manager::CHOOSE,
                'label_block' => true,
                'options'     => [
                    'h1' => [
                        'title' => __( 'H1', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'     => 'h2',
                'toggle'      => false,
            ]
        );

        $repeater->add_control(
            'history_desc', [
                'label'       => esc_html__( 'Description', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'rows'        => '10',
            ]
        );

        $repeater->add_control(
            'use_button',
            [
                'label'        => esc_html__( 'Use Button?', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'No', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label'     => esc_html__( 'Button Text', 'yankee-toolkit' ),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__( 'Get Appointment', 'yankee-toolkit' ),
                'condition' => [
                    'use_button' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'button_url',
            [
                'label'     => esc_html__( 'Button Url', 'yankee-toolkit' ),
                'type'      => Controls_Manager::URL,
                'default'   => [
                    'url' => '#',
                ],
                'condition' => [
                    'use_button' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'column_heading',
            [
                'label'     => esc_html__( 'Galley Images', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'first_Img',
            [
                'label'   => esc_html__( 'First Image', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail_one',
                'default'   => 'full',
                'separator' => 'before',
                'exclude'   => [
                    'custom',
                ],
            ]
        );

        $repeater->add_control(
            'second_Img',
            [
                'label'   => esc_html__( 'Second Image', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail_two',
                'default'   => 'full',
                'separator' => 'before',
                'exclude'   => [
                    'custom',
                ],
            ]
        );

        $this->add_control(
            'history_timelines', [
                'label'       => esc_html__( 'Timelines', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{history_year}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'History Nav Area', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'nav_area_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-tab-btns' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_area_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-tab-btns' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'line_bg_color',
            [
                'label'     => esc_html__( 'Line Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-btns.with-progess .progress' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'line_color',
            [
                'label'     => esc_html__( 'Line Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-btns.with-progess .progress-bar' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'history_nav_button',
            [
                'label' => esc_html__( 'History Nav Button', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'nav_button_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-tab-btns li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_button_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-tab-btns li a' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'nav_button_typography',
                'selector' => '{{WRAPPER}} .timeline-tab-btns li a',
            ]
        );

        $this->start_controls_tabs( 'nav_btn_tabs' );

        $this->start_controls_tab(
            'nav_button_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'nav_button_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-tab-btns li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_button_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-tab-btns li a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'nav_button_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .timeline-tab-btns li a',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'nav_button_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'nav_button_hover_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-tab-btns li a.active, {{WRAPPER}} .timeline-tab-btns li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_button_hover_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-tab-btns li a.active, {{WRAPPER}} .timeline-tab-btns li a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'nav_button_hover_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .timeline-tab-btns li a.active, {{WRAPPER}} .timeline-tab-btns li a:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'content_area',
            [
                'label' => esc_html__( 'Content', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_area_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_area_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tag_line_heading',
            [
                'label'     => esc_html__( 'Tag Line', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_tag_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-text .timeline-tag' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_tag_typography',
                'selector' => '{{WRAPPER}} .timeline-text .timeline-tag',
            ]
        );

        $this->add_responsive_control(
            'tag_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-text .timeline-tag' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_headiing',
            [
                'label'     => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-text .timeline-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_title_typography',
                'selector' => '{{WRAPPER}} .timeline-text .timeline-title',
            ]
        );

        $this->add_responsive_control(
            'title_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-text .timeline-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'desc_headiing',
            [
                'label'     => esc_html__( 'Description', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_desc_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-text p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_desc_typography',
                'selector' => '{{WRAPPER}} .timeline-text p',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_button',
            [
                'label'     => esc_html__( 'Button', 'yankee-toolkit' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_button_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-text a.history-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_button_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .timeline-text a.history-btn' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_button_typography',
                'selector' => '{{WRAPPER}} .timeline-text a.history-btn',
            ]
        );

        $this->start_controls_tabs( 'content_btn_tabs' );

        $this->start_controls_tab(
            'content_button_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'content_button_normal_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-text a.history-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_button_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-text a.history-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'content_button',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .timeline-text a.history-btn',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'content_button_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'content_btn_hover_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-text a.history-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_button_hover_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-text a.history-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'content_button_hover',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .timeline-text a.history-btn:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        $item_count = 0;
        $content_count = 0;

        if ( !empty( $settings['history_timelines'] ) ): ?>
            <div class="history-timeline">
                <div class="container-fluid container-1500">
                    <div class="timeline-btns with-progess">
                        <div class="progress">
                            <div class="progress-bar" id="timelinProgess" role="progressbar">
                            </div>
                        </div>

                        <ul class="nav timeline-tab-btns" role="tablist">
                            <?php foreach( $settings['history_timelines'] as $timeline ) :
                                $item_count++; ?>
                                <li class="nav-item">
                                    <a class="nav-link<?php if( $item_count == 1 ) : ?> active<?php endif; ?>" href="#tab-<?php echo esc_attr( $item_count ) ?>" role="tab" data-toggle="tab" aria-selected="true"><?php echo esc_html( $timeline['history_year'] ) ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
                <div class="container">
                    <div class="tab-content">
                        <?php foreach( $settings['history_timelines'] as $timeline ) :
                            $content_count++;
                            $target = $timeline['button_url']['is_external'] ? ' target="_blank"' : '';
                            $nofollow = $timeline['button_url']['nofollow'] ? ' rel="nofollow"' : '';
                            ?>
                            <div role="tabpanel" class="tab-pane fade<?php if( $content_count == 1 ) : ?> in active show<?php endif; ?>" id="tab-<?php echo esc_attr( $content_count ) ?>">
                                <div class="row align-items-center justify-content-center">
                                    <div class="col-lg-7 col-md-10 order-lg-last">
                                        <div class="timeline-images row align-items-center">
                                            <div class="col-lg-6 col-6">
                                                <div class="image text-right">
                                                    <?php echo Group_Control_Image_Size::get_attachment_image_html( $timeline, 'thumbnail_one', 'first_Img' ); ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-6">
                                                <div class="image text-right">
                                                <?php echo Group_Control_Image_Size::get_attachment_image_html( $timeline, 'thumbnail_two', 'second_Img' ); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-5 col-md-10 order-lg-first">
                                        <div class="timeline-text">
                                            <?php
                                                if ( $timeline['history_tag'] ) {
                                                    printf( '<span class="timeline-tag">%1$s</span>',
                                                        esc_html( $timeline['history_tag'] )
                                                    );
                                                }

                                                if ( $timeline['history_title'] ) {
                                                    printf( '<%1$s class="timeline-title">%2$s</%1$s>',
                                                        tag_escape( $timeline['title_tag'] ),
                                                        esc_html( $timeline['history_title'] )
                                                    );
                                                }

                                                if ( $timeline['history_desc'] ) {
                                                    echo wpautop( esc_html( $timeline['history_desc'] ) );
                                                }

                                                if ( $timeline['use_button'] == 'yes' && $timeline['button_text'] ) {
                                                    printf( '<a class="history-btn" href="%1$s" %2$s %3$s>%4$s</a>',
                                                        esc_url( $timeline['button_url']['url'] ),
                                                        $target,
                                                        $nofollow,
                                                        esc_html( $timeline['button_text'] )
                                                    );
                                                }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif;
    }

}