<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Pricing_Tables extends Widget_Base {

    public function get_name() {
        return 'yankee-pricing-table';
    }

    public function get_title() {
        return esc_html__( 'Pricing Table', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-price-table';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'pricing', 'table'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Pricing Table', 'yankee-toolkit' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'plan_name', [
                'label'       => esc_html__( 'Plan Name', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Advanced Plan', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'plan_price', [
                'label'       => esc_html__( 'Plan Price', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( '99', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'currency_symbol', [
                'label'       => esc_html__( 'Currency Symbol', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( '$', 'yankee-toolkit' ),
                'selectors'   => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .paln-price::before' => 'content: "{{VALUE}}"',
                ],
            ]
        );

        $repeater->add_control(
            'list_content', [
                'label'       => esc_html__( 'Content List', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => '<li><i class="fal fa-check"></i>Unlimited revisions</li><li><i class="fal fa-check"></i>free ui/ux support</li>',
                'description' => esc_html__( 'Wrap up every list item with li tag (<li><i class="icon name"></i>Item Name</li>).', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'button_text', [
                'label'       => esc_html__( 'Button Text', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Purchase now', 'yankee-toolkit' ),
                'placeholder' => esc_html__( 'Purchase now', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'button_link', [
                'label'       => esc_html__( 'Button Link', 'yankee-toolkit' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'https://your-link.com', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'button_icon',
            [
                'label'            => esc_html__( 'Button Icon', 'yankee-toolkit' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-cart-plus',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'button_position',
            [
                'label'   => esc_html__( 'Icon Positions', 'yankee-toolkit' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'icon-left'  => [
                        'title' => esc_html__( 'Before', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'icon-right' => [
                        'title' => esc_html__( 'After', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'icon-right',
            ]
        );

        $repeater->add_control(
            'featured_item',
            [
                'label'        => esc_html__( 'Make It featured', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'No', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $this->add_control(
            'pricing_tables', [
                'label'       => esc_html__( 'Tables', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{plan_name}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Table', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'table-padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'table-margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'table_tabs' );

        $this->start_controls_tab(
            'table_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'table_normal_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'table_normal_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table',
            ]
        );

        $this->add_control(
            'table_normal_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'table_normal_shadow',
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table',
            ]
        );

        $this->add_control(
            'hr_1',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'table_title_border_color',
            [
                'label'     => esc_html__( 'Title Border', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .plan-title' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'table_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'table_hover_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'table_hover_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'table_hover_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'table_hover_shadow',
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table',
            ]
        );

        $this->add_control(
            'hr_2',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'table_title_hover_border_color',
            [
                'label'     => esc_html__( 'Title Border', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover .plan-title, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table .plan-title' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'content_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'plan_name_heading',
            [
                'label' => esc_html__( 'Plan Name', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'plan_name_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .plan-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'plan_name_typography',
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table .plan-title',
            ]
        );

        $this->add_control(
            'plan_price_heading',
            [
                'label'     => esc_html__( 'Plan Price', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'plan_price_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .plan-price' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'plan_price_typography',
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table .plan-price',
            ]
        );

        $this->add_control(
            'currency_heading',
            [
                'label'     => esc_html__( 'Currency Symbol', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'currency_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .plan-price::before' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'currency_typography',
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table .plan-price::before',
            ]
        );

        $this->add_control(
            'content_heading',
            [
                'label'     => esc_html__( 'Content', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table ul li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typography',
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table ul li',
            ]
        );

        $this->add_responsive_control(
            'list_gap',
            [
                'label'      => esc_html__( 'List Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table ul li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'list_icon_heading',
            [
                'label'     => esc_html__( 'List Icon', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'list_icon_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table ul li i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'list_icon_font_size',
            [
                'label'      => esc_html__( 'Font Size', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_button',
            [
                'label' => esc_html__( 'Button', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .pricing-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .pricing-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'button_tabs' );

        $this->start_controls_tab(
            'button_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'button_normal_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .pricing-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_normal_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .pricing-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'button_normal_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table .pricing-btn',
            ]
        );

        $this->add_control(
            'button_normal_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table .pricing-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover .pricing-btn, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table .pricing-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover .pricing-btn, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table .pricing-btn' => 'Background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'button_hover_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover .pricing-btn, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table .pricing-btn',
            ]
        );

        $this->add_control(
            'button_hover_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-pricing-tables .pricing-table:hover .pricing-btn, {{WRAPPER}} .yankee-pricing-tables .pricing-table.featured-table .pricing-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        if ( ! empty( $settings['pricing_tables'] ) ) : ?>
            <div class="yankee-pricing-tables row">
                 <?php
                 foreach ( $settings['pricing_tables'] as $index => $table ) :

                     $btn_attr = $this->get_repeater_setting_key( 'plan_link', 'pricing_tables', $index );

                     $this->add_render_attribute( $btn_attr, [
                         'class' => [ 'pricing-btn', $table['button_position'] ],
                         'href'  => esc_url( $table['button_link']['url'] ),
                     ] );

                     if ( !empty( $table['button_link']['is_external'] ) ) {
                         $this->add_render_attribute( $btn_attr, 'target', '_blank' );
                     }
                     if ( !empty( $table['button_link']['nofollow'] ) ) {
                         $this->set_render_attribute( $btn_attr, 'rel', 'nofollow' );
                     }
                 ?>
                     <div class="col-lg-4 col-md-6 col-sm-10 elementor-repeater-item-<?php echo esc_attr( $table['_id'] ) ?>">
                         <div class="pricing-table<?php if ( $table['featured_item'] == 'yes' ) : ?> featured-table<?php endif; ?>">
                             <div class="plan-title">
                                <?php
                                    if ( $table['plan_name'] ) {
                                        printf( '<span class="title">%1$s</span>',
                                            esc_html( $table['plan_name'] )
                                        );
                                    }
                                    if ( $table['plan_price'] ) {
                                        printf( '<span class="plan-price">%1$s</span>',
                                            esc_html( $table['plan_price'] )
                                        );
                                    }
                                ?>
                             </div>
                             <div class="plan-desc">
                                <ul>
                                     <?php echo wp_kses_post( $table['list_content'] ); ?>
                                </ul>
                                <?php
                                    if ( $table['button_text'] && $table['button_link']['url'] ) {
                                        if ( $table['button_position'] == 'icon-left' ) {
                                            printf( '<a %1$s><i class="%2$s"></i> %3$s</a>',
                                                $this->get_render_attribute_string( $btn_attr ),
                                                esc_attr( $table['button_icon']['value'] ),
                                                esc_html( $table['button_text'] )
                                            );
                                        } else {
                                            printf( '<a %1$s>%2$s <i class="%3$s"></i></a>',
                                                $this->get_render_attribute_string( $btn_attr ),
                                                esc_html( $table['button_text'] ),
                                                esc_attr( $table['button_icon']['value'] )
                                            );
                                        }
                                    }
                                ?>
                             </div>
                         </div>
                     </div>
                 <?php endforeach; ?>
            </div>
         <?php endif;
    }
}