<?php
/**
 * Plugin Name: Yankee Toolkit
 * Description: This is the toolkit plugin for Yankee wordpress theme
 * Plugin URI: https://themeforest.net/user/webtend
 * Version: 1.2
 * Author: Webtend
 * Author URI: https://themeforest.net/user/webtend
 * Text Domain: yankee-toolkit
 * Domain Path: /languages/
 */

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

// Make sure the same class is not loaded twice.
if ( !class_exists( 'Yankee_Toolkit' ) ) {
    final class Yankee_Toolkit {
        // Elementor Toolkit Version
        const VERSION = '1.2';

        // Minimum Elementor Version
        const MINIMUM_ELEMENTOR_VERSION = '2.0.0';

        // Holds the minimum PHP version required to run the plugin.
        const MINIMUM_PHP_VERSION = '5.6';

        // Ensures only one instance of the class is loaded or can be loaded.
        private static $_instance = null;
        public static function instance() {

            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;

        }

        // Disable class cloning.
        public function __clone() {
            // Cloning instances of the class is forbidden
            _doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'yankee-toolkit' ), '1.2' );
        }

        // Disable unserializing the class.
        public function __wakeup() {
            // Unserializing instances of the class is forbidden.
            _doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'yankee-toolkit' ), '1.2' );
        }

        // Constructor
        public function __construct() {
            $this->core_includes();
            $this->init_hooks();
            do_action( 'yankee_toolkit_loaded' );
        }

        // Load core files required to run the plugin.
        public function core_includes() {

            // Extra functions
            require_once __DIR__ . '/inc/inc.php';

            // Metaboxes
            require_once __DIR__ . '/inc/metaboxes/metaboxes.php';
            require_once __DIR__ . '/inc/metaboxes/user-metaboxes.php';

            // Custom post types
            require_once __DIR__ . '/inc/post-type/footer.php';
            require_once __DIR__ . '/inc/post-type/team-members.php';
            require_once __DIR__ . '/inc/post-type/portfolio.php';
            require_once __DIR__ . '/inc/post-type/services.php';

            // Custom Wp Widgets
            require_once __DIR__ . '/inc/wp-widget/yankee-recent-post.php';
            require_once __DIR__ . '/inc/wp-widget/yankee-social-link.php';
            require_once __DIR__ . '/inc/wp-widget/yankee-service-list.php';
            require_once __DIR__ . '/inc/wp-widget/yankee-contact-form.php';
        }

        // Init Hooks. Hook into actions and filters.
        private function init_hooks() {
            add_action( 'init', [$this, 'i18n'] );
            add_action( 'plugins_loaded', [$this, 'init'] );
        }

        // Load Textdomain
        public function i18n() {
            load_plugin_textdomain( 'yankee-toolkit', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
        }

        // Init toolkit Core
        public function init() {
            if ( !did_action( 'elementor/loaded' ) ) {
                add_action( 'admin_notices', [$this, 'admin_notice_missing_main_plugin'] );
                return;
            }
            // Check for required Elementor version
            if ( !version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
                add_action( 'admin_notices', [$this, 'admin_notice_minimum_elementor_version'] );
                return;
            }
            // Check for required PHP version
            if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
                add_action( 'admin_notices', [$this, 'admin_notice_minimum_php_version'] );
                return;
            }
            // Add new Elementor Categories
            add_action( 'elementor/init', [$this, 'add_elementor_category'] );

            // Register Widget Scripts
            add_action( 'elementor/frontend/after_register_scripts', [$this, 'register_widget_scripts'] );
            add_action( 'elementor/editor/before_enqueue_scripts', [$this, 'register_widget_scripts'] );

            // Register Widget Style
            add_action( 'elementor/frontend/after_enqueue_styles', [$this, 'enqueue_widget_styles'] );
            add_action( 'elementor/editor/before_enqueue_scripts', [$this, 'enqueue_widget_styles'] );

            // Register New Widgets
            add_action( 'elementor/widgets/widgets_registered', [$this, 'on_widgets_registered'] );
        }

        // Warning when the site doesn't have Elementor installed or activated.
        public function admin_notice_missing_main_plugin() {

            if ( isset( $_GET['activate'] ) ) {
                unset( $_GET['activate'] );
            }

            $message = sprintf(
                esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'yankee-toolkit' ),
                '<strong>' . esc_html__( 'Yankee Toolkit', 'yankee-toolkit' ) . '</strong>',
                '<strong>' . esc_html__( 'Elementor', 'yankee-toolkit' ) . '</strong>'
            );

            printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

        }

        // Warning when the site doesn't have a minimum required Elementor version.
        public function admin_notice_minimum_elementor_version() {

            if ( isset( $_GET['activate'] ) ) {
                unset( $_GET['activate'] );
            }

            $message = sprintf(
                esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'yankee-toolkit' ),
                '<strong>' . esc_html__( 'Yankee Toolkit', 'yankee-toolkit' ) . '</strong>',
                '<strong>' . esc_html__( 'Elementor', 'yankee-toolkit' ) . '</strong>',
                self::MINIMUM_ELEMENTOR_VERSION
            );

            printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

        }

        //Warning when the site doesn't have a minimum required PHP version.
        public function admin_notice_minimum_php_version() {

            if ( isset( $_GET['activate'] ) ) {
                unset( $_GET['activate'] );
            }

            $message = sprintf(
                esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'yankee-toolkit' ),
                '<strong>' . esc_html__( 'Yankee Toolkit', 'yankee-toolkit' ) . '</strong>',
                '<strong>' . esc_html__( 'PHP', 'yankee-toolkit' ) . '</strong>',
                self::MINIMUM_PHP_VERSION
            );

            printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

        }

        // Add new Elementor Categories
        public function add_elementor_category() {
            \Elementor\Plugin::instance()->elements_manager->add_category(
                'yankee_element',
                [
                    'title' => esc_html__( 'Yankee Elements', 'yankee-toolkit' ),
                    'icon'  => 'fa fa-smile-o',
                ]
            );
        }

        // Register Widget Scripts
        public function register_widget_scripts() {
            wp_register_script( 'slick', plugins_url( 'assets/js/slick.min.js', __FILE__ ), 'jquery', '1.8.1', true );
            wp_register_script( 'jquery-inview', plugins_url( 'assets/js/jquery.inview.min.js', __FILE__ ), 'jquery', '1.0', true );
            wp_register_script( 'magnific-popup', plugins_url( 'assets/js/magnific-popup.min.js', __FILE__ ), 'jquery', '1.1', true );
            wp_register_script( 'isotope', plugins_url( 'assets/js/isotope.pkgd.min.js', __FILE__ ), 'jquery', '3.0.6', true );
            wp_register_script( 'yankee-toolkit', plugins_url( 'assets/js/yankee-toolkit.min.js', __FILE__ ), 'jquery', '1.2', true );
        }

        // Register Widget Styles
        public function enqueue_widget_styles() {
            wp_enqueue_style( 'animations', plugins_url( 'assets/css/animations.min.css', __FILE__ ), '1.0', 'all' );
            wp_register_style( 'slick', plugins_url( 'assets/css/slick.min.css', __FILE__ ), '1.8.1', 'all' );
            wp_register_style( 'magnific-popup', plugins_url( 'assets/css/magnific-popup.min.css', __FILE__ ), '1.1', 'all' );
            wp_register_style( 'yankee-toolkit', plugins_url( 'assets/css/yankee-toolkit.min.css', __FILE__ ) );

            if ( defined( 'ELEMENTOR_VERSION' ) ) {
                if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
                    wp_enqueue_style( 'yankee-toolkit' );
                    wp_enqueue_style( 'animations' );
                }
            }
        }

        // Include Bigbuzz Toolkkit widgets files and register them in Elementor.
        public function on_widgets_registered() {
            $this->include_widgets();
            $this->register_widgets();
        }

        // Include Widgets Files
        private function include_widgets() {
            require_once __DIR__ . '/widgets/yankee-banner-slider.php';
            require_once __DIR__ . '/widgets/yankee-experience-tag.php';
            require_once __DIR__ . '/widgets/yankee-iconic-box.php';
            require_once __DIR__ . '/widgets/yankee-progress-bar.php';
            require_once __DIR__ . '/widgets/yankee-pricing-tables.php';
            require_once __DIR__ . '/widgets/yankee-team-grid.php';
            require_once __DIR__ . '/widgets/yankee-team-slider.php';
            require_once __DIR__ . '/widgets/yankee-post-grid.php';
            require_once __DIR__ . '/widgets/yankee-post-slider.php';
            require_once __DIR__ . '/widgets/yankee-testimonial-slider.php';
            require_once __DIR__ . '/widgets/yankee-history-timeline.php';
            require_once __DIR__ . '/widgets/yankee-tile-gallery.php';
            require_once __DIR__ . '/widgets/yankee-feature-box.php';
            require_once __DIR__ . '/widgets/yankee-advanced-tab.php';
            require_once __DIR__ . '/widgets/yankee-contact-form.php';
            require_once __DIR__ . '/widgets/yankee-video.php';
            require_once __DIR__ . '/widgets/yankee-version-log.php';
            require_once __DIR__ . '/widgets/yankee-service-boxes.php';
            require_once __DIR__ . '/widgets/yankee-portfolio-filter.php';
            require_once __DIR__ . '/widgets/yankee-portfolio-slider.php';
            require_once __DIR__ . '/widgets/yankee-nav-menu.php';
            require_once __DIR__ . '/widgets/yankee-heading.php';
            require_once __DIR__ . '/widgets/yankee-client-logos.php';
            require_once __DIR__ . '/widgets/yankee-counter-boxes.php';
            require_once __DIR__ . '/widgets/yankee-feature-box-two.php';
            require_once __DIR__ . '/widgets/yankee-portfolio-list.php';
        }

        // Register Widgets
        private function register_widgets() {
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Banner_Slider() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Experience_Tags() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Iconic_Box() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Progress_Bar() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Pricing_Tables() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Team_Grid() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Team_Slider() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Post_Grid() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Post_Slider() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Testimonial_Slider() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_History_TimeLine() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Tile_Gallery() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Feature_Box() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Advanced_Tab() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Contact_Form() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Video() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Version_log() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Service_boxes() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Portfolio_Filter() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Portfolio_Slider() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Nav_Menu() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Heading() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Client_logos() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Counter_Boxes() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Feature_Box_Two() );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new YankeeToolkit\Widgets\Yankee_Portfolio_List() );
        }

    }
}

if ( !function_exists( 'yankee_toolkit_loading' ) ) {

    //Load Bigbuzz Toolkit
    function yankee_toolkit_loading() {
        return Yankee_Toolkit::instance();
    }

    // Run Bigbuzz Toolkit
    yankee_toolkit_loading();
}