<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package yankee
 */

get_header();
// $error_title = !empty($opt['error_title']) ? $opt['error_title'] : esc_html__( 'Page not found', 'saasland' );
?>

<div class="error-page section-padding">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-9">
				<div class="error-img text-center">
					<?php if ( !empty( yankee_get_option( 'error_image' )['url'] ) ): ?>
						<img src="<?php echo esc_url( yankee_get_option( 'error_image' )['url'] ) ?>" alt="404">
					<?php else: ?>
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/error-404.png' ) ?>" alt="404">
					<?php endif;?>
				</div>
				<div class="error-text text-center">
					<h3>
						<?php
							if( !empty( yankee_get_option('error_title') ) ) {
								echo esc_html( yankee_get_option('error_title') );
							} else {
								echo esc_html_e( 'Page not found', 'yankee' );
							}
						?>
					</h3>
					<p>
						<?php
							if( !empty( yankee_get_option('error_msg') ) ) {
								echo esc_html( yankee_get_option('error_msg') );
							} else {
								echo esc_html_e( 'Oops! The page you are looking for does not exist. Maybe go to our home page or try to use a search?', 'yankee' );
							}
						?>
					</p>

					<a href="<?php echo esc_url(home_url( '/')) ?>" class="main-btn">
						<?php
							if( !empty( yankee_get_option('error_btn_text') ) ) {
								echo esc_html( yankee_get_option('error_btn_text') );
							} else {
								echo esc_html_e( 'Back to home page', 'yankee' );
							}
						?>
					</a>
				</div>
			</div>
		</div>
	</div>
</div>

<?php
get_footer();
