/*-----------------------------------------------------------------------------------
	Template Name: Yankee
	Template URI: https://webtend.net/wp/yankee/
	Author: WebTend
	Author URI: https://webtend.net/
	Version: 1.0

	Note: This is Main js File For custom and jQuery plugins activation Code..
-----------------------------------------------------------------------------------

/*---------------------------
	JS INDEX
	===================
	01. Main Menu
	02. Gallery Post Slider
	03. Popup video
	04. Sticky Header
	05. Preloader

-----------------------------*/

(function ($) {
	'use strict';
	/*-----------------------------
	=== ALL ESSENTIAL FUNCTIONS ===
	------------------------------*/

	// ===== 01. Main Menu
	function mainMenu() {
		var mobileMenu = $('.mobile-menu'),
			menuItems = $('.menu-items'),
			navbarToggler = $('.navbar-toggler'),
			closeIcon = $('.navbar-close');

		// Navbar toggler
		navbarToggler.on('click', function () {
			navbarToggler.toggleClass('active');
			mobileMenu.toggleClass('menu-on');
		});

		// Close icon
		closeIcon.on('click', function () {
			mobileMenu.removeClass('menu-on');
			navbarToggler.removeClass('active');
		});

		// Adds toggle button to li items that have children
		menuItems.find('li a').each(function () {
			if ($(this).next().length > 0) {
				$(this)
					.parent('li')
					.append('<span class="dd-trigger"><i class="fal fa-angle-down"></i></span>');
			}
		});

		// expands the dropdown menu on each click
		menuItems.find('li .dd-trigger').on('click', function (e) {
			e.preventDefault();
			$(this)
				.toggleClass('open')
				.parent('li')
				.children('ul')
				.stop(true, true)
				.slideToggle(350);
		});

		// Search Form
		var searchBtn = $('.search-icon'),
			searchForm = $('.search-form');

		searchBtn.on('click', function (e) {
			searchForm.toggleClass('search-on');
			$(this).toggleClass('search-on');
			e.preventDefault();
		});

		// Offcanvs Menu
		var offcanvasBtn = $('.off-canvas-btn'),
			offcanvasItems = $('.off-canvas-items'),
			offcanvasoverly = $('.canvas-overly'),
			offcanvaClose = $('.canvas-close');

		offcanvasBtn.on('click', function (e) {
			offcanvasItems.addClass('off-canvas-show');
			offcanvasoverly.addClass('off-canvas-show');
			e.preventDefault();
		});

		offcanvaClose.on('click', function (e) {
			offcanvasItems.removeClass('off-canvas-show');
			offcanvasoverly.removeClass('off-canvas-show');
			e.preventDefault();
		});

		offcanvasoverly.on('click', function (e) {
			offcanvasItems.removeClass('off-canvas-show');
			$(this).removeClass('off-canvas-show');
			e.preventDefault();
		});
	}

	// ===== 02. Gallery Post Slider
	function galleryPostSlider() {
		var slide = $('.yankee-gallery-slider');
		slide.slick({
			infinite: true,
			slidesToShow: 1,
			slidesToScroll: 1,
			autoplay: true,
			autoplaySpeed: 5000,
			speed: 500,
			arrows: true,
			fade: false,
			dots: false,
			swipe: true,
			nextArrow: '<button class="slick-arrow next-arrow"><i class="far fa-arrow-right"></i></button>',
			prevArrow: '<button class="slick-arrow prev-arrow"><i class="far fa-arrow-left"></i></button>',
		});
	}

	// ===== 03. Popup video
	function popupVideo() {
		$('.popup-video').magnificPopup({
			type: 'iframe',
		});
	}

	// ===== 04. Sticky Header
	function stickyHeader() {
		var sticky = $('.sticky-haeder');
		var scrollFromtop = $(window).scrollTop();
		var scrollLimit = $('header').height() + 10;

		if (scrollFromtop < scrollLimit) {
			sticky.removeClass('sticky-on');
		} else {
			sticky.addClass('sticky-on');
		}
	}

	// ===== 05. Preloader
	function preloader() {
		if ($('#preloader').length) {
			$('#preloader').delay(100).fadeOut(500);
		}
	}

	// ===== 06. Clippy Shape
	function clippyShape() {
		$('.body-clippy-shape').css("height", $('#page').height());
	}

	/*---------------------
	=== DOCUMENT READY  ===
	----------------------*/
	$(document).ready(function () {
		mainMenu();
		galleryPostSlider();
		popupVideo();
		// clippyShape();
	});

	/*--------------------
	=== WINDOW SCROLL  ===
	----------------------*/
	$(window).on('scroll', function () {
		stickyHeader();
	});

	/*------------------
	=== WINDOW LOAD  ===
	--------------------*/
	$(window).on('load', function () {
		preloader();
	});

})(jQuery);