<?php
/**
 * Onle Clcik demo import
 *
 * @package Yankee
 */

if ( !function_exists( 'yankee_import_files' ) ) {
    function yankee_import_files() {
        return [
            [
                'import_file_name'             => esc_html__( 'Main Demo', 'yankee' ),
                'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demo/demo-content.xml',
                'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demo/widgets.wie',
                'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/demo/customizer.dat',
                'import_notice'                => esc_html__( 'Before you begin, make sure all the required plugins are install and activated. After you import this demo, you need to setup menu and front page. Read documentation for more informations.', 'yankee' ),
            ],
        ];
    }
    add_filter( 'pt-ocdi/import_files', 'yankee_import_files' );
}

if ( !function_exists( 'yankee_after_import_setup' ) ) {
    function yankee_after_import_setup() {

        // Assign menus to their locations.
        $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
        set_theme_mod( 'nav_menu_locations',
            [
                'primary_menu' => $main_menu->term_id,
                'mobile_menu'  => $main_menu->term_id,
            ]
        );

        // Assign front page and posts page (blog page).
        $front_page_id = get_page_by_title( 'Home' );
        $blog_page_id = get_page_by_title( 'Blog' );

        // Disable Elementor's Default Colors and Default Fonts
        update_option( 'elementor_disable_color_schemes', 'yes' );
        update_option( 'elementor_disable_typography_schemes', 'yes' );
        update_option( 'elementor_global_image_lightbox', 'yes' );

        // Set the home page and blog page
        update_option( 'show_on_front', 'page' );
        update_option( 'page_on_front', $front_page_id->ID );
        update_option( 'page_for_posts', $blog_page_id->ID );

    }

    add_action( 'pt-ocdi/after_import', 'yankee_after_import_setup' );
}