<?php
/**
 * Page Header for Yankee
 *
 * @package yankee
 */

if ( !defined( 'ABSPATH' ) ) {
    exit( 'No direct script access allowed' );
}

function yankee_get_breadcrumbs() {

    $wrap_tag = 'ul';
    $wrap_class = 'breadcrumb-nav';
    $active_class = 'active';

    // Open list
    $breadcrumb = '<' . esc_attr( $wrap_tag ) . ' class="' . esc_attr( $wrap_class ) . '">';
    // Front page
    if ( is_front_page() ) {
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . esc_html__( 'Kezdőlap', 'yankee' ) . '</li>'; //get_bloginfo( 'name' )
    } else {
        $breadcrumb .= '<li><a href="' . esc_url( home_url() ) . '">' . esc_html__( 'Kezdőlap', 'yankee' ) . '</a></li>'; //get_bloginfo( 'name' )
    }
    // Blog archive
    if ( 'page' == get_option( 'show_on_front' ) && get_option( 'page_for_posts' ) ) {
        $blog_page_id = get_option( 'page_for_posts' );
        if ( is_home() ) {
            $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . wp_kses_post( get_the_title( $blog_page_id ) ) . '</li>';
        } else if ( is_category() || is_tag() || is_author() || is_date() || is_singular( 'post' ) ) {
            $breadcrumb .= '<li><a href="' . esc_url( get_permalink( $blog_page_id ) ) . '">' . wp_kses_post( get_the_title( $blog_page_id ) ) . '</a></li>';
        }
    }
    // Category, tag, author and date archives
    if ( is_archive() && !is_tax() && !is_post_type_archive() ) {
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">';
        // Title of archive
        if ( is_category() ) {
            $breadcrumb .= esc_html( single_cat_title( '', false ) );
        } else if ( is_tag() ) {
            $breadcrumb .= esc_html( single_tag_title( '', false ) );
        } else if ( is_author() ) {
            $breadcrumb .= esc_html( get_the_author() );
        } else if ( is_date() ) {
            if ( is_day() ) {
                $breadcrumb .= esc_html( get_the_time( 'F j, Y' ) );
            } else if ( is_month() ) {
                $breadcrumb .= esc_html( get_the_time( 'F, Y' ) );
            } else if ( is_year() ) {
                $breadcrumb .= esc_html( get_the_time( 'Y' ) );
            }
        }
        $breadcrumb .= '</li>';
    }
    // Post
    if ( is_singular( 'post' ) ) {
        $breadcrumb .= '<li class="' . $active_class . '">' . get_the_title() . '</li>';
    }
    // Pages
    if ( is_page() && !is_front_page() ) {
        $post = get_post( get_the_ID() );
        // Page parents
        if ( $post->post_parent ) {
            $parent_id = $post->post_parent;
            $crumbs = [];
            while ( $parent_id ) {
                $page = get_post( $parent_id );
                $crumbs[] = '<a href="' . esc_url( get_permalink( $page->ID ) ) . '">' . wp_kses_post( get_the_title( $page->ID ) ) . '</a>';
                $parent_id = $page->post_parent;
            }
            $crumbs = array_reverse( $crumbs );
            foreach ( $crumbs as $crumb ) {
                $breadcrumb .= '<li>' . wp_kses_data( $crumb ) . '</li>';
            }
        }
        // Page title
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . wp_kses_post( get_the_title() ) . '</li>';
    }
    // Attachments
    if ( is_attachment() ) {
        // Attachment parent
        $post = get_post( get_the_ID() );
        if ( $post->post_parent ) {
            $breadcrumb .= '<li><a href="' . esc_url( get_permalink( $post->post_parent ) ) . '">' . esc_html( get_the_title( $post->post_parent ) ) . '</a></li>';
        }
        // Attachment title
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . esc_html( get_the_title() ) . '</li>';
    }
    // Search
    if ( is_search() ) {
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . esc_html__( 'Search', 'yankee' ) . '</li>';
    }
    // 404
    if ( is_404() ) {
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . esc_html__( '404', 'yankee' ) . '</li>';
    }
    // Custom Post Type Archive
    if ( is_post_type_archive() ) {
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . post_type_archive_title( '', false ) . '</li>';
    }
    // Custom Taxonomies
    if ( is_tax() ) {
        // Get the post types the taxonomy is attached to
        $current_term = get_queried_object();
        $attached_to = [];
        $post_types = get_post_types();
        foreach ( $post_types as $post_type ) {
            $taxonomies = get_object_taxonomies( $post_type );
            if ( in_array( $current_term->taxonomy, $taxonomies ) ) {
                $attached_to[] = $post_type;
            }
        }
        // Post type archive link
        $output = false;
        foreach ( $attached_to as $post_type ) {
            $cpt_obj = get_post_type_object( $post_type );
            if ( !$output && get_post_type_archive_link( $cpt_obj->name ) ) {
                $breadcrumb .= '<li><a href="' . get_post_type_archive_link( $cpt_obj->name ) . '">' . $cpt_obj->labels->singular_name . '</a></li>';
                $output = true;
            }
        }
        // Term title
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . single_term_title( '', false ) . '</li>';
    }

    // Custom Post Types
    if ( is_single() && get_post_type() != 'post' && get_post_type() != 'attachment' ) {
        $cpt_obj = get_post_type_object( get_post_type() );

        // Cpt archive
        if ( get_post_type_archive_link( $cpt_obj->name ) ) {
            // Custom portfolio archive page link
            $archive_link = get_post_type_archive_link( $cpt_obj->name );

            $breadcrumb .= '<li><a href="' . esc_url( $archive_link ) . '">' . $cpt_obj->labels->singular_name . '</a></li>';
        }

        // Is cpt hierarchical like pages or posts?
        if ( is_post_type_hierarchical( $cpt_obj->name ) ) {
            // Like pages
            // Cpt parents
            $post = get_post( get_the_ID() );
            if ( $post->post_parent ) {
                $parent_id = $post->post_parent;
                $crumbs = [];
                while ( $parent_id ) {
                    $page = get_post( $parent_id );
                    $crumbs[] = '<a href="' . esc_url( get_permalink( $page->ID ) ) . '">' . wp_kses_post( get_the_title( $page->ID ) ) . '</a>';
                    $parent_id = $page->post_parent;
                }
                $crumbs = array_reverse( $crumbs );
                foreach ( $crumbs as $crumb ) {
                    $breadcrumb .= '<li>' . wp_kses_data( $crumb ) . '</li>';
                }
            }
        } else {
            // Get cpt taxonomies
            $cpt_taxes = get_object_taxonomies( $cpt_obj->name );
            if ( $cpt_taxes && is_taxonomy_hierarchical( $cpt_taxes[0] ) ) {
                // Other taxes attached to the cpt could be hierachical, so need to look into that.
                $cpt_terms = get_the_terms( get_the_ID(), $cpt_taxes[0] );
                if ( is_array( $cpt_terms ) ) {
                    $output = false;
                    foreach ( $cpt_terms as $cpt_term ) {
                        if ( !$output ) {
                            $breadcrumb .= '<li><a href="' . get_term_link( $cpt_term->name, $cpt_taxes[0] ) . '">' . $cpt_term->name . '</a></li>';
                            $output = true;
                        }
                    }
                }
            }
        }
        // Cpt title
        $breadcrumb .= '<li class="' . esc_attr( $active_class ) . '">' . wp_kses_post( get_the_title() ) . '</li>';
    }
    // Close list
    $breadcrumb .= '</' . esc_attr( $wrap_tag ) . '>';

    // Ouput
    return $breadcrumb;
}

/**
 * Yankee Page Header function
 */
function yankee_page_header() {
    $page_heading = yankee_get_option( 'page-heading', 'enabled' );
    $title_tag = yankee_get_option( 'page-title-tag', 'Welcome to our company' );
    $breadcrumb = yankee_get_option( 'site-breadcrumb', 'enabled' );

    $custom_title = '';

    // Check If Page Setting Changes
    if ( is_page() && !is_home() ) {

        $page_meta = get_post_meta( get_the_ID(), 'yankee_page_metaboxes', true );

        if ( !empty( $page_meta['page_heading'] ) ) {
            $page_heading = $page_meta['page_heading'];
        }

        if ( !empty( $page_meta['page_title_tag'] ) ) {
            $title_tag = $page_meta['page_title_tag'];
        }

        if ( !empty( $page_meta['page_custom_title'] ) && $page_meta['use_page_custom_title'] ) {
            $custom_title = $page_meta['page_custom_title'];
        }
    }

    if ( 'disabled' == $page_heading || is_404() ) {
        return;
    }

    $title_output = [];

    if ( is_home() ) {
        $title = esc_html__( 'News feeds', 'yankee' );
    } elseif ( is_singular( 'post' ) ) {
        $title = esc_html__( 'News Details', 'yankee' );
    } elseif ( is_singular() && 'team-members' == get_post_type() ) {
        $title = esc_html__( 'Member Details', 'yankee' );
    } elseif ( is_singular() && 'portfolios' == get_post_type() ) {
        $title = esc_html__( 'Work Details', 'yankee' );
    } elseif ( is_singular() && 'services' == get_post_type() ) {
        $title = esc_html__( 'Service Details', 'yankee' );
    } elseif ( is_search() ) {
        $title = esc_html__( 'Search Results for: ', 'yankee' ) . get_search_query();
    } elseif ( is_archive() ) {
        $title = wp_kses_post( get_the_archive_title() );
    } elseif ( !empty( $custom_title ) ) {
        $title = esc_html( $custom_title );
    } else {
        $title = wp_kses_post( get_the_title() );
    }

    if ( $title ) {
        $title_output[] = sprintf( '%s', $title );
    }

    ?>

    <div class="page-haeder" >
        <div class="container">
            <?php if ( !empty( $title_tag ) ): ?>
                <span class="page-tag"><?php echo esc_html( $title_tag ) ?></span>
            <?php endif;?>
            <h2 class="page-title"><?php echo implode( '', $title_output ); ?></h2>

            <?php
                if ( 'enabled' == $breadcrumb ) {
                    echo yankee_get_breadcrumbs();
                }
            ?>
        </div>
    </div>

<?php
}