<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package yankee
 */

if ( 'no-sidebar' === yankee_get_sidebar() ){
	return;
}

if ( ! is_active_sidebar( 'primary_sidebar' ) && 'post' == get_post_type() ) {
	return;
}

if ( ! is_active_sidebar( 'service_sidebar' ) && 'services' == get_post_type() ) {
	return;
}

if ( ! is_active_sidebar( 'portfolio_sidebar' ) && 'portfolios' == get_post_type() ) {
	return;
}

?>

<div class="col-lg-4 col-12">
	<?php if( is_single() && 'services' == get_post_type() ) : ?>
		<div id="secondary" class="widget-area service-sidebar">
			<?php dynamic_sidebar( 'service_sidebar' ); ?>
		</div>
	<?php elseif( is_single() && 'portfolios' == get_post_type() ) : ?>
		<div id="secondary" class="widget-area portfolio-sidebar">
			<?php dynamic_sidebar( 'portfolio_sidebar' ); ?>
		</div>
	<?php else : ?>
		<div id="secondary" class="widget-area primary-sidebar ">
			<?php dynamic_sidebar( 'primary_sidebar' ); ?>
		</div>
	<?php endif; ?>
</div>
