<?php

/**
 * Template part for displaying single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package yankee
 */

?>

<div id="post-<?php the_ID(); ?>" <?php post_class('entry-single-post post-details'); ?>>
	<div class="post-content-area">
		<div class="entry-content clearfix">
			<?php
				echo yankee_posted_in();
				the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');

				if ( yankee_get_option( 'show-post-meta' ) ) {
					echo yankee_post_meta();
				}

				the_content(sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__('Continue reading<span class="screen-reader-text"> "%s"</span>', 'yankee'),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				));

				wp_link_pages(array(
					'before' => '<div class="page-links">' . esc_html__('Pages:', 'yankee'),
					'after' => '</div>',
				));
			?>
		</div>

		<div class="entry-footer">
			<?php if( yankee_get_option( 'show-post-tag' ) || yankee_get_option( 'show-post-share' ) ) : ?>
				<div class="row justify-content-between align-items-start">
					<?php if( yankee_get_option( 'show-post-tag' ) && has_tag() ) : ?>
						<div class="col-md-6">
							<div class="related-tags">
								<h5><?php echo esc_html( yankee_get_option( 'post-tag-title', 'Releted Tags' ) ) ?></h5>
								<?php the_tags('<ul><li>', '</li><li>', '</li></ul>'); ?>
							</div>
						</div>
					<?php endif; ?>
					<?php if( yankee_get_option( 'show-post-share' ) ) : ?>
						<div class="col-md-6">
							<div class="social-share">
								<h5><?php echo esc_html( yankee_get_option( 'post-share-title', 'Social Share') ) ?></h5>
								<?php yankee_post_share(); ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<?php
				if( yankee_get_option( 'show-post-nav' ) ) {
					yankee_post_nav();
				}
			 ?>
		</div>

		<?php
			if( yankee_get_option( 'show-related-post' ) ) {
				yankee_related_post();
			}

			if( yankee_get_option( 'show-author-info' ) ) {
				yankee_author_info();
			}
		?>

		<?php
		// If comments are open or we have at least one comment, load up the comment template.
		if (comments_open() || get_comments_number()) :
			comments_template();
		endif;
		?>
	</div>
</div>