<?php
/**
 * Template part for displaying header one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package yankee
 */

?>

<div class="container-fluid container-1500">
    <div class="header-nav header-nav-one">
        <div class="nav-container<?php if ( ! yankee_get_option( 'show-contact-btn' ) ) : ?> no-contact-btn<?php endif; ?>">
            <!-- Site Logo -->
            <div class="site-logo">
                <?php if ( yankee_get_option( 'use-text-logo' ) && !empty( yankee_get_option( 'site-text-logo' ) ) ): ?>
                    <h2><a href="<?php echo esc_url( home_url() ) ?>"><?php echo esc_html( yankee_get_option( 'site-text-logo' ) ) ?></a></h2>
                <?php elseif ( !empty( yankee_get_option( 'site-img-logo' )['url'] ) ): ?>
                    <a href="<?php echo esc_url( home_url() ) ?>">
                        <img src="<?php echo esc_url( yankee_get_option( 'site-img-logo' )['url'] ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                    </a>
                <?php else: ?>
                    <a href="<?php echo esc_url( home_url() ) ?>">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/yankee.png' ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                    </a>
                <?php endif;?>
            </div>

            <?php if ( has_nav_menu( 'primary_menu' ) ) : ?>
                <!-- Mneu Items -->
                <div class="menu-items">
                    <?php
                        if ( has_nav_menu( 'primary_menu' ) ) {
                            wp_nav_menu( [
                                'theme_location' => 'primary_menu',
                                'container'      => '',
                                'menu_class'     => 'primary-menu',
                            ] );
                        }
                    ?>
                </div>
            <?php endif; ?>

            <?php if( yankee_get_option( 'show-search-form' ) ) : ?>
                <!-- Navbar Extra  -->
                <div class="d-flex align-items-center">
                    <div class="serach-wrap">
                        <a href="#" class="search-icon">
                            <i class="fal fa-search"></i>
                        </a>
                        <div class="search-form">
                            <?php get_search_form();?>
                        </div>
                    </div>

                    <?php if ( has_nav_menu( 'mobile_menu' ) ) : ?>
                        <!-- Navbar Toggler -->
                        <div class="navbar-toggler">
                            <span></span><span></span><span></span>
                        </div>
                    <?php endif; ?>
                </div>

            <?php elseif ( has_nav_menu( 'mobile_menu' ) ) : ?>
                <!-- Navbar Toggler -->
                <div class="navbar-toggler">
                    <span></span><span></span><span></span>
                </div>
            <?php endif; ?>
        </div>

        <?php
            if ( yankee_get_option( 'show-contact-btn' ) ) {
                ynakee_header_contact_btn();
            }
        ?>

        <?php if ( has_nav_menu( 'mobile_menu' ) ) : ?>
            <!-- Mobile Menu  -->
            <div class="mobile-menu">
                <!-- Navbar Close -->
                <div class="navbar-close">
                    <div class="cross-wrap"><span></span><span></span></div>
                </div>

                <div class="site-logo">
                    <?php if ( yankee_get_option( 'use-m-text-logo' ) && !empty( yankee_get_option( 'site-m-text-logo' ) ) ): ?>
                        <h2><a href="<?php echo esc_url( home_url() ) ?>"><?php echo esc_html( yankee_get_option( 'site-m-text-logo' ) ) ?></a></h2>
                    <?php elseif ( !empty( yankee_get_option( 'site-m-img-logo' )['url'] ) ): ?>
                        <a href="<?php echo esc_url( home_url() ) ?>">
                            <img src="<?php echo esc_url( yankee_get_option( 'site-m-img-logo' )['url'] ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                        </a>
                    <?php else: ?>
                        <a href="<?php echo esc_url( home_url() ) ?>">
                            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/yankee-mobile.png' ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                        </a>
                    <?php endif;?>
                </div>

                <div class="menu-items">
                    <?php
                        if ( has_nav_menu( 'mobile_menu' ) ) {
                            wp_nav_menu( [
                                'theme_location' => 'mobile_menu',
                                'container'      => '',
                                'menu_class'     => 'primary-menu',
                            ] );
                        }
                    ?>
                </div>

                <?php
                    if ( yankee_get_option( 'show-contact-btn' ) ) {
                        ynakee_header_contact_btn();
                    }
                ?>
            </div>
        <?php endif ?>
    </div>
</div>