<?php
/**
 * Template part for displaying header two
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package yankee
 */

?>

<div class="container-fluid container-1320">
    <div class="header-nav header-nav-three">
        <div class="nav-container<?php if ( ! yankee_get_option( 'show-contact-btn' ) ) : ?> no-contact-btn<?php endif; ?>">
            <!-- Site Logo -->
            <div class="site-logo">
                <?php if ( yankee_get_option( 'use-text-logo' ) && !empty( yankee_get_option( 'site-text-logo' ) ) ): ?>
                    <h2><a href="<?php echo esc_url( home_url() ) ?>"><?php echo esc_html( yankee_get_option( 'site-text-logo' ) ) ?></a></h2>
                <?php elseif ( !empty( yankee_get_option( 'site-img-logo' )['url'] ) ) : ?>
                    <a href="<?php echo esc_url( home_url() ) ?>">
                        <img src="<?php echo esc_url( yankee_get_option( 'site-img-logo' )['url'] ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                    </a>
                <?php else: ?>
                    <a href="<?php echo esc_url( home_url() ) ?>">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/yankee.png' ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                    </a>
                <?php endif;?>
            </div>

            <?php if ( has_nav_menu( 'primary_menu' ) ) : ?>
                <!-- Mneu Items -->
                <div class="menu-items">
                    <?php
                        if ( has_nav_menu( 'primary_menu' ) ) {
                            wp_nav_menu( [
                                'theme_location' => 'primary_menu',
                                'container'      => '',
                                'menu_class'     => 'primary-menu',
                            ] );
                        }
                    ?>
                </div>
            <?php endif; ?>

            <?php if( yankee_get_option( 'show-search-form' ) || yankee_get_option( 'show-offcanvas-panel' ) ) : ?>
                <!-- Navbar Extra  -->
                <div class="d-flex align-items-center">
                    <?php if( yankee_get_option( 'show-search-form' ) ) : ?>
                        <div class="serach-wrap">
                            <a href="javascript:void(0)" class="search-icon">
                                <i class="fal fa-search"></i>
                            </a>
                            <div class="search-form">
                                <?php get_search_form();?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if( yankee_get_option( 'show-offcanvas-panel' ) ) : ?>
                        <div class="off-canvas-wrap d-none d-lg-block">
                            <a href="javascript:void(0)" class="off-canvas-btn">
                                <i class="fal fa-bars"></i>
                            </a>
                            <div class="canvas-overly"></div>
                            <div class="off-canvas-items">
                                <a href="javascript:void(0)" class="canvas-close">
                                    <i class="far fa-times"></i>
                                </a>
                                <div class="about-text">
                                    <div class="logo text-center">
                                        <?php if( !empty( yankee_get_option( 'panel-img-logo' )['url'] ) ) : ?>
                                            <img src="<?php echo esc_url( yankee_get_option( 'panel-img-logo' )['url'] ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                                        <?php else : ?>
                                            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/yankee-mobile.png' ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                                        <?php endif; ?>
                                    </div>
                                    <?php echo wpautop( esc_html( yankee_get_option( 'panel-desc' ) ) ) ?>
                                </div>
                                <?php if( !empty( yankee_get_option( 'contact-blocks' ) ) ) : ?>
                                    <div class="contact-blocks-wrapper">
                                        <?php foreach( yankee_get_option( 'contact-blocks' ) as $contact_blocks ) : ?>
                                            <div class="contact-block">
                                                <h5 class="contact-block-title">
                                                    <?php echo esc_html( $contact_blocks[ 'contact-block-title' ] ) ?>
                                                </h5>
                                                <?php if( !empty( $contact_blocks[ 'contact-blocks-infos' ] ) ) : ?>
                                                    <ul>
                                                        <?php foreach( $contact_blocks[ 'contact-blocks-infos' ] as $info ) : ?>
                                                            <li><?php echo esc_html( $info[ 'contact-info' ] ) ?></li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; if( !empty( yankee_get_option( 'panel-social-icons' ) ) ) : ?>
                                    <div class="social-icons">
                                        <?php foreach( yankee_get_option( 'panel-social-icons' ) as $social ) : ?>
                                            <a href="<?php echo esc_url( $social[ 'panel-social-links' ] ) ?>">
                                                <i class="<?php echo esc_attr( $social[ 'panel-social-icon' ] ) ?>"></i>
                                            </a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ( has_nav_menu( 'mobile_menu' ) ) : ?>
                        <!-- Navbar Toggler -->
                        <div class="navbar-toggler">
                            <i class="fal fa-bars"></i>
                        </div>
                    <?php endif; ?>
                </div>

            <?php elseif ( has_nav_menu( 'mobile_menu' ) ) : ?>
                <!-- Navbar Toggler -->
                <div class="navbar-toggler">
                    <i class="fal fa-bars"></i>
                </div>
            <?php endif; ?>

        </div>

        <?php if ( has_nav_menu( 'mobile_menu' ) ) : ?>
            <!-- Mobile Menu  -->
            <div class="mobile-menu">
                <!-- Navbar Close -->
                <div class="navbar-close">
                    <div class="cross-wrap"><span></span><span></span></div>
                </div>

                <div class="site-logo">
                    <?php if ( yankee_get_option( 'use-m-text-logo' ) && !empty( yankee_get_option( 'site-m-text-logo' ) ) ): ?>
                        <h2><a href="<?php echo esc_url( home_url() ) ?>"><?php echo esc_html( yankee_get_option( 'site-m-text-logo' ) ) ?></a></h2>
                    <?php elseif ( !empty( yankee_get_option( 'site-m-img-logo' )['url'] ) ): ?>
                        <a href="<?php echo esc_url( home_url() ) ?>">
                            <img src="<?php echo esc_url( yankee_get_option( 'site-m-img-logo' )['url'] ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                        </a>
                    <?php else: ?>
                        <a href="<?php echo esc_url( home_url() ) ?>">
                            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/yankee-mobile.png' ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
                        </a>
                    <?php endif;?>
                </div>

                <div class="menu-items">
                    <?php
                        if ( has_nav_menu( 'mobile_menu' ) ) {
                            wp_nav_menu( [
                                'theme_location' => 'mobile_menu',
                                'container'      => '',
                                'menu_class'     => 'primary-menu',
                            ] );
                        }
                    ?>
                </div>

                <?php
                    if ( yankee_get_option( 'show-contact-btn' ) ) {
                        ynakee_header_contact_btn();
                    }
                ?>
            </div>
        <?php endif; ?>
    </div>
</div>