<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

// setting elementor canvas as default template for CPT - footer
function yankee_toolkit_footer_canvas() {
    global $post;

    // Check if its a correct post type/types to apply template
    if ( !in_array( $post->post_type, ['footer'] ) || !did_action( 'elementor/loaded' ) ) {
        return;
    }
    // Check that a template is not set already
    if ( '' !== $post->page_template ) {
        return;
    }
    // Make sure its not a page for posts
    if ( get_option( 'page_for_posts' ) === $post->ID ) {
        return;
    }

    //Finally set the page template
    $post->page_template = 'elementor_canvas';
    update_post_meta( $post->ID, '_wp_page_template', 'elementor_canvas' );
}

add_action( 'add_meta_boxes', 'yankee_toolkit_footer_canvas', 10 );

/**
 * Add options to sections
 */
add_action( 'elementor/element/section/section_typo/after_section_end', function ( $section, $args ) {

    /* header options */
    $section->start_controls_section(
        'yankee_section_option',
        [
            'label' => esc_html__( 'Yankee Extra Options', 'yankee-toolkit' ),
            'tab'   => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );

    $section->add_responsive_control(
        'column_align', [
            'label'     => esc_html__( 'Horizontal Column Alignment', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::SELECT,
            'options'   => [
                'flex-start' => esc_html__( 'Left', 'yankee-toolkit' ),
                'center'     => esc_html__( 'Center', 'yankee-toolkit' ),
                'flex-end'   => esc_html__( 'End', 'yankee-toolkit' ),
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-container' => 'justify-content: {{VALUE}};',
            ],
        ]
    );

    $section->end_controls_section();

    $section->start_controls_section(
        'yankee_overly_option',
        [
            'label' => esc_html__( 'Yankee Overly Options', 'yankee-toolkit' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ]
    );

    $section->add_responsive_control(
        'yankee_overly_width',
        [
            'label'     => esc_html__( 'Width', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'max'       => 100,
            'step'      => 1,
            'selectors' => [
                '{{WRAPPER}} .elementor-background-overlay' => 'width: {{VALUE}}%;',
            ],
        ]
    );

    $section->add_responsive_control(
        'yankee_overly_height',
        [
            'label'     => esc_html__( 'Height', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'max'       => 100,
            'step'      => 1,
            'selectors' => [
                '{{WRAPPER}} .elementor-background-overlay' => 'height: {{VALUE}}%;',
            ],
        ]
    );

    $section->add_control(
        'overly_align',
        [
            'label'   => esc_html__( 'Overly Position', 'yankee-toolkit' ),
            'type'    => Elementor\Controls_Manager::SELECT,
            'default' => 'default',
            'options' => [
                'default'      => esc_html__( 'Default', 'yankee-toolkit' ),
                'left-top'     => esc_html__( 'Left Top', 'yankee-toolkit' ),
                'right-top'    => esc_html__( 'Right Top', 'yankee-toolkit' ),
                'left-bottom'  => esc_html__( 'Left Bottom', 'yankee-toolkit' ),
                'right-bottom' => esc_html__( 'Right Bottom', 'yankee-toolkit' ),
            ],
        ]
    );

    $section->add_responsive_control(
        'overly_right_top-right',
        [
            'label'     => esc_html__( 'From Right', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'max'       => 100,
            'step'      => 1,
            'default'   => 0,
            'selectors' => [
                '{{WRAPPER}} .elementor-background-overlay' => 'right: {{VALUE}}%; left: auto;',
            ],
            'condition' => [
                'overly_align' => 'right-top',
            ],
        ]
    );

    $section->add_responsive_control(
        'overly_right_top-top',
        [
            'label'     => esc_html__( 'From Top', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'max'       => 100,
            'step'      => 1,
            'default'   => 0,
            'selectors' => [
                '{{WRAPPER}} .elementor-background-overlay' => 'top: {{VALUE}}%;',
            ],
            'condition' => [
                'overly_align' => 'right-top',
            ],
        ]
    );

    $section->add_responsive_control(
        'overly_left_bottom-left',
        [
            'label'     => esc_html__( 'From Left', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'max'       => 100,
            'step'      => 1,
            'default'   => 0,
            'selectors' => [
                '{{WRAPPER}} .elementor-background-overlay' => 'left: {{VALUE}}%;',
            ],
            'condition' => [
                'overly_align' => 'left-bottom',
            ],
        ]
    );

    $section->add_responsive_control(
        'overly_left_bottom-bottom',
        [
            'label'     => esc_html__( 'From Bottom', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'max'       => 100,
            'step'      => 1,
            'default'   => 0,
            'selectors' => [
                '{{WRAPPER}} .elementor-background-overlay' => 'bottom: {{VALUE}}%; top: auto;',
            ],
            'condition' => [
                'overly_align' => 'left-bottom',
            ],
        ]
    );

    $section->add_responsive_control(
        'overly_right_bottom-right',
        [
            'label'     => esc_html__( 'From Right', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'max'       => 100,
            'step'      => 1,
            'default'   => 0,
            'selectors' => [
                '{{WRAPPER}} .elementor-background-overlay' => 'right: {{VALUE}}%; left: auto;',
            ],
            'condition' => [
                'overly_align' => 'right-bottom',
            ],
        ]
    );

    $section->add_responsive_control(
        'overly_right_bottom-bottom',
        [
            'label'     => esc_html__( 'From Bottom', 'yankee-toolkit' ),
            'type'      => Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'max'       => 100,
            'step'      => 1,
            'default'   => 0,
            'selectors' => [
                '{{WRAPPER}} .elementor-background-overlay' => 'bottom: {{VALUE}}%; top: auto;',
            ],
            'condition' => [
                'overly_align' => 'right-bottom',
            ],
        ]
    );

    $section->end_controls_section();

}, 10, 2 );

// Yankee
if ( !function_exists( 'yankee_toolkit_flaticon' ) ) {
    function yankee_toolkit_flaticon( $tabs = [] ) {

        $icon_css = plugins_url( 'flaticon/flaticon.css', __FILE__ );
        $icon_js = plugins_url( 'flaticon/flaticon.js', __FILE__ );

        $tabs['yankee-toolkit-flaticon'] = [
            'name'          => 'yankee-toolkit-flaticon',
            'label'         => esc_html__( 'Yankee Flaticon', 'yankee-toolkit' ),
            'labelIcon'     => 'far fa-laugh-wink',
            'prefix'        => 'flaticon-',
            'displayPrefix' => 'flaticon',
            'labelIcon'     => 'flaticon-graphic',
            'enqueue'       => [],
            'url'           => $icon_css,
            'fetchJson'     => $icon_js,
            'native'        => true,
            'ver'           => '1.0.0',
        ];

        return $tabs;
    }

    add_filter( 'elementor/icons_manager/additional_tabs', 'yankee_toolkit_flaticon' );
}