<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Heading extends Widget_Base {

    public function get_name() {
        return 'yankee-heading';
    }

    public function get_title() {
        return esc_html__( 'Heading', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-heading';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'heading', 'title'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Heading', 'yankee-toolkit' ),
            ]
        );
        $this->add_control(
            'title_type',
            [
                'label'   => esc_html__( 'Title Tagline', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'dual-title',
                'options' => [
                    'normal-title' => esc_html__( 'Normal Title', 'yankee-toolkit' ),
                    'dual-title'   => esc_html__( 'Dual Title', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'normal_title', [
                'label'       => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'condition'   => [
                    'title_type' => 'normal-title',
                ],
            ]
        );

        $this->add_control(
            'dual_title_1', [
                'label'       => esc_html__( 'Title One', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'condition'   => [
                    'title_type' => 'dual-title',
                ],
            ]
        );

        $this->add_control(
            'dual_title_2', [
                'label'       => esc_html__( 'Title Two', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'condition'   => [
                    'title_type' => 'dual-title',
                ],
            ]
        );

        $this->add_control(
            'content_title_tag', [
                'label'       => esc_html__( 'Title Tagline', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Title tagline', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'       => esc_html__( 'Title HTML Tag', 'yankee-toolkit' ),
                'type'        => Controls_Manager::CHOOSE,
                'label_block' => true,
                'options'     => [
                    'h1' => [
                        'title' => __( 'H1', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'     => 'h2',
                'toggle'      => false,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Style', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label'   => esc_html__( 'Text Align', 'yankee-toolkit' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .yankee-heading' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__( 'Content', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'tag_line_heading',
            [
                'label'     => esc_html__( 'Tag Line', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'tag_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-heading .tag-line' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_tag_typography',
                'selector' => '{{WRAPPER}} .yankee-heading .tag-line',
            ]
        );

        $this->add_responsive_control(
            'tag_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-heading .tag-line' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_headiing',
            [
                'label'     => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-heading .title'      => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'dual_title_color',
            [
                'label'     => esc_html__( 'Dual Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-heading .title span' => '-webkit-text-stroke: 1px {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_title_typography',
                'selector' => '{{WRAPPER}} .yankee-heading .title',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings(); ?>
            <div class="yankee-heading">
                <?php
                    if( $settings['content_title_tag'] ) {
                        printf( '<span class="tag-line">%1$s</span>',
                            esc_html( $settings['content_title_tag'] )
                        );
                    }

                    if ( $settings['title_type'] == 'dual-title' ) {
                        if ( $settings['dual_title_1'] || $settings['dual_title_2'] ) {
                            printf( '<%1$s class="title dual-title" >%2$s <span>%3$s</span></%1$s>',
                                tag_escape( $settings['title_tag'] ),
                                esc_html( $settings['dual_title_1'] ),
                                esc_html( $settings['dual_title_2'] )
                            );
                        }
                    } else {
                        if ( $settings['normal_title'] ) {
                            printf( '<%1$s class="title">%2$s</%1$s>',
                                tag_escape( $settings['title_tag'] ),
                                esc_html( $settings['normal_title'] )
                            );
                        }
                    }
                ?>
            </div>
        <?php
    }
}