<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use WP_Query;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Portfolio_Slider extends Widget_Base {

    public function get_name() {
        return 'yankee-portfolio-slider';
    }

    public function get_title() {
        return esc_html__( 'Portfolio Slider', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-slider-album';
    }

    public function get_style_depends() {
        return ['yankee-toolkit', 'slick'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'slick'];
    }

    public function get_keywords() {
        return ['yankee', 'portfolio', 'recent', 'project', 'slider'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Portfolio Query', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'portfolio_cats',
            [
                'label'       => esc_html__( 'Select Categories', 'yankee-toolkit' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->select_param_cates_post(),
                'multiple'    => true,
                'label_block' => true,
                'placeholder' => esc_html__( 'All Categories', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'show_count', [
                'label'       => esc_html__( 'Limit Item', 'yankee-toolkit' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 10,
                'min'         => 1,
            ]
        );

        $this->add_control(
            'order_by', [
                'label'   => esc_html__( 'Order By', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'none'       => esc_html__( 'None', 'yankee-toolkit' ),
                    'ID'         => esc_html__( 'Post ID', 'yankee-toolkit' ),
                    'author'     => esc_html__( 'Post Author', 'yankee-toolkit' ),
                    'title'      => esc_html__( 'Title', 'yankee-toolkit' ),
                    'date'       => esc_html__( 'Date', 'yankee-toolkit' ),
                    'modified'   => esc_html__( 'Last Modified Date', 'yankee-toolkit' ),
                    'rand'       => esc_html__( 'Random', 'yankee-toolkit' ),
                    'menu_order' => esc_html__( 'Menu Order', 'yankee-toolkit' ),
                ],
                'default' => 'date',
            ]
        );

        $this->add_control(
            'short_by', [
                'label'   => esc_html__( 'Order', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'ASC'  => esc_html__( 'Ascending', 'yankee-toolkit' ),
                    'DESC' => esc_html__( 'Descending', 'yankee-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'portfolio_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'portfolio_layout', [
                'label'   => esc_html__( 'Portfolio Layout', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'layout-center-mode'   => esc_html__( 'Style One', 'yankee-toolkit' ),
                    'layout-normal'   => esc_html__( 'Style Two', 'yankee-toolkit' ),
                ],
                'default' => 'layout-center-mode',
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'portfolio_thumbnail',
                'default' => 'full',
                'exclude' => [
                    'custom',
                ],
            ]
        );

        $this->add_control(
            'title_word',
            [
                'label'   => esc_html__( 'Title Length', 'yankee-toolkit' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label'        => __( 'Show Categories', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'yankee-toolkit' ),
                'label_off'    => __( 'Hide', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'show_link',
            [
                'label'        => __( 'Show Link Btn', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'yankee-toolkit' ),
                'label_off'    => __( 'Hide', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'hr1', [
                'type'    => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'arrow',
            [
                'label'   => esc_html__( 'Arrow?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'dots',
            [
                'label'   => esc_html__( 'Dots?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'   => esc_html__( 'Autoplay?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]

        );

        $this->add_control(
            'autoplay_time',
            [
                'label'     => esc_html__( 'Autoplay Time', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => '5000',
                'condition' => [
                    'autoplay' => 'true',
                ],
                'options'   => [
                    '1000'  => esc_html__( '1s', 'yankee-toolkit' ),
                    '2000'  => esc_html__( '2s', 'yankee-toolkit' ),
                    '3000'  => esc_html__( '3s', 'yankee-toolkit' ),
                    '4000'  => esc_html__( '4s', 'yankee-toolkit' ),
                    '5000'  => esc_html__( '5s', 'yankee-toolkit' ),
                    '6000'  => esc_html__( '6s', 'yankee-toolkit' ),
                    '7000'  => esc_html__( '7s', 'yankee-toolkit' ),
                    '8000'  => esc_html__( '8s', 'yankee-toolkit' ),
                    '9000'  => esc_html__( '9s', 'yankee-toolkit' ),
                    '10000' => esc_html__( '10s', 'yankee-toolkit' ),
                    '11000' => esc_html__( '11s', 'yankee-toolkit' ),
                    '12000' => esc_html__( '12s', 'yankee-toolkit' ),
                    '13000' => esc_html__( '13s', 'yankee-toolkit' ),
                    '14000' => esc_html__( '14s', 'yankee-toolkit' ),
                    '15000' => esc_html__( '15s', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_items_style',
            [
                'label' => esc_html__( 'Portfolio Items', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'items_grid_gap',
            [
                'label'       => esc_html__( 'Grid Gap', 'yankee-toolkit' ),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => ['px'],
                'range'       => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 50,
                        'step' => 1,
                    ],
                ],
                'selectors'   => [
                    '{{WRAPPER}} .portfolio-items'                 => 'margin: 0 -{{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .portfolio-items .portfolio-item' => 'padding: 0 {{SIZE}}{{UNIT}};',
                ],
                'description' => esc_html__( 'You may have to reload this to see the change of grid-gap properly', 'yankee-toolkit' ),
            ]
        );

        $this->add_responsive_control(
            'items_width',
            [
                'label'       => esc_html__( 'Items height', 'yankee-toolkit' ),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => ['px'],
                'range'       => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'   => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-thumb' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'description' => esc_html__( 'You may have to reload this to see the change of height properly', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'content_area_heading',
            [
                'label'     => esc_html__( 'Content Area', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'content_area_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_area_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-desc' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_haeding',
            [
                'label'     => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-desc .title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title__hover_color',
            [
                'label'     => esc_html__( 'Hover Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-desc .title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-desc .title',
            ]
        );

        $this->add_control(
            'categories_title',
            [
                'label'     => esc_html__( 'Categories', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_cat' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'categories_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-desc .cat' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_cat' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'categories_typography',
                'selector'  => '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-desc .cat',
                'condition' => [
                    'show_cat' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'link_haeding',
            [
                'label'     => esc_html__( 'Link Button', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_link' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'link_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-link' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_cat' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'link_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-link' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'show_cat' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'link_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-link:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_cat' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'link_bg_hover__color',
            [
                'label'     => esc_html__( 'Background(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-items .portfolio-item .portfolio-link:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'show_cat' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        ?>
            <div class="yankee-portfolio-widgets">
                <div class="portfolio-items portfolio-slider <?php echo esc_attr( $settings['portfolio_layout'] ) ?>" data-arrow="<?php echo esc_attr( $settings['arrow'] ) ?>" data-dots="<?php echo esc_attr( $settings['dots'] ) ?>" data-autoplay="<?php echo esc_attr( $settings['autoplay'] ) ?>" data-autoplayt="<?php echo esc_attr( $settings['autoplay_time'] ) ?>">
                    <?php
                        if ( $settings['portfolio_cats'] ) {
                            $args = array(
                                'post_type'      => 'portfolios',
                                'post_status'    => 'publish',
                                'posts_per_page' => $settings['show_count'],
                                'orderby'        => $settings['order_by'],
                                'order'          => $settings['short_by'],
                                'ignore_sticky_posts' => 1,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'portfolios_cat',
                                        'field'    => 'slug',
                                        'terms'    => $settings['portfolio_cats'],
                                    ),
                                ),
                            );
                        } else {
                            $args = array(
                                'post_type'      => 'portfolios',
                                'post_status'    => 'publish',
                                'posts_per_page' => $settings['show_count'],
                                'orderby'        => $settings['order_by'],
                                'order'          => $settings['short_by'],
                                'ignore_sticky_posts' => 1,
                            );
                        }

                        $wp_query = new WP_Query($args);
                        while ( $wp_query -> have_posts() ) : $wp_query -> the_post();
                            $idd = get_the_ID();

                            $portfolio_categorys = get_the_terms( $idd, 'portfolios_cat' );
                            $item_cat_name = '';

                            if ($portfolio_categorys && ! is_wp_error( $portfolio_categorys) ){
                                $cat_list_name = array();

                                foreach ($portfolio_categorys as $category) {
                                    $cat_list_name[] = $category->name;
                                }

                                $item_cat_name = join( ", ", $cat_list_name );
                            }

                            if ( $settings['title_word'] ) {
                                $the_title = wp_trim_words(get_the_title(), $settings['title_word']);
                            } else {
                                $the_title = get_the_title();
                            }

                            $thumb_url = get_the_post_thumbnail_url( $idd, $settings['portfolio_thumbnail_size'] );
                        ?>

                        <div class="portfolio-item">
                            <div class="portfolio-inner">
                                <div class="portfolio-thumb">
                                    <div class="thumb" <?php if( !empty( $thumb_url ) ) : ?> style="background-image: url(<?php echo esc_url( $thumb_url ) ?>);" <?php endif; ?>></div>
                                </div>
                                <div class="portfolio-desc">
                                    <?php if( !empty( $item_cat_name ) && $settings['show_cat'] ) : ?>
                                        <span class="cat"><?php echo esc_html( $item_cat_name ) ?></span>
                                    <?php endif; ?>

                                    <h5 class="title"><a href="<?php echo esc_url( get_the_permalink() ) ?>"><?php echo esc_html( $the_title ) ?></a></h5>

                                    <?php if( $settings['show_link'] ) : ?>
                                        <a href="<?php echo esc_url( get_the_permalink() ) ?>" class="portfolio-link" tabindex="0">
                                            <i class="fal fa-arrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <?php endwhile;
                        wp_reset_postdata();
                    ?>
                </div>
            </div>
        <?php
    }

    protected function select_param_cates_post() {
        $category = get_terms( 'portfolios_cat' );
        $cat = [];
        foreach ( $category as $item ) {
            if ( $item ) {
                $cat[$item->slug] = $item->name;
            }
        }
        return $cat;
    }
}