<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Progress_Bar extends Widget_Base {

    public function get_name() {
        return 'yankee-progress-bar';
    }

    public function get_title() {
        return esc_html__( 'Progress Bars', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-skill-bar';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'jquery-inview'];
    }

    public function get_keywords() {
        return ['yankee', 'progress', 'bar', 'skill'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Bars', 'yankee-toolkit' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label'       => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'My Skill', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'percent',
            [
                'label'   => __( 'Percentage', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 70,
                    'unit' => '%',
                ],
            ]
        );

        $this->add_control(
            'progress_bars', [
                'label'       => esc_html__( 'Box items', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Progress Bar', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'bar_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .single-progress-bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bar_bg',
            [
                'label'     => esc_html__( 'Bar Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-progress-bar .progress-line-wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'line_bg',
            [
                'label'     => esc_html__( 'Line Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-progress-bar .progress-line-wrap .progress-line, {{WRAPPER}} .single-progress-bar .progress-line-wrap .progressbarV' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-progress-bar .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .single-progress-bar .title',
            ]
        );

        $this->add_control(
            'counter_heading',
            [
                'label' => esc_html__( 'Percentage', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'counter_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-progress-bar .progress-counter' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'counter_typography',
                'selector' => '{{WRAPPER}} .single-progress-bar .progress-counter',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        if ( ! empty( $settings['progress_bars'] ) ) : ?>
           <div class="yankee-progress-bars">
                <?php 
                    foreach ( $settings['progress_bars'] as $index => $progress ) :
                    $percentage = is_numeric( $progress['percent']['size'] ) ? $progress['percent']['size'] : '0';
                    if ( 100 < $percentage ) {
                        $percentage = 100;
                    }
                ?>
                    <div class="single-progress-bar" data-percentage="<?php echo esc_attr( $percentage ) ?>">
                        <div class="progress-top">
                            <?php if ( $progress['title'] ) : ?>
                                <span class="title"><?php echo esc_html( $progress['title'] ) ?></span>
                            <?php endif; if ( $progress['percent'] ) : ?>
                                <span class="progress-counter" data-percent="<?php echo esc_attr( $percentage ) ?>">
                                    <span class="count"> <?php echo esc_html( $percentage ); ?> </span>%
                                </span>
                            <?php endif; ?>
                        </div>
                        <div class="progress-line-wrap">
                            <div class="progress-line"></div>
                            <div class="progressbarV"></div>
                        </div>
                    </div>
                <?php endforeach; ?>
           </div>
        <?php endif;
    }

}