<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use WP_Query;
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Team_Slider extends Widget_Base {

    public function get_name() {
        return 'yankee-team-slider';
    }

    public function get_title() {
        return esc_html__( 'Team Slider', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'fas fa-users';
    }

    public function get_style_depends() {
        return ['yankee-toolkit', 'slick'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'slick'];
    }

    public function get_keywords() {
        return ['yankee', 'team', 'members', 'slider'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Team Members', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'show_count', [
                'label'       => esc_html__( 'Limit Item', 'yankee-toolkit' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => -1,
                'min'         => -1,
                'description' => esc_html__( 'Use -1 for show all project', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'order_by', [
                'label'   => esc_html__( 'Order By', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'none'       => esc_html__( 'None', 'yankee-toolkit' ),
                    'ID'         => esc_html__( 'Post ID', 'yankee-toolkit' ),
                    'author'     => esc_html__( 'Post Author', 'yankee-toolkit' ),
                    'title'      => esc_html__( 'Title', 'yankee-toolkit' ),
                    'date'       => esc_html__( 'Date', 'yankee-toolkit' ),
                    'modified'   => esc_html__( 'Last Modified Date', 'yankee-toolkit' ),
                    'rand'       => esc_html__( 'Random', 'yankee-toolkit' ),
                    'menu_order' => esc_html__( 'Menu Order', 'yankee-toolkit' ),
                ],
                'default' => 'date',
            ]
        );

        $this->add_control(
            'short_by', [
                'label'   => esc_html__( 'Order', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'ASC'  => esc_html__( 'Ascending', 'yankee-toolkit' ),
                    'DESC' => esc_html__( 'Descending', 'yankee-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'team_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'post_thumbnail',
                'default' => 'full',
            ]
        );

        $this->add_control(
            'items_heading',
            [
                'label'     => esc_html__( 'Show Items', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'desktop_item',
            [
                'label'   => esc_html__( 'Desktop', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4' => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'tablet_item',
            [
                'label'   => esc_html__( 'Tablet', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                    '4' => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_item',
            [
                'label'   => esc_html__( 'Mobile', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_sm_item',
            [
                'label'   => esc_html__( 'Mobile(Small)', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( '1 column', 'yankee-toolkit' ),
                    '2' => esc_html__( '2 column', 'yankee-toolkit' ),
                    '3' => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'hr1', [
                'type'    => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'arrow',
            [
                'label'   => esc_html__( 'Arrow?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'dots',
            [
                'label'   => esc_html__( 'Dots?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'   => esc_html__( 'Autoplay?', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true'  => esc_html__( 'Yes', 'yankee-toolkit' ),
                    'false' => esc_html__( 'No', 'yankee-toolkit' ),
                ],
            ]

        );

        $this->add_control(
            'autoplay_time',
            [
                'label'     => esc_html__( 'Autoplay Time', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => '5000',
                'condition' => [
                    'autoplay' => 'true',
                ],
                'options'   => [
                    '1000'  => esc_html__( '1s', 'yankee-toolkit' ),
                    '2000'  => esc_html__( '2s', 'yankee-toolkit' ),
                    '3000'  => esc_html__( '3s', 'yankee-toolkit' ),
                    '4000'  => esc_html__( '4s', 'yankee-toolkit' ),
                    '5000'  => esc_html__( '5s', 'yankee-toolkit' ),
                    '6000'  => esc_html__( '6s', 'yankee-toolkit' ),
                    '7000'  => esc_html__( '7s', 'yankee-toolkit' ),
                    '8000'  => esc_html__( '8s', 'yankee-toolkit' ),
                    '9000'  => esc_html__( '9s', 'yankee-toolkit' ),
                    '10000' => esc_html__( '10s', 'yankee-toolkit' ),
                    '11000' => esc_html__( '11s', 'yankee-toolkit' ),
                    '12000' => esc_html__( '12s', 'yankee-toolkit' ),
                    '13000' => esc_html__( '13s', 'yankee-toolkit' ),
                    '14000' => esc_html__( '14s', 'yankee-toolkit' ),
                    '15000' => esc_html__( '15s', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Team Member', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-team-members .team-member' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-team-members .team-member' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_heading',
            [
                'label'     => esc_html__( 'Content Area', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-team-members .team-member .member-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'content_tabs' );

        $this->start_controls_tab(
            'content_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'content_normal_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member .member-desc' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'content_normal_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-team-members .team-member .member-desc',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'content_normal_shabow',
                'selector' => '{{WRAPPER}} .yankee-team-members .team-member .member-desc',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'content_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'content_hover_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member:hover .member-desc' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'content_hover_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-team-members .team-member:hover .member-desc',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'content_hover_shabow',
                'selector' => '{{WRAPPER}} .yankee-team-members .team-member:hover .member-desc',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'content_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_heading',
            [
                'label' => esc_html__( 'Name', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member .name a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'name_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member:hover .name a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typography',
                'selector' => '{{WRAPPER}} .yankee-team-members .team-member .name',
            ]
        );

        $this->add_control(
            'position_heading',
            [
                'label'     => esc_html__( 'Position', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'position_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member .position' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'position_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member:hover .position' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'position_typography',
                'selector' => '{{WRAPPER}} .yankee-team-members .team-member .position',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'social_links',
            [
                'label' => esc_html__( 'Social Links', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'social_links_height',
            [
                'label'      => esc_html__( 'Social Icon Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-team-members .team-member .social-links a' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'social_links_width',
            [
                'label'      => esc_html__( 'Social Icon Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-team-members .team-member .social-links a' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'social_links_size',
            [
                'label'      => esc_html__( 'Icon size', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-team-members .team-member .social-links a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'social_links_tabs' );

        $this->start_controls_tab(
            'social_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'social_normal_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member .social-links a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_normal_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member .social-links a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'social_normal_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-team-members .team-member .social-links a',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'social_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'social_hover_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member .social-links a:hover::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_hover_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-team-members .team-member .social-links a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'social_hover_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-team-members .team-member .social-links a:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

    ?>
        <div class="yankee-team-members yankee-team-slider row" data-lgitem="<?php echo esc_attr( $settings['desktop_item'] ) ?>" data-mditem="<?php echo esc_attr( $settings['tablet_item'] ) ?>" data-smitem="<?php echo esc_attr( $settings['mobile_item'] ) ?>" data-xsitem="<?php echo esc_attr( $settings['mobile_sm_item'] ) ?>" data-arrow="<?php echo esc_attr( $settings['arrow'] ) ?>" data-dots="<?php echo esc_attr( $settings['dots'] ) ?>" data-autoplay="<?php echo esc_attr( $settings['autoplay'] ) ?>" data-autoplayt="<?php echo esc_attr( $settings['autoplay_time'] ) ?>">
            <?php
                $args = array(
                    'post_type'      => 'team-members',
                    'post_status'    => 'publish',
                    'posts_per_page' => $settings['show_count'],
                    'orderby'        => $settings['order_by'],
                    'order'          => $settings['short_by'],
                    'ignore_sticky_posts' => 1,
                );

                $wp_query = new WP_Query($args);
                while ( $wp_query -> have_posts() ) : $wp_query -> the_post();
                    $idd = get_the_ID();
                ?>
                    <div class="col-lg-4">
                        <div class="team-member">
                            <?php if ( has_post_thumbnail() ) : ?>
                                <div class="member-image">
                                    <?php
                                        echo get_the_post_thumbnail( $idd, $settings['post_thumbnail_size'] )
                                    ?>
                                </div>
                            <?php endif; ?>
                            <div class="member-desc">
                                <?php
                                    if ( class_exists( 'CSF' ) ) {
                                        $position = get_post_meta( $idd, 'yankee_team_metaboxes', true );

                                        if( $position['member_position'] ) {
                                            printf( '<span class="position">%1$s</span>',
                                                esc_html( $position['member_position'] )
                                            );
                                        }
                                    }
                                ?>

                                <h3 class="name"><a href="<?php echo esc_url( get_the_permalink() ) ?>"><?php echo esc_html( get_the_title() ) ?></a></h3>

                                <?php
                                    if ( class_exists( 'CSF' ) ) :
                                        $social_links = get_post_meta( $idd, 'yankee_team_metaboxes', true );

                                        if( !empty( $social_links['member_social_links'] ) ) :
                                            ?>
                                            <ul class="social-links">
                                                <?php foreach ( $social_links['member_social_links'] as $social_link ) : ?>
                                                    <li>
                                                        <a href="<?php echo esc_url( $social_link['link_text'] ) ?>">
                                                            <i class="<?php echo esc_attr( $social_link['link_icon'] ) ?>"></i>
                                                        </a>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php endif;
                                    endif;
                                ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata();
            ?>
        </div>

        <?php
    }
}