<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Tile_Gallery extends Widget_Base {

    public function get_name() {
        return 'yankee-tile-gallery';
    }

    public function get_title() {
        return esc_html__( 'Tile Gallery', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-gallery-masonry';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'gallery', 'tile', 'masonry'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Gallery Images', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'gallery_first_img',
            [
                'label'   => esc_html__( 'First Image', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail_one',
                'default'   => 'full',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );

        $this->add_control(
            'gallery_second_img',
            [
                'label'   => esc_html__( 'Second Image', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail_two',
                'default'   => 'full',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );

        $this->add_control(
            'gallery_third_img',
            [
                'label'   => esc_html__( 'Third Image', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail_three',
                'default'   => 'full',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Gallery Wrap', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'gallery_width',
            [
                'label'      => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'gallery_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__( 'Gallery Images', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_one_style_heading',
            [
                'label' => esc_html__( 'Image One', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'image_one_width',
            [
                'label'      => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery .image-one' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .yankee-tile-gallery::before' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_one_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery .image-one' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'image_one_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-tile-gallery .image-one',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'iamge_one_shadow',
                'selector' => '{{WRAPPER}} .yankee-tile-gallery .image-one',
            ]
        );

        $this->add_control(
            'image_two_style',
            [
                'label'     => esc_html__( 'Image Two', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_two_width',
            [
                'label'      => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery .image-two' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_two_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery .image-two' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'image_two_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-tile-gallery .image-two',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'iamge_two_shadow',
                'selector' => '{{WRAPPER}} .yankee-tile-gallery .image-two',
            ]
        );

        $this->add_control(
            'image_three_style',
            [
                'label'     => esc_html__( 'Image Three', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_three_width',
            [
                'label'      => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery .image-three' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_three_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery .image-three' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'image_three_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-tile-gallery .image-three',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'iamge_three_shadow',
                'selector' => '{{WRAPPER}} .yankee-tile-gallery .image-three',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'image_shape',
            [
                'label' => esc_html__( 'Shapes', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'shape_one_style',
            [
                'label' => esc_html__( 'One', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'shape_one_width',
            [
                'label'      => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery::before' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'shape_one_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery::before' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shape_one_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-tile-gallery::before' => 'Background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'shape_two_style',
            [
                'label' => esc_html__( 'Two', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'shape_two_width',
            [
                'label'      => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery::after' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'shape_two_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-tile-gallery::after' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shape_two_bg',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-tile-gallery::after' => 'Background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();

        $image_one = wp_get_attachment_image_url( $settings['gallery_first_img']['id'], $settings['thumbnail_one_size'] );
        if ( ! $image_one ) {
            $image_one = $settings['gallery_first_img']['url'];
        }
        $image_two = wp_get_attachment_image_url( $settings['gallery_second_img']['id'], $settings['thumbnail_two_size'] );
        if ( ! $image_two ) {
            $image_two = $settings['gallery_second_img']['url'];
        }
        $image_three = wp_get_attachment_image_url( $settings['gallery_third_img']['id'], $settings['thumbnail_three_size'] );
        if ( ! $image_three ) {
            $image_three = $settings['gallery_third_img']['url'];
        }
        

        ?>
            <div class="yankee-tile-gallery">
                <?php if( $image_one ) : ?>
                    <div class="image-one" style="background-image: url(<?php echo esc_url( $image_one )?>);">
                    </div>
                <?php endif; if( $image_two ) : ?>
                    <div class="image-two" style="background-image: url(<?php echo esc_url( $image_two )?>);">
                    </div>
                <?php endif; if( $image_three ) : ?>
                    <div class="image-three" style="background-image: url(<?php echo esc_url( $image_three )?>);">
                    </div>
                <?php endif; ?>
            </div>
        <?php
    }

}