<?php

/**
 * Registering meta boxes
 *
 * Using Meta Box plugin: https://codestarframework.com/
 *
 * @see https://codestarframework.com/documentation/
 *
 */

if ( !defined( 'ABSPATH' ) ) {die;}

// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {

    //
    // Set a unique slug-like ID
    $prefix = 'yankee_user_metaboxes';

    // Create profile options
    CSF::createProfileOptions( $prefix, [
        'data_type' => 'serialize',
    ] );

    CSF::createSection( $prefix, [
        'fields' => [
            [
                'id'       => 'user_social_links',
                'type'     => 'group',
                'title'    => esc_html__( 'Social Links', 'yankee-toolkit' ),
                'subtitle' => esc_html( 'Add user social Icon', 'yankee-toolkit' ),
                'fields'   => [
                    [
                        'id'    => 'social_icon',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Icon', 'yankee-toolkit' ),
                    ],
                    [
                        'id'    => 'social_url',
                        'type'  => 'text',
                        'title' => esc_html__( 'Url', 'yankee-toolkit' ),
                    ],
                ],
            ],
        ],
    ] );

}