<?php

/**
 * Use namespace to avoid conflict
 */
namespace PostType;


/**
 * Class Footer
 * @package PostType
 *
 * Use actual name of post type for
 * easy readability.
 *
 * Potential conflicts removed by namespace
 */
class Footer {

    /**
     * @var string
     * Set post type params
     */
    private $type          = 'footer';
    private $slug          = 'footer';
    private $name          = 'Footers';
    private $singular_name = 'Footer';
    private $icon          = 'dashicons-editor-kitchensink';

    /**
     * Register post type
     */
    public function register() {

        $labels = array(
            'name'                  => esc_html__( 'Footers', 'yankee-toolkit' ),
            'singular_name'         => esc_html__( 'Footer', 'yankee-toolkit' ),
            'add_new'               => esc_html__( 'Add New ', 'yankee-toolkit' ),
            'add_new_item'          => esc_html__( 'Add New ', 'yankee-toolkit' ) . $this->singular_name,
            'edit_item'             => esc_html__( 'Edit ', 'yankee-toolkit' ) . $this->singular_name,
            'new_item'              => esc_html__( 'New ', 'yankee-toolkit' ) . $this->singular_name,
            'all_items'             => esc_html__( 'All ', 'yankee-toolkit' )  . $this->name,
            'view_item'             => esc_html__( 'View ', 'yankee-toolkit' ) . $this->singular_name,
            'view_items'            => esc_html__( 'View ', 'yankee-toolkit' ) . $this->name,
            'search_items'          => esc_html__( 'Search ', 'yankee-toolkit' ) . $this->name,
            'not_found'             => esc_html__( 'No ', 'yankee-toolkit' ) . strtolower($this->name) . esc_html__( ' found', 'yankee-toolkit'),
            'not_found_in_trash'    => esc_html__( 'No ', 'yankee-toolkit' ) . strtolower($this->name) .  esc_html__( ' found in Trash', 'yankee-toolkit'),
            'parent_item_colon'     => '',
            'menu_name'             => $this->name,
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => array( 'slug' => $this->slug ),
            'capability_type'    => 'post',
            'has_archive'        => false,
            'hierarchical'       => true,
            'menu_position'      => 8,
            'supports'           => array( 'title', 'editor' ),
            'yarpp_support'      => true,
            'menu_icon'          => $this->icon,
        );

        register_post_type( $this->type, $args );

    }

    public function __construct() {
        // Register the post type
        add_action( 'init', array( $this, 'register' ) );
    }

}

new Footer();