<?php
/**
 * Widget: Yankee Recent Post
 */

if ( class_exists( 'CSF' ) ) {
    // Recent Post Widget
    CSF::createWidget( 'yankee_recent_post_widget', [
        'title'       => esc_html__( '*Yankee Recent Post', 'yankee-toolkit' ),
        'classname'   => 'yankee-recent-post',
        'description' => esc_html__( 'Show Latest post', 'yankee-toolkit' ),
        'fields'      => [
            [
                'id'      => 'title',
                'type'    => 'text',
                'title'   => esc_html( 'Title', 'yankee-toolkit' ),
                'default' => esc_html__( 'Our Services', 'yankee-toolkit' ),
            ],
            [
                'id'      => 'post_count',
                'type'    => 'number',
                'title'   => esc_html( 'Number of Posts to Show', 'yankee-toolkit' ),
                'default' => '3',
            ],
            [
                'id'      => 'title_length',
                'type'    => 'number',
                'title'   => esc_html( 'Title Length', 'yankee-toolkit' ),
                'default' => '5',
            ],
            [
                'id'      => 'show_date',
                'type'    => 'switcher',
                'title'   => esc_html( 'Show Date?', 'yankee-toolkit' ),
                'default' => true,
            ],
        ],
    ] );

    // Front-end display of widget example 1
    if ( !function_exists( 'yankee_recent_post_widget' ) ) {
        function yankee_recent_post_widget( $args, $instance ) {

            $post_count = ( !empty( $instance['post_count'] ) ) ? absint( $instance['post_count'] ) : 3;
		    $title_length = isset( $instance['title_length'] ) ? absint( $instance['title_length'] ) : 5;

            $query = new WP_Query( apply_filters( 'widget_posts_args', array(
                'posts_per_page'      => $post_count,
                'no_found_rows'       => true,
                'post_status'         => 'publish',
                'ignore_sticky_posts' => true,
            ), $instance ) );

            if ( !$query->have_posts() ) {
                return;
            }

            $allowed_html = array(
                'div' => array(
                    'id' => array(),
                    'class' => array(),
                ),
                'h3' => array(
                    'class' => array(),
                ),
                'h4' => array(
                    'class' => array(),
                ),
                'h5' => array(
                    'class' => array(),
                ),
                'h6' => array(
                    'class' => array(),
                ),
            );

            echo wp_kses($args['before_widget'], $allowed_html);

            if ( !empty( $instance['title'] ) ) {
                echo wp_kses($args['before_title'], $allowed_html) . apply_filters( 'widget_title', $instance['title'] ) . wp_kses($args['after_title'], $allowed_html);
            } ?>

            <ul class="recent-post-loop">
                <?php while ( $query->have_posts() ): $query->the_post();
                    if ( $title_length ) {
                        $post_title = wp_trim_words(get_the_title(), $title_length );
                    } else {
                        $post_title = get_the_title();
                    }
                ?>
                <li>
                    <?php if( has_post_thumbnail() ) : ?>
                        <div class="post-thumb" style="background-image: url(<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'thumbnail' ) ) ?>);"> </div>
                    <?php endif; ?>
                    <div class="desc">
                        <h6>
                            <a href="<?php echo esc_url( get_the_permalink() ) ?>">
                                <?php echo esc_html( $post_title ) ?>
                            </a>
                        </h6>
                        <?php if( $instance['show_date'] ) : ?>
                            <span class="time"><i class="far fa-calendar-alt"></i>24th March 2019</span>
                        <?php endif; ?>
                    </div>
                </li>
                <?php endwhile; wp_reset_postdata(); ?>
            </ul>

            <?php echo wp_kses($args['after_widget'], $allowed_html);
        }
    }

}