<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Experience_Tags extends Widget_Base {

    public function get_name() {
        return 'yankee-experience-tag';
    }

    public function get_title() {
        return esc_html__( 'Experience Tags', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_script_depends() {
        return ['yankee-toolkit', 'jquery-inview'];
    }

    public function get_keywords() {
        return ['yankee', 'experience', 'image', 'tags'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Content', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'experience_style',
            [
                'label'   => esc_html__( 'Widget Style', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-one',
                'options' => [
                    'style-one'   => esc_html__( 'Style One', 'yankee-toolkit' ),
                    'style-two'   => esc_html__( 'Style Two', 'yankee-toolkit' ),
                    'style-three' => esc_html__( 'Style Three', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'tag_position',
            [
                'label'     => esc_html__( 'Tag Position', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'tag-right',
                'options'   => [
                    'tag-top'    => esc_html__( 'Top', 'yankee-toolkit' ),
                    'tag-left'   => esc_html__( 'Left', 'yankee-toolkit' ),
                    'tag-right'  => esc_html__( 'Right', 'yankee-toolkit' ),
                    'tag-bottom' => esc_html__( 'Bottom', 'yankee-toolkit' ),
                ],
                'condition' => [
                    'experience_style' => 'style-one',
                ],
            ]
        );

        $this->add_control(
            'experience_year', [
                'label'       => esc_html__( 'Experience Year', 'yankee-toolkit' ),
                'type'        => Controls_Manager::NUMBER,
                'label_block' => false,
                'default'     => '25',
            ]
        );

        $this->add_control(
            'experience_text', [
                'label'       => esc_html__( 'Experience Text', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => false,
                'default'     => esc_html( 'YEARS EXPERIENCE' ),
            ]
        );

        $this->add_control(
            'experience_image',
            [
                'label'   => esc_html__( 'Experience Image', 'yankee-toolkit' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail',
                'default'   => 'full',
                'separator' => 'before',
                'exclude'   => [
                    'custom',
                ],
            ]
        );

        $this->add_responsive_control(
            'experience_image_align',
            [
                'label'     => esc_html__( 'Alignment', 'yankee-toolkit' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .experience-tag-wrap .experience-img' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Experience Wrapper', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .experience-tag-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .experience-tag-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'square_bg_color',
            [
                'label'     => esc_html__( 'Square Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .experience-tag-wrap.style-three::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'experience_style' => 'style-three',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tag_box_style',
            [
                'label' => esc_html__( 'Experience Tag Box', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'tag_box_height',
            [
                'label'      => esc_html__( 'Height', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .experience-tag-wrap .experience-tag' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tag_box_width',
            [
                'label'      => esc_html__( 'Width', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .experience-tag-wrap .experience-tag' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tag_box_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .experience-tag-wrap .experience-tag' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tag_box_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .experience-tag-wrap .experience-tag' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'tag_box_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .experience-tag-wrap .experience-tag',
            ]
        );

        $this->add_control(
            'tag_box_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .experience-tag-wrap .experience-tag' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tag_box_border_shadow',
                'selector' => '{{WRAPPER}} .experience-tag-wrap .experience-tag',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tag_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'year_heading',
            [
                'label' => esc_html__( 'Experience Year', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'year_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .experience-tag-wrap .experience-tag .year, .experience-tag-wrap .experience-tag .year::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'year_typography',
                'selector' => '{{WRAPPER}} .experience-tag-wrap .experience-tag .year',
            ]
        );

        $this->add_control(
            'text_heading',
            [
                'label' => esc_html__( 'Experience Text', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .experience-tag-wrap .experience-tag' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'text_typography',
                'selector' => '{{WRAPPER}} .experience-tag-wrap .experience-tag',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();

        $allowed_tags = [
            'br' => [],
        ];

        ?>
            <div class="experience-tag-wrap <?php echo esc_attr( esc_attr( $settings['experience_style'] ) ) ?>">
                <?php if ( $settings['experience_image']['id'] ): ?>
                    <div class="experience-img">
                        <?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'experience_image' ); ?>
                    </div>
                <?php endif;?>

                <div class="experience-tag <?php echo esc_attr( $settings['tag_position'] ) ?>">
                    <div>
                        <?php
                            if ( $settings['experience_year'] ) {
                                printf( '<span class="year">%1$s</span>',
                                    esc_html( $settings['experience_year'] )
                                );
                            }
                            if ( $settings['experience_text'] ) {
                                echo wp_kses($settings['experience_text'], $allowed_tags);
                            }
                        ?>
                    </div>
                </div>
            </div>
        <?php
    }

}