<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Feature_Box_Two extends Widget_Base {

    public function get_name() {
        return 'yankee-feature-box-two';
    }

    public function get_title() {
        return esc_html__( 'Feature Boxes Two', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'icon', 'iconic', 'box', 'feature'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Items', 'yankee-toolkit' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label'       => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Security & Location', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'title_tag',
            [
                'label'       => esc_html__( 'Title HTML Tag', 'yankee-toolkit' ),
                'type'        => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options'     => [
                    'h2' => [
                        'title' => __( 'H2', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'yankee-toolkit' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'     => 'h4',
                'toggle'      => false,
            ]
        );

        $repeater->add_control(
            'desc', [
                'label'       => esc_html__( 'Description', 'yankee-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => esc_html__( 'Lorem ipsum dolor sit ame t, consectetur adipisicing el it, sed do eiusm od tem.', 'yankee-toolkit' ),
            ]
        );

        $repeater->add_control(
            'icon_type',
            [
                'label'     => esc_html__( 'Icon Type', 'yankee-toolkit' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'font',
                'options'   => [
                    'font'  => esc_html__( 'Font Icon', 'yankee-toolkit' ),
                    'image' => esc_html__( 'Image Icon', 'yankee-toolkit' ),
                ],
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'font_icon',
            [
                'label'            => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'far fa-smile-wink',
                    'library' => 'fa-regular',
                ],
                'condition'        => [
                    'icon_type' => 'font',
                ],
            ]
        );

        $repeater->add_control(
            'image_icon',
            [
                'label'     => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $repeater->add_control(
            'box_url_heading',
            [
                'label'     => esc_html__( 'URL', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'box_url',
            [
                'label'      => esc_html__( 'Url', 'yankee-toolkit' ),
                'type'       => Controls_Manager::URL,
                'show_label' => false,
                'default'    => [
                    'url' => '#',
                ],
            ]
        );

        $repeater->add_control(
            'link_icon',
            [
                'label'            => esc_html__( 'Icon', 'yankee-toolkit' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-arrow-right',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'use_title_link',
            [
                'label'        => esc_html__( 'Use title as link?', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'No', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $this->add_control(
            'feature_boxes', [
                'label'       => esc_html__( 'Box items', 'yankee-toolkit' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'column_heading',
            [
                'label'     => esc_html__( 'Column', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'desktop_col',
            [
                'label'   => esc_html__( 'Desktop', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-lg-3',
                'options' => [
                    'col-lg-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-lg-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-lg-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-lg-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'tablet_col',
            [
                'label'   => esc_html__( 'Tablet', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-md-6',
                'options' => [
                    'col-md-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-md-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-md-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-md-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_col',
            [
                'label'   => esc_html__( 'Mobile', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-sm-6',
                'options' => [
                    'col-sm-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-sm-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-sm-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_sm_col',
            [
                'label'   => esc_html__( 'Mobile(Small)', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-12',
                'options' => [
                    'col-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Feature box', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_align',
            [
                'label'   => esc_html__( 'Text Align', 'yankee-toolkit' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'text-left'   => [
                        'title' => esc_html__( 'Left', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'text-center' => [
                        'title' => esc_html__( 'Center', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'text-right'  => [
                        'title' => esc_html__( 'Right', 'yankee-toolkit' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],

                'default' => 'text-left',
            ]
        );

        $this->add_responsive_control(
            'margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'box_tabs' );

        $this->start_controls_tab(
            'box_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'bg_color',
            [
                'label'     => esc_html__( 'Background Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_normal_shadow',
                'label'    => esc_html__( 'Box Shadow', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-feature-boxes-two .feature-box',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'box_normal_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-feature-boxes-two .feature-box',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'box_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'bg_hover_color',
            [
                'label'     => esc_html__( 'Background Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_hover_shadow',
                'label'    => esc_html__( 'Box Shadow', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-feature-boxes-two .feature-box:hover',
            ]
        );

        $this->add_control(
            'border_hover_color',
            [
                'label'     => esc_html__( 'Border Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'icon_style_setting',
            [
                'label' => esc_html__( 'Icon', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label'      => esc_html__( 'Size', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .icon'     => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .icon img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__( 'Content', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__( 'Title', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .title, {{WRAPPER}} .yankee-feature-boxes-two .feature-box .title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .title:hover, {{WRAPPER}} .yankee-feature-boxes-two .feature-box .title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .title',
            ]
        );

        $this->add_responsive_control(
            'title_bottom_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'dec_heading',
            [
                'label'     => esc_html__( 'Description', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'desc_typography',
                'selector' => '{{WRAPPER}} .yankee-feature-boxes-two .feature-box p',
            ]
        );

        $this->add_control(
            'url_heading',
            [
                'label'     => esc_html__( 'Url', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'url_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .feature-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'url_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-feature-boxes-two .feature-box .feature-link:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings();
        $column = $settings['desktop_col'] .' '. $settings['tablet_col'] .' '. $settings['mobile_col'] .' '. $settings['mobile_sm_col'];

        if ( ! empty( $settings['feature_boxes'] ) ) : ?>
            <div class="yankee-feature-boxes-two row">
                <?php foreach ( $settings['feature_boxes'] as $index => $box ) : ?>
                    <div class="<?php echo esc_attr( $column ) ?>">
                        <div class="feature-box <?php echo esc_attr( $settings['text_align'] ) ?>">
                            <div class="icon">
                                <?php if( $box['icon_type'] == 'font' ) : ?>
                                    <i class="<?php echo esc_attr( $box['font_icon']['value'] ); ?>"></i>
                                <?php endif; if( $box['icon_type'] == 'image' ) : ?>
                                    <img src="<?php echo esc_attr( $box['image_icon']['url'] ); ?>" alt="<?php echo esc_attr( $box['title'] ); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="desc">
                                <?php
                                    $target = $box['box_url']['is_external'] ? ' target="_blank"' : '';
                                    $nofollow = $box['box_url']['nofollow'] ? ' rel="nofollow"' : '';

                                    if( $box['title'] ) {
                                        if ( $box['box_url']['url'] && $box['use_title_link'] == 'yes' ) {
                                            printf( '<%1$s class="title"><a href="%2$s" %3$s %4$s>%5$s</a></%1$s>',
                                                tag_escape( $box['title_tag'] ),
                                                esc_url( $box['box_url']['url'] ),
                                                $target,
                                                $nofollow,
                                                esc_html( $box['title'] )
                                            );
                                        } else {
                                            printf( '<%1$s class="title">%2$s</%1$s>',
                                                tag_escape( $box['title_tag'] ),
                                                esc_html( $box['title'] )
                                            );
                                        }
                                    }

                                    if( $box['desc'] ) {
                                        echo wpautop( esc_html( $box['desc'] ) );
                                    }

                                    if ( $box['box_url']['url'] ) {
                                        printf( '<a href="%1$s" class="feature-link" %2$s %3$s><i class="%4$s"></i></a>',
                                            esc_url( $box['box_url']['url'] ),
                                            $target,
                                            $nofollow,
                                            esc_attr( $box['link_icon']['value'] )
                                        );
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif;
    }
}