<?php

namespace YankeeToolkit\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use WP_Query;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Yankee_Post_Grid extends Widget_Base {

    public function get_name() {
        return 'yankee-post-grid';
    }

    public function get_title() {
        return esc_html__( 'Post Grid', 'yankee-toolkit' );
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_style_depends() {
        return ['yankee-toolkit'];
    }

    public function get_keywords() {
        return ['yankee', 'post', 'recent'];
    }

    public function get_categories() {
        return ['yankee_element'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'widget_content',
            [
                'label' => esc_html__( 'Post Grid', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'post_cat',
            [
                'label'       => esc_html__( 'Select Categories', 'yankee-toolkit' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->select_param_cates_post(),
                'multiple'    => true,
                'label_block' => true,
                'placeholder' => esc_html__( 'All Categories', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'show_count', [
                'label'       => esc_html__( 'Limit Item', 'yankee-toolkit' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 3,
                'min'         => -1,
                'description' => esc_html__( 'Use -1 for show all project', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'order_by', [
                'label'   => esc_html__( 'Order By', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'none'       => esc_html__( 'None', 'yankee-toolkit' ),
                    'ID'         => esc_html__( 'Post ID', 'yankee-toolkit' ),
                    'author'     => esc_html__( 'Post Author', 'yankee-toolkit' ),
                    'title'      => esc_html__( 'Title', 'yankee-toolkit' ),
                    'date'       => esc_html__( 'Date', 'yankee-toolkit' ),
                    'modified'   => esc_html__( 'Last Modified Date', 'yankee-toolkit' ),
                    'rand'       => esc_html__( 'Random', 'yankee-toolkit' ),
                    'menu_order' => esc_html__( 'Menu Order', 'yankee-toolkit' ),
                ],
                'default' => 'date',
            ]
        );

        $this->add_control(
            'short_by', [
                'label'   => esc_html__( 'Order', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'ASC'  => esc_html__( 'Ascending', 'yankee-toolkit' ),
                    'DESC' => esc_html__( 'Descending', 'yankee-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'team_settings',
            [
                'label' => esc_html__( 'Settings', 'yankee-toolkit' ),
            ]
        );

        $this->add_control(
            'show_thumb',
            [
                'label'        => esc_html__( 'Show Thumbnail?', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'Hide', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'post_thumbnail',
                'default' => 'full',
                'condition' => [
                    'show_thumb' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label'        => esc_html__( 'Show Exerpt?', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'Hide', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'content_word',
            [
                'label'   => esc_html__( 'Excerpt Length', 'yankee-toolkit' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 20,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_word',
            [
                'label'   => esc_html__( 'Title Length', 'yankee-toolkit' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 8,
            ]
        );

        $this->add_control(
            'show_link',
            [
                'label'        => esc_html__( 'Show Post Button?', 'yankee-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'yankee-toolkit' ),
                'label_off'    => esc_html__( 'Hide', 'yankee-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $this->add_control(
            'link_text',
            [
                'label'        => esc_html__( 'Button Text', 'yankee-toolkit' ),
                'type'         => Controls_Manager::TEXT,
                'default'      => esc_html__( 'Read More', 'yankee-toolkit' ),
                'condition' => [
                    'show_link' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'column_heading',
            [
                'label'     => esc_html__( 'Column', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'desktop_col',
            [
                'label'   => esc_html__( 'Desktop', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-lg-4',
                'options' => [
                    'col-lg-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-lg-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-lg-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-lg-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'tablet_col',
            [
                'label'   => esc_html__( 'Tablet', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-md-6',
                'options' => [
                    'col-md-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-md-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-md-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                    'col-md-3'  => esc_html__( '4 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_col',
            [
                'label'   => esc_html__( 'Mobile', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-sm-6',
                'options' => [
                    'col-sm-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-sm-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-sm-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'mobile_sm_col',
            [
                'label'   => esc_html__( 'Mobile(Small)', 'yankee-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-12',
                'options' => [
                    'col-12' => esc_html__( '1 column', 'yankee-toolkit' ),
                    'col-6'  => esc_html__( '2 column', 'yankee-toolkit' ),
                    'col-4'  => esc_html__( '3 column', 'yankee-toolkit' ),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_style',
            [
                'label' => esc_html__( 'Post Box', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_heading',
            [
                'label'     => esc_html__( 'Content Area', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => esc_html__( 'Padding', 'yankee-toolkit' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'content_tabs' );

        $this->start_controls_tab(
            'content_normal_tab',
            ['label' => esc_html__( 'Normal', 'yankee-toolkit' )]
        );

        $this->add_control(
            'content_normal_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-desc' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'content_normal_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-desc',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'content_normal_shabow',
                'selector' => '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-desc',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'content_hover_tab',
            ['label' => esc_html__( 'Hover', 'yankee-toolkit' )]
        );

        $this->add_control(
            'content_hover_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box:hover .post-desc' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'content_hover_border',
                'label'    => esc_html__( 'Border', 'yankee-toolkit' ),
                'selector' => '{{WRAPPER}} .yankee-recent-post .recent-post-box:hover .post-desc',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'content_hover_shabow',
                'selector' => '{{WRAPPER}} .yankee-recent-post .recent-post-box:hover .post-desc',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'content_color_typography',
            [
                'label' => esc_html__( 'Color & Typography', 'yankee-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__( 'Name', 'yankee-toolkit' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .yankee-recent-post .recent-post-box .title',
            ]
        );

        $this->add_responsive_control(
            'title_gap',
            [
                'label'      => esc_html__( 'Bottom Gap', 'yankee-toolkit' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'date_heading',
            [
                'label'     => esc_html__( 'Post Date', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'date_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'date_bg_color',
            [
                'label'     => esc_html__( 'Background', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-date' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'date_typography',
                'selector' => '{{WRAPPER}} yankee-recent-post .recent-post-box .post-date',
            ]
        );

        $this->add_control(
            'desc_heading',
            [
                'label'     => esc_html__( 'Content', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'desc_typography',
                'selector' => '{{WRAPPER}} .yankee-recent-post .recent-post-box p',
            ]
        );

        $this->add_control(
            'button_heading',
            [
                'label'     => esc_html__( 'Post Button', 'yankee-toolkit' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label'     => esc_html__( 'Color(Hover)', 'yankee-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-link:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'button_typography',
                'selector' => '{{WRAPPER}} .yankee-recent-post .recent-post-box .post-link',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();
    ?>
        <div class="yankee-recent-post row">
            <?php
                if( $settings['post_cat'] ) {
                    $args = array(
                        'post_type'      => 'post',
                        'post_status'    => 'publish',
                        'posts_per_page' => $settings['show_count'],
                        'orderby'        => $settings['order_by'],
                        'order'          => $settings['short_by'],
                        'ignore_sticky_posts' => 1,
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'category',
                                'field'    => 'slug',
                                'terms'    => $settings['post_cat'],
                            ),
                        ),
                    );
                } else {
                    $args = array(
                        'post_type'      => 'post',
                        'post_status'    => 'publish',
                        'posts_per_page' => $settings['show_count'],
                        'orderby'        => $settings['order_by'],
                        'order'          => $settings['short_by'],
                        'ignore_sticky_posts' => 1,
                    );
                }

                $wp_query = new WP_Query($args);
                while ( $wp_query -> have_posts() ) : $wp_query -> the_post();
                    $idd = get_the_ID();
                    $column = $settings['desktop_col'] .' '. $settings['tablet_col'] .' '. $settings['mobile_col'] .' '. $settings['mobile_sm_col'];

                    if ( $settings['content_word'] ) {
                        $the_content = wp_trim_words(get_the_content(), $settings['content_word']);
                    } else {
                        $the_content = get_the_excerpt();
                    }

                    if ( $settings['title_word'] ) {
                        $the_title = wp_trim_words(get_the_title(), $settings['title_word']);
                    } else {
                        $the_title = get_the_title();
                    }
                ?>
                    <div class="<?php echo esc_attr( $column ) ?>">
                        <div class="recent-post-box">
                            <?php if( $settings['show_thumb'] == 'yes' ) : ?>
                                <div class="post-image">
                                    <?php
                                        echo get_the_post_thumbnail( $idd, $settings['post_thumbnail_size'] );

                                        printf( '<span class="post-date">%1$s</span>',
                                            get_the_date('d M Y')
                                        );

                                    ?>
                                </div>
                            <?php endif; ?>
                            <div class="post-desc">
                                <h3 class="title"><a href="<?php echo esc_url( get_the_permalink() ) ?>"><?php echo wp_kses_post( $the_title ) ?></a></h3>
                                <?php if( $settings['show_excerpt'] == 'yes' ) : ?>
                                    <p><?php echo wp_kses_post( $the_content ) ?></p>
                                <?php endif; ?>

                                <?php
                                    if ( $settings['show_link'] == 'yes') {
                                        printf( '<a href="%1$s" class="post-link">%2$s</a>',
                                            get_the_permalink(),
                                            esc_html( $settings['link_text'] )
                                        );
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata();
            ?>
        </div>

        <?php
    }

    protected function select_param_cates_post() {
        $category = get_terms( 'category' );
        $cat = [];
        foreach ( $category as $item ) {
            if ( $item ) {
                $cat[$item->slug] = $item->name;
            }
        }
        return $cat;
    }
}