<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package yankee
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}
?>

<div id="comments" class="comments-area clearfix">

	<?php
		// You can start editing here -- including this comment!
		if ( have_comments() ): ?>

			<h3 class="comments-title">
				<?php comments_number( esc_html__( '0 Comments', 'yankee' ), esc_html__( '1 Comments', 'yankee' ), esc_html__( '% Comments', 'yankee' ) );?>
			</h3>


			<!-- Comment List -->
			<ul class="comment-list">
				<?php wp_list_comments( 'callback=yankee_comments_list' );?>
			</ul>

			<?php 
				the_comments_navigation();

				// If comments are closed and there are comments, let's leave a little note, shall we?
				if ( !comments_open() ): ?>

					<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'yankee' );?></p>

			<?php endif;
			
		endif; // Check for have_comments().

		/**
		 * Custom comments_args
		 * @link https://codex.wordpress.org/Function_Reference/comment_form
		 */
		$commenter = wp_get_current_commenter();

		$comments_args = [
			'title_reply'   => esc_html__( 'Post Comment', 'yankee' ),
			'fields'        => apply_filters( 'comment_form_default_fields', [

				'author' => '<p class="comment-form-author"><input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" placeholder="' . esc_attr__( 'Your Name...', 'yankee' ) . '" required /><span class="icon"><i class="far fa-user"></i></span></p>',

				'email'  => '<p class="comment-form-email"><input id="email" name="email" type="text" value="' . esc_attr( $commenter['comment_author_email'] ) . '" placeholder="' . esc_attr__( 'Your Email...', 'yankee' ) . '" required /><span class="icon"><i class="far fa-envelope"></i></span></p>',

			] ),
			'comment_field' => '<p class="comment-form-comment"><textarea id="comment" name="comment" aria-required="true" placeholder="' . esc_attr__( 'Write Comment...', 'yankee' ) . '" required></textarea><span class="icon"><i class="far fa-pencil"></i></span></p>',

			'class_submit'  => 'submit-btn',
			'format'        => 'xhtml',
		];
		comment_form( $comments_args );
	?>

</div>
