<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package yankee
 */

$footer = yankee_site_footer();
if ( !empty( $footer ) ) {
    $footer_query = new WP_Query( [
        'post_type'      => 'footer',
        'posts_per_page' => -1,
        'p'              => $footer,
    ] );
}

?>
	</main>
	<!--====== Site Content End ======-->
	<!--====== Footer Start ======-->
	<footer id="site-foorer" class="site-footer">
		<?php
			if ( is_404() ) { ?>
				<div class="footer-copyright">
					<div class="container">
						<div class="row align-items-center justify-content-between">
							<div class="col-md-6 col-12">
								<div class="footer-logo text-center text-md-left">
									<?php if ( !empty( yankee_get_option( 'footer-logo' )['url'] ) ): ?>
										<a href="<?php echo esc_url( home_url() ) ?>">
											<img src="<?php echo esc_url( yankee_get_option( 'footer-logo' )['url'] ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
										</a>
									<?php else: ?>
										<a href="<?php echo esc_url( home_url() ) ?>">
											<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/yankee.png' ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
										</a>
									<?php endif;?>
								</div>
							</div>
							<div class="col-md-6 col-12">
								<div class="copyright text-center text-md-right">
									<?php
										if( !empty( yankee_get_option( 'footer-copyright-text' ) ) ) {
											echo wpautop( esc_html( yankee_get_option( 'footer-copyright-text' ) ) );
										} else {
											echo wpautop( esc_html_e( 'Copyright ©2021. All Rights Reserved', 'yankee' ) );
										}
									?>
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php } elseif ( !empty( $footer ) ) {
				if ( $footer_query->have_posts() ) {
					while ( $footer_query->have_posts() ) : $footer_query->the_post();
						the_content();
					endwhile;
					wp_reset_postdata();
				}

			} elseif ( is_active_sidebar( 'footer_widget' ) ) { ?>
				<div class="footer-widgets">
					<div class="container">
						<div class="row">
							<?php dynamic_sidebar( 'footer_widget' ); ?>
						</div>
					</div>
				</div>
				<div class="footer-copyright">
					<div class="container">
						<div class="row align-items-center justify-content-between">
							<div class="col-md-6 col-12">
								<div class="footer-logo text-center text-md-left">
									<?php if ( !empty( yankee_get_option( 'footer-logo' )['url'] ) ): ?>
										<a href="<?php echo esc_url( home_url() ) ?>">
											<img src="<?php echo esc_url( yankee_get_option( 'footer-logo' )['url'] ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
										</a>
									<?php else: ?>
										<a href="<?php echo esc_url( home_url() ) ?>">
											<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/yankee.png' ) ?>" alt="<?php echo esc_html( bloginfo( 'name' ) ) ?>">
										</a>
									<?php endif;?>
								</div>
							</div>
							<div class="col-md-6 col-12">
								<div class="copyright text-center text-md-right">
									<?php
										if( !empty( yankee_get_option( 'footer-copyright-text' ) ) ) {
											echo wpautop( esc_html( yankee_get_option( 'footer-copyright-text' ) ) );
										} else {
											echo wpautop( esc_html_e( 'Copyright ©2021. All Rights Reserved', 'yankee' ) );
										}
									?>
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php }
		?>
	</footer>
	<!--====== Footer End ======-->
</div>

<?php wp_footer();?>

</body>
</html>
