<?php
/**
 * yankee functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package yankee
 */

/**
 * Specific functions only for this theme
 */
if ( !function_exists( 'yankee_setup' ) ) {

    function yankee_setup() {

        // Make theme available for translation
        load_theme_textdomain( 'yankee', get_template_directory() . '/languages' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        // Let WordPress manage the document title.
        add_theme_support( 'title-tag' );

        // Enable support for Post Thumbnails on posts and pages.
        add_theme_support( 'post-thumbnails' );

        // HTML 5 support
        add_theme_support(
            'html5',
            [
                'search-form',
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
                'style',
                'script',
            ]
        );

        // Enable support for Post Formats.
        add_theme_support( 'post-formats', [
            'video',
            'quote',
            'gallery',
            'audio',
            'link',
        ] );

        // Add Custom Image Size For Blog Post
        add_image_size( 'yankee-post-thumbnail', 790, 460, true );
        add_image_size( 'yankee-500x500', 500, 500 );

        // Editor Style
        add_theme_support( 'editor-styles' );
        add_editor_style( 'style-editor.css' );
    }
    add_action( 'after_setup_theme', 'yankee_setup' );
}

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * @global int $content_width
 */
function yankee_content_width() {
    $GLOBALS['content_width'] = apply_filters( 'yankee_content_width', 780 );
}
add_action( 'after_setup_theme', 'yankee_content_width', 0 );

/**
 * Register Nav Menus
 *
 * @link https://developer.wordpress.org/reference/functions/register_nav_menus/
 */
function yankee_register_menus() {
    register_nav_menus( [
        'primary_menu' => esc_html__( 'Primary Menu', 'yankee' ),
        'mobile_menu'  => esc_html__( 'Mobile Menu', 'yankee' ),
    ] );
}
add_action( 'init', 'yankee_register_menus' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function yankee_widgets_init() {
    register_sidebar(
        [
            'name'          => esc_html__( 'Primary Sidebar', 'yankee' ),
            'id'            => 'primary_sidebar',
            'description'   => esc_html__( 'Add widgets here.', 'yankee' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h5 class="widget-title">',
            'after_title'   => '</h5>',
        ]
    );

    register_sidebar(
        [
            'name'          => esc_html__( 'Portfolio Sidebar', 'yankee' ),
            'id'            => 'portfolio_sidebar',
            'description'   => esc_html__( 'Add Portfolio sidebar widgets here.', 'yankee' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h5 class="widget-title">',
            'after_title'   => '</h5>',
        ]
    );

    register_sidebar(
        [
            'name'          => esc_html__( 'Service Sidebar', 'yankee' ),
            'id'            => 'service_sidebar',
            'description'   => esc_html__( 'Add Service sidebar widgets here.', 'yankee' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h5 class="widget-title">',
            'after_title'   => '</h5>',
        ]
    );

    register_sidebar(
        [
            'name'          => esc_html__( 'Footer Widget', 'yankee' ),
            'id'            => 'footer_widget',
            'description'   => esc_html__( 'Add OffCanvas menu widgets here.', 'yankee' ),
            'before_widget' => '<div class="col-lg-3 col-md-6"><div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div></div>',
            'before_title'  => '<h5 class="widget-title">',
            'after_title'   => '</h5>',
        ]
    );
}

add_action( 'widgets_init', 'yankee_widgets_init' );

/**
 * Google Fonts Url
 */
function yankee_google_font_url() {
    $fonts_url = '';
    $font_families = [];
    $subsets = 'latin';

    /* translators: If there are characters in your language that are not supported by Red Hat Text, translate this to 'off'. Do not translate into your own language. */
    if ( 'off' !== _x( 'on', 'Open Sans', 'yankee' ) ) {
        $font_families[] = 'Open Sans:400,400i,500,500i,600,600i,700,700i';
    }

    if ( 'off' !== _x( 'on', 'Rajdhani', 'yankee' ) ) {
        $font_families[] = 'Rajdhani:400,400i,500,500i,600,600i,700,700i';
    }

    if ( $font_families ) {
        $fonts_url = add_query_arg( [
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( $subsets ),
        ], 'https://fonts.googleapis.com/css' );
    }
    return esc_url_raw( $fonts_url );
}

/**
 * Enqueue scripts and styles.
 */
function yankee_scripts() {

    wp_enqueue_style( 'yankee-fonts', yankee_google_font_url(), [], null );

    wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.min.css', '1.0', 'all' );
    wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css', '5.8', 'all' );
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', '4.5', 'all' );
    wp_enqueue_style( 'slick', get_template_directory_uri() . '/assets/css/slick.min.css', '1.8.1', 'all' );
    wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup.min.css', '1.1', 'all' );
    wp_enqueue_style( 'theme-style', get_template_directory_uri() . '/assets/css/theme.min.css', '1.2', 'all' );
    wp_enqueue_style( 'yankee-style', get_stylesheet_uri(), [] );

    wp_enqueue_script( 'popper', get_template_directory_uri() . '/assets/js/popper.min.js', [ 'jquery' ], '1.16.1', true );
    wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', [ 'jquery' ], '4.5', true );
    wp_enqueue_script( 'slick', get_template_directory_uri() . '/assets/js/slick.min.js', [ 'jquery' ], '1.8.1', true );
    wp_enqueue_script( 'magnific-popup', get_template_directory_uri() . '/assets/js/magnific-popup.min.js', [ 'jquery' ], '1.1', true );
    wp_enqueue_script( 'theme-scripts', get_template_directory_uri() . '/assets/js/theme.min.js', [ 'jquery' ], '1.2', true );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'yankee_scripts' );

/**
 * Load Font in Gutenberg
 */
add_action( 'enqueue_block_assets', function() {
    wp_enqueue_style( 'cantus-editor-fonts', yankee_google_font_url(), array(), null );
});

/**
 * Elementor post type support
 */
function yankee_cpt_add_cpt_support() {

    //if exists, assign to $cpt_support var
    $cpt_support = get_option( 'elementor_cpt_support' );

    //check if option DOESN'T exist in db
    if ( !$cpt_support ) {
        $cpt_support = ['page', 'post', 'footer'];
        update_option( 'elementor_cpt_support', $cpt_support );
    }

    //if it DOES exist, but footer is NOT defined
    elseif ( !in_array( 'footer', $cpt_support ) ) {
        $cpt_support[] = 'footer';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

}
add_action( 'after_switch_theme', 'yankee_cpt_add_cpt_support' );

/**
 * Required Plugin
 */
require get_template_directory() . '/inc/lib/class-tgm-plugin-activation.php';
require get_template_directory() . '/inc/lib/required-plugin.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Page header
 */
require get_template_directory() . '/inc/page-haeder.php';

/**
 * Admin Options
 */
require get_template_directory() . '/inc/options.php';

/**
 * One Click Demo Confiq
 */
require get_template_directory() . '/inc/one-click-demo-config.php';