<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package yankee
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">

	<?php if( yankee_get_option('site-preloader') ) : ?>
		<!--====== Preloader ======-->
		<div id="preloader">
			<div class="loader"><span></span></div>
		</div>
	<?php endif; ?>

	<!--====== Header  start ======-->
	<header class="site-header">
		<?php
			if ( 'header-one' == yankee_site_header() ) {
				get_template_part( 'template-parts/header/header-one' );
			} elseif ( 'header-two' == yankee_site_header() ) {
				get_template_part( 'template-parts/header/header-two' );
			} elseif ( 'header-three' == yankee_site_header() ) {
				get_template_part( 'template-parts/header/header-three' );
			} elseif( 'header-four' == yankee_site_header() ) {
				get_template_part( 'template-parts/header/header-four' );
			} else {
				get_template_part( 'template-parts/header/header-one' );
			}
		?>
	</header>
	<!--====== Header end ======-->

	<?php if ( 'header-two' == yankee_site_header() && yankee_get_option( 'skew-shape' ) ) : ?>
		<div class="body-clippy-shape"></div>
	<?php endif; ?>

	<!--====== Site Content Start ======-->
	<main id="content" class="site-main">
		<?php if ( function_exists( 'yankee_page_header' ) ) yankee_page_header(); ?>