<?php
/**
 * Required Plugin for Yankee theme
 *
 * @package yankee
 */

if ( !defined( 'ABSPATH' ) ) {
    exit( 'No direct script access allowed' );
}

add_action( 'tgmpa_register', 'yankee_register_required_plugins' );
function yankee_register_required_plugins() {
    $plugins = [
        [
            'name'     => esc_html__( 'Codestar Framework', 'yankee' ),
            'slug'     => 'codestar-framework',
            'source'   => get_template_directory() . '/inc/plugins/codestar-framework.zip',
            'required' => true,
            'version'  => '2.0.0',
        ],
        [
            'name'     => esc_html__( 'Elementor Website Builder', 'yankee' ),
            'slug'     => 'elementor',
            'required' => true,
        ],
        [
            'name'     => esc_html__( 'Yankee Toolkit', 'yankee' ),
            'slug'     => 'yankee-toolkit',
            'source'   => get_template_directory() . '/inc/plugins/yankee-toolkit.zip',
            'required' => true,
            'version'  => '1.2',
        ],
        [
            'name'     => esc_html__( 'Contact Form 7', 'yankee' ),
            'slug'     => 'contact-form-7',
            'required' => true,
        ],
        [
            'name'     => esc_html__( 'One Click Demo Import', 'yankee' ),
            'slug'     => 'one-click-demo-import',
            'required' => false,
        ],
        [
            'name'     => esc_html__( 'MC4WP: Mailchimp for WordPress', 'yankee' ),
            'slug'     => 'mailchimp-for-wp',
            'required' => false,
        ],
        [
            'name'     => esc_html__( 'Custom Twitter Feeds', 'yankee' ),
            'slug'     => 'custom-twitter-feeds',
            'required' => false,
        ],
        [
            'name'     => esc_html__( 'Smash Balloon Instagram Feed', 'yankee' ),
            'slug'     => 'instagram-feed',
            'required' => false,
        ],
    ];

    $config = [
        'id'           => 'yankee',
        'default_path' => '',
        'menu'         => 'yankee-required-plugins',
        'has_notices'  => true,
        'dismissable'  => true,
        'dismiss_msg'  => '',
        'is_automatic' => false,
        'message'      => '',
    ];

    tgmpa( $plugins, $config );
}
