<?php
/**
 * Admin Option for this theme
 *
 * @package yankee
 */

if ( !defined( 'ABSPATH' ) ) {
    exit( 'No direct script access allowed' );
}

// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {

    // Set a unique slug-like ID
    $prefix = 'yankee_options';

    // Create options
    CSF::createOptions( $prefix, [
        'menu_title'         => esc_html__( 'Theme Options', 'yankee' ),
        'menu_slug'          => 'yankee-theme-options',
        'framework_title'    => esc_html__( 'Yankee', 'yankee' ),
        'show_in_customizer' => true,
    ] );

    // Header Layout
    CSF::createSection( $prefix, [
        'title'  => esc_html__( 'Preloader', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Preloader', 'yankee' ),
            ],
            [
                'id'      => 'site-preloader',
                'type'    => 'switcher',
                'default' => 'true',
                'title'   => esc_html__( 'Enable Preloader', 'yankee' ),
            ],
            [
                'id'          => 'preloader_bg',
                'type'        => 'color',
                'title'       => esc_html__( 'Background', 'yankee' ),
                'output'      => '#preloader',
                'output_mode' => 'background-color',
                'dependency'  => [
                    'site-preloader', '==', 'true',
                ],
            ],
            [
                'id'          => 'preloader_bg_line',
                'type'        => 'color',
                'title'       => esc_html__( 'Line Color', 'yankee' ),
                'output'      => ['#preloader .loader span', '#preloader .loader::befroe', '#preloader .loader::after'],
                'output_mode' => 'background-color',
                'dependency'  => [
                    'site-preloader', '==', 'true',
                ],
            ],
        ],
    ] );

    // Header Options
    CSF::createSection( $prefix, [
        'id'    => 'header_options',
        'title' => esc_html__( 'Header', 'yankee' ),
    ] );

    // Header Layout
    CSF::createSection( $prefix, [
        'parent' => 'header_options',
        'title'  => esc_html__( 'Header Layout', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Header Layout', 'yankee' ),
            ],
            [
                'id'      => 'header-layout',
                'type'    => 'image_select',
                'title'   => esc_html__( 'Header Layout', 'yankee' ),
                'options' => [
                    'header-one'   => get_template_directory_uri() . '/assets/img/header-one.png',
                    'header-two'   => get_template_directory_uri() . '/assets/img/header-two.png',
                    'header-three' => get_template_directory_uri() . '/assets/img/header-three.png',
                    'header-four' => get_template_directory_uri() . '/assets/img/header-four.png',
                ],
                'default' => 'header-one',
                'desc'    => esc_html__( 'Select your header style', 'yankee' ),
            ],
            [
                'id'      => 'sticky-header',
                'type'    => 'switcher',
                'default' => 'true',
                'title'   => esc_html__( 'Sticky header', 'yankee' ),
                'desc'    => esc_html__( 'It will stick header at the top when page scrolling', 'yankee' ),
            ],
        ],
    ] );

    // Header logo
    CSF::createSection( $prefix, [
        'parent' => 'header_options',
        'title'  => esc_html__( 'Logo', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Logo', 'yankee' ),
            ],
            [
                'id'      => 'site-img-logo',
                'type'    => 'media',
                'title'   => esc_html__( 'Select your Site logo', 'yankee' ),
                'library' => 'image',
                'url'     => false,
            ],
            [
                'id'    => 'use-text-logo',
                'type'  => 'switcher',
                'title' => esc_html__( 'Use text as logo?', 'yankee' ),
            ],
            [
                'id'         => 'site-text-logo',
                'type'       => 'text',
                'title'      => esc_html__( 'Type Logo Name', 'yankee' ),
                'default'    => esc_html__( 'Yankee', 'yankee' ),
                'dependency' => [
                    'use-text-logo', '==', 'true',
                ],
            ],
            [
                'id'     => 'site-logo-dimensions',
                'type'   => 'dimensions',
                'title'  => esc_html__( 'Logo Dimensions', 'yankee' ),
                'desc'   => esc_html__( 'Set a custom height, width for your upload logo.', 'yankee' ),
                'output' => 'header .nav-container .site-logo img',
            ],
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Mobile(Panel) Logo', 'yankee' ),
            ],
            [
                'id'      => 'site-m-img-logo',
                'type'    => 'media',
                'title'   => esc_html__( 'Select your Site logo', 'yankee' ),
                'library' => 'image',
                'url'     => false,
            ],
            [
                'id'    => 'use-m-text-logo',
                'type'  => 'switcher',
                'title' => esc_html__( 'Use text as logo?', 'yankee' ),
            ],
            [
                'id'         => 'site-m-text-logo',
                'type'       => 'text',
                'title'      => esc_html__( 'Type Logo Name', 'yankee' ),
                'default'    => esc_html__( 'Yankee', 'yankee' ),
                'dependency' => [
                    'use-m-text-logo', '==', 'true',
                ],
            ],
            [
                'id'     => 'mobile-logo-dimensions',
                'type'   => 'dimensions',
                'title'  => esc_html__( 'Logo Dimensions', 'yankee' ),
                'desc'   => esc_html__( 'Set a custom height, width for your upload logo.', 'yankee' ),
                'output' => 'header .mobile-menu .site-logo img',
            ],
        ],
    ] );

    // Header Extra
    CSF::createSection( $prefix, [
        'parent' => 'header_options',
        'title'  => esc_html__( 'Header Extra', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Header Extra Informations', 'yankee' ),
            ],
            [
                'id'      => 'show-contact-btn',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Show Contact Button', 'yankee' ),
                'default' => 'true',
            ],
            [
                'id'         => 'contact-btn-title',
                'type'       => 'text',
                'title'      => esc_html__( 'Contact Button Title', 'yankee' ),
                'default'    => esc_html__( 'Phone Number', 'yankee' ),
                'dependency' => ['show-contact-btn', '==', 'true'],
            ],
            [
                'id'         => 'contact-btn-number',
                'type'       => 'text',
                'title'      => esc_html__( 'Contact Button Number', 'yankee' ),
                'default'    => esc_html__( '987-987-987-98', 'yankee' ),
                'dependency' => ['show-contact-btn', '==', 'true'],
            ],
            [
                'id'      => 'show-search-form',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Show Search Icon', 'yankee' ),
                'default' => true,
            ],
            [
                'id'      => 'show-offcanvas-panel',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Show offcanvs panel', 'yankee' ),
                'default' => true,
            ],
            [
                'type'       => 'notice',
                'style'      => 'warning',
                'content'    => esc_html__( 'Off Canvas panel only work with header layout three', 'yankee' ),
                'dependency' => [
                    'show-offcanvas-panel', '==', 'true',
                ],
            ],
            [
                'id'         => 'panel-img-logo',
                'type'       => 'media',
                'title'      => esc_html__( 'Select  Panel logo', 'yankee' ),
                'library'    => 'image',
                'url'        => false,
                'dependency' => [
                    'show-offcanvas-panel', '==', 'true',
                ],
            ],
            [
                'id'         => 'panel-desc',
                'type'       => 'textarea',
                'title'      => esc_html__( 'Description', 'yankee' ),
                'default'    => esc_html( 'We are experienced professionals who understand that It services is changing, and are true partners who care about your future business success.' ),
                'dependency' => [
                    'show-offcanvas-panel', '==', 'true',
                ],
            ],
            [
                'id'         => 'contact-blocks',
                'type'       => 'group',
                'title'      => esc_html__( 'Contact Blocks', 'yankee' ),
                'dependency' => [
                    'show-offcanvas-panel', '==', 'true',
                ],
                'fields'     => [
                    [
                        'id'    => 'contact-block-title',
                        'type'  => 'text',
                        'title' => esc_html__( 'Title', 'yankee' ),
                    ],
                    [
                        'id'     => 'contact-blocks-infos',
                        'type'   => 'group',
                        'title'  => esc_html__( 'Informations', 'yankee' ),
                        'fields' => [
                            [
                                'id'    => 'contact-info',
                                'type'  => 'text',
                                'title' => esc_html__( 'Information', 'yankee' ),
                            ],
                        ],
                    ],
                ],
                'default'    => [
                    [
                        'contact-block-title'  => esc_html( 'Our Location' ),
                        'contact-blocks-infos' => [
                            [
                                'contact-info' => esc_html( '2307 Beverley Rd Brooklyn, New York 11226 United States.' ),
                            ],
                        ],
                    ],
                    [
                        'contact-block-title'  => esc_html( 'Quick Contact' ),
                        'contact-blocks-infos' => [
                            [
                                'contact-info' => esc_html( 'Email: info@example.com' ),
                            ],
                            [
                                'contact-info' => esc_html( 'Support: support@example.com' ),
                            ],
                        ],
                    ],
                    [
                        'contact-block-title'  => esc_html( 'Opening Hours' ),
                        'contact-blocks-infos' => [
                            [
                                'contact-info' => esc_html( 'Monday - Friday' ),
                            ],
                            [
                                'contact-info' => esc_html( '8 am to 7 pm' ),
                            ],
                        ],
                    ],
                ],
            ],
            [
                'id'         => 'panel-social-icons',
                'type'       => 'group',
                'title'      => esc_html__( 'Social Icons', 'yankee' ),
                'dependency' => [
                    'show-offcanvas-panel', '==', 'true',
                ],
                'fields'     => [
                    [
                        'id'    => 'panel-social-icon',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Icons', 'yankee' ),
                    ],
                    [
                        'id'    => 'panel-social-links',
                        'type'  => 'text',
                        'title' => esc_html__( 'Social Links', 'yankee' ),
                    ],
                ],
            ],

        ],
    ] );

    // Header Styling
    CSF::createSection( $prefix, [
        'parent' => 'header_options',
        'title'  => esc_html__( 'Header Styling', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Header Styling', 'yankee' ),
            ],
            [
                'id'          => 'header_bg',
                'type'        => 'color',
                'title'       => esc_html__( 'Header Background', 'yankee' ),
                'output'      => ['.header-version-one .header-nav .nav-container', '.header-version-two .site-header', '.header-version-three .site-header'],
                'output_mode' => 'background-color',
            ],
            [
                'id'          => 'sticky_header_bg',
                'type'        => 'color',
                'title'       => esc_html__( 'Header Sticky Background', 'yankee' ),
                'desc'        => esc_html__( 'Background color on Header sticky mode ', 'yankee' ),
                'output'      => ['.header-version-one.sticky-on .header-nav .nav-container', '.header-version-two.sticky-on .site-header', '.header-version-three.sticky-on .site-header'],
                'output_mode' => 'background-color',
            ],
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Contact btn', 'yankee' ),
            ],
            [
                'id'          => 'contact_btn_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Color', 'yankee' ),
                'output'      => 'header.site-header .header-nav .contact-btn',
                'output_mode' => 'color',
            ],
            [
                'id'          => 'contact_btn_bg',
                'type'        => 'color',
                'title'       => esc_html__( 'Background Color', 'yankee' ),
                'output'      => 'header.site-header .header-nav .contact-btn',
                'output_mode' => 'background-color',
            ],
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Header Skew shape', 'yankee' ),
            ],
            [
                'id'      => 'skew-shape',
                'type'    => 'switcher',
                'default' => 'false',
                'title'   => esc_html__( 'Skew Shape', 'yankee' ),
            ],
            [
                'id'          => 'header_shape_bg',
                'type'        => 'color',
                'title'       => esc_html__( 'Background Color', 'yankee' ),
                'output'      => '.body-clippy-shape',
                'output_mode' => 'background-color',
            ],
            [
                'id'     => 'header_shape_b',
                'type'   => 'dimensions',
                'title'  => esc_html__( 'Dimensions', 'yankee' ),
                'output' => '.background-color',
            ],
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Off Canvas', 'yankee' ),
            ],
            [
                'id'          => 'off_canvas_bg_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Background Color', 'yankee' ),
                'output'      => '.off-canvas-items',
                'output_mode' => 'background-color',
            ],
            [
                'id'          => 'off_canvas_heading_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Heading Color', 'yankee' ),
                'output'      => '.off-canvas-items .contact-block-title',
                'output_mode' => 'color',
            ],
            [
                'id'          => 'off_canvas_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Color', 'yankee' ),
                'output'      => ['.off-canvas-items', '.off-canvas-items .canvas-close'],
                'output_mode' => 'color',
            ],
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'Social icons', 'yankee' ),
            ],
            [
                'id'          => 'off_canvas_social_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Color', 'yankee' ),
                'output'      => '.off-canvas-items .social-icons a',
                'output_mode' => 'color',
            ],
            [
                'id'          => 'off_canvas_social_border',
                'type'        => 'color',
                'title'       => esc_html__( 'Border Color', 'yankee' ),
                'output'      => '.off-canvas-items .social-icons a',
                'output_mode' => 'border-color',
            ],
            [
                'id'          => 'off_canvas_social_h_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Hover Color', 'yankee' ),
                'output'      => '.off-canvas-items .social-icons a:hover',
                'output_mode' => 'color',
            ],
            [
                'id'          => 'off_canvas_social_h_bg',
                'type'        => 'color',
                'title'       => esc_html__( 'Hover BG Color', 'yankee' ),
                'output'      => '.off-canvas-items .social-icons a:hover',
                'output_mode' => 'background-color',
            ],
            [
                'id'          => 'off_canvas_social_h_border',
                'type'        => 'color',
                'title'       => esc_html__( 'Hover Border Color', 'yankee' ),
                'output'      => '.off-canvas-items .social-icons a:hover',
                'output_mode' => 'border-color',
            ],
        ],
    ] );

    // Menu Styling
    CSF::createSection( $prefix, [
        'parent' => 'header_options',
        'title'  => esc_html__( 'Menu', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Menu Items', 'yankee' ),
            ],
            [
                'id'          => 'menu_item_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Menu Item Color', 'yankee' ),
                'desc'        => esc_html__( 'This is the menu item font color.', 'yankee' ),
                'output'      => ['.header-nav .nav-container .menu-items li a', '.header-nav .nav-container .menu-items li'],
                'output_mode' => 'color',
            ],
            [
                'id'          => 'menu_item_hover_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Active/Hover Color', 'yankee' ),
                'desc'        => esc_html__( 'This is the menu item font color.', 'yankee' ),
                'output'      => ['header.site-header .header-nav .nav-container .menu-items li:hover > a', 'header.site-header .header-nav .nav-container .menu-items li:hover', 'header.site-header .header-nav .nav-container .menu-items li.current-menu-item > a', 'header.site-header .header-nav .nav-container .menu-items li.current-menu-item'],
                'output_mode' => 'color',
            ],
            [
                'id'     => 'menu_typography',
                'type'   => 'typography',
                'title'  => esc_html__( 'Menu Typography', 'yankee' ),
                'color'  => false,
                'output' => ['header.site-header .header-nav .nav-container .menu-items li'],
            ],
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'Submenu Items', 'yankee' ),
            ],
            [
                'id'          => 'submenu_item_bg_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Submenu Background', 'yankee' ),
                'desc'        => esc_html__( 'This is the submenu background.', 'yankee' ),
                'output'      => ['.header-nav .nav-container .menu-items li .sub-menu'],
                'output_mode' => 'background-color',
            ],
            [
                'id'          => 'submenu_item_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Submenu Color', 'yankee' ),
                'desc'        => esc_html__( 'This is the submenu item font color.', 'yankee' ),
                'output'      => ['.header-nav .nav-container .menu-items li .sub-menu li a'],
                'output_mode' => 'color',
            ],
            [
                'id'               => 'submenu_item_bghover__color',
                'type'             => 'color',
                'output_important' => true,
                'title'            => esc_html__( 'Submenu Background(Hover)', 'yankee' ),
                'desc'             => esc_html__( 'This is the submenu background.', 'yankee' ),
                'output'           => ['.header-nav .nav-container .menu-items li .sub-menu li a:hover'],
                'output_mode'      => 'background-color',
            ],
            [
                'id'               => 'submenu_item_hover_color',
                'type'             => 'color',
                'output_important' => true,
                'title'            => esc_html__( 'Submenu Color(Hover)', 'yankee' ),
                'desc'             => esc_html__( 'This is the submenu item font color.', 'yankee' ),
                'output'           => ['.header-nav .nav-container .menu-items li .sub-menu li a:hover'],
                'output_mode'      => 'color',
            ],
            [
                'id'     => 'submenu_typography',
                'type'   => 'typography',
                'title'  => esc_html__( 'SubMenu Typography', 'yankee' ),
                'color'  => false,
                'output' => ['.header-nav .nav-container .menu-items li .sub-menu li'],
            ],
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Mobile Menu(Panel)', 'yankee' ),
            ],
            [
                'id'          => 'mobile_menu_bg',
                'type'        => 'color',
                'title'       => esc_html__( 'Background', 'yankee' ),
                'desc'        => esc_html__( 'This is the submenu background.', 'yankee' ),
                'output'      => ['header .header-nav .mobile-menu'],
                'output_mode' => 'background-color',
            ],
            [
                'id'          => 'mobile_menu_color',
                'type'        => 'color',
                'title'       => esc_html__( 'Color', 'yankee' ),
                'desc'        => esc_html__( 'This is the submenu background.', 'yankee' ),
                'output'      => ['header .header-nav .mobile-menu .menu-items ul li a'],
                'output_mode' => 'color',
            ],
        ],
    ] );

    // Footer Options
    CSF::createSection( $prefix, [
        'id'    => 'footer_options',
        'title' => esc_html__( 'Footer', 'yankee' ),
    ] );

    // Footer Layout
    CSF::createSection( $prefix, [
        'parent' => 'footer_options',
        'title'  => esc_html__( 'Footer', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Footer', 'yankee' ),
            ],
            [
                'id'            => 'site-footer',
                'type'          => 'select',
                'title'         => esc_html__( 'Select Footer', 'yankee' ),
                'placeholder'   => esc_html__( 'Select Footer', 'yankee' ),
                'options'       => 'posts',
                'empty_message' => esc_html__( 'No Footer Template Found. You can create footer template from Footer>Add New ', 'yankee' ),
                'query_args'    => [
                    'post_type' => 'footer',
                ],
                'desc'          => esc_html__( 'Select a Footer template from here. Leave the field empty to use the default footer.', 'yankee' ),
            ],
            [
                'type'       => 'notice',
                'style'      => 'warning',
                'content'    => esc_html__( 'You have selected a Custom Footer template. Now, all the Footer Settings will not apply. Edit your Footer template with Footer Elementor.', 'yankee' ),
                'dependency' => [
                    'site-footer', '!=', '',
                ],
            ],
        ],
    ] );

    // Footer Styling
    CSF::createSection( $prefix, [
        'parent' => 'footer_options',
        'title'  => esc_html__( 'Footer Widget Area', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Widget Area', 'yankee' ),
            ],
            [
                'id'     => 'footer_bg',
                'type'   => 'background',
                'title'  => esc_html__( 'Background', 'yankee' ),
                'output' => '.site-footer .footer-widgets',
            ],
            [
                'id'     => 'footer_text_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Text Color', 'yankee' ),
                'output' => ['.site-footer .footer-widgets .widget', '.site-footer .footer-widgets .widget a'],
            ],
            [
                'id'     => 'footer_content_typography',
                'type'   => 'typography',
                'title'  => esc_html__( 'Content Typography', 'yankee' ),
                'color'  => false,
                'output' => ['.site-footer .footer-widgets .widget', '.site-footer .footer-widgets .widget a'],
            ],
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'Widget Title', 'yankee' ),
            ],
            [
                'id'     => 'footer_title_typography',
                'type'   => 'typography',
                'title'  => esc_html__( 'Title', 'yankee' ),
                'output' => '.footer-widgets .widget .widget-title',
            ],
        ],
    ] );

    // Footer Copyright
    CSF::createSection( $prefix, [
        'parent' => 'footer_options',
        'title'  => esc_html__( 'Footer Copyright', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Footer', 'yankee' ),
            ],
            [
                'id'      => 'footer-logo',
                'type'    => 'media',
                'title'   => esc_html__( 'logo', 'yankee' ),
                'library' => 'image',
                'url'     => false,
            ],
            [
                'id'      => 'footer-copyright-text',
                'type'    => 'textarea',
                'title'   => esc_html__( 'Copyright Text', 'yankee' ),
                'default' => esc_html( 'Copyright ©2021. All Rights Reserved' ),
            ],
            [
                'id'     => 'footer-copyright-bg',
                'type'   => 'background',
                'title'  => esc_html__( 'Background', 'yankee' ),
                'output' => '.site-footer .footer-copyright',
            ],
            [
                'id'     => 'footer-copyright-color',
                'type'   => 'typography',
                'title'  => esc_html__( 'Text', 'yankee' ),
                'output' => '.site-footer .footer-copyright p',
            ],
        ],
    ] );

    // Page Heading Option
    CSF::createSection( $prefix, [
        'title'  => esc_html__( 'Page Heading', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Page Heading', 'yankee' ),
            ],
            [
                'id'      => 'page-heading',
                'type'    => 'button_set',
                'title'   => esc_html__( 'Enable Page Heading?', 'yankee' ),
                'options' => [
                    'enabled'  => esc_html( 'Enabled', 'yankee' ),
                    'disabled' => esc_html( 'Disabled', 'yankee' ),
                ],
                'default' => 'enabled',
            ],
            [
                'id'         => 'site-breadcrumb',
                'type'       => 'button_set',
                'title'      => esc_html__( 'Enable Site Breadcrumb?', 'yankee' ),
                'options'    => [
                    'enabled'  => esc_html( 'Enabled', 'yankee' ),
                    'disabled' => esc_html( 'Disabled', 'yankee' ),
                ],
                'default'    => 'enabled',
                'dependency' => [
                    'page-heading', '==', 'enabled',
                ],
            ],
            [
                'id'         => 'page-title-tag',
                'type'       => 'text',
                'title'      => 'Title tag',
                'default'    => esc_html__( 'Welcome to our company', 'yankee' ),
                'dependency' => [
                    'page-heading', '==', 'enabled',
                ],
            ],
            [
                'type'       => 'heading',
                'content'    => esc_html__( 'Styling', 'yankee' ),
                'dependency' => [
                    'page-heading', '==', 'enabled',
                ],
            ],
            [
                'id'         => 'page-heading-bg',
                'type'       => 'background',
                'title'      => esc_html__( 'Background', 'yankee' ),
                'output'     => '.page-haeder',
                'dependency' => [
                    'page-heading', '==', 'enabled',
                ],
            ],
            [
                'id'          => 'page-heading-overly',
                'type'        => 'color',
                'title'       => esc_html__( 'Overly', 'yankee' ),
                'output'      => '.page-haeder::before',
                'output_mode' => 'background-color',
                'dependency'  => [
                    'page-heading', '==', 'enabled',
                ],
            ],
            [
                'id'          => 'page-heading-overly-opacity',
                'type'        => 'slider',
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.1,
                'unit'        => ' ',
                'title'       => esc_html__( 'Overly opacity', 'yankee' ),
                'desc'        => esc_html__( 'Overly opacity between 0 to 1. Line: 0.5', 'yankee' ),
                'output'      => '.page-haeder::before',
                'output_mode' => 'opacity',
                'dependency'  => [
                    'page-heading', '==', 'enabled',
                ],
            ],
            [
                'id'         => 'page-heading-title',
                'type'       => 'typography',
                'title'      => esc_html__( 'Title', 'yankee' ),
                'output'     => '.page-haeder .page-title',
                'dependency' => [
                    'page-heading', '==', 'enabled',
                ],
            ],
            [
                'id'         => 'page-heading-title-tag',
                'type'       => 'typography',
                'title'      => esc_html__( 'Title Tag', 'yankee' ),
                'output'     => '.page-haeder .page-tag',
                'dependency' => [
                    'page-heading', '==', 'enabled',
                ],
            ],
            [
                'type'       => 'subheading',
                'content'    => esc_html__( 'Breadcrumb', 'yankee' ),
                'dependency' => [
                    ['page-heading', '==', 'enabled'],
                    ['site-breadcrumb', '==', 'enabled'],
                ],
            ],
            [
                'id'          => 'breadcrumb_bg',
                'type'        => 'color',
                'title'       => esc_html__( 'Background', 'yankee' ),
                'output'      => '.page-haeder .breadcrumb-nav',
                'output_mode' => 'background-color',
                'dependency'  => [
                    ['page-heading', '==', 'enabled'],
                    ['site-breadcrumb', '==', 'enabled'],
                ],
            ],
            [
                'id'         => 'breadcrumb-content_typo',
                'type'       => 'typography',
                'title'      => esc_html__( 'Typography', 'yankee' ),
                'output'     => '.page-haeder .breadcrumb-nav',
                'dependency' => [
                    ['page-heading', '==', 'enabled'],
                    ['site-breadcrumb', '==', 'enabled'],
                ],
            ],
            [
                'id'         => 'breadcrumb_link_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Link Color', 'yankee' ),
                'output'     => '.page-haeder .breadcrumb-nav li a',
                'dependency' => [
                    ['page-heading', '==', 'enabled'],
                    ['site-breadcrumb', '==', 'enabled'],
                ],
            ],
        ],
    ] );

    // Blog Options
    CSF::createSection( $prefix, [
        'id'    => 'blog_options',
        'title' => esc_html__( 'Blog Pages', 'yankee' ),
    ] );

    // Blog Archive
    CSF::createSection( $prefix, [
        'parent' => 'blog_options',
        'title'  => esc_html__( 'Blog Archive', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Blog Archive', 'yankee' ),
            ],
            [
                'id'      => 'blog_archive_layout',
                'type'    => 'image_select',
                'title'   => esc_html__( 'Blog Archive Layout', 'yankee' ),
                'options' => [
                    'boxed-layout'     => get_template_directory_uri() . '/assets/img/boxed-layout.jpg',
                    'fullwidth-layout' => get_template_directory_uri() . '/assets/img/fullwidth-layout.jpg',
                ],
                'default' => 'boxed-layout',
                'desc'    => esc_html__( 'The Blog layout will also apply on the blog category and tag archive pages.', 'yankee' ),
            ],
            [
                'id'      => 'blog_archive_sidebar',
                'type'    => 'image_select',
                'title'   => esc_html__( 'Blog Archive Sidebar', 'yankee' ),
                'options' => [
                    'left-sidebar'  => get_template_directory_uri() . '/assets/img/left-sidebar.jpg',
                    'right-sidebar' => get_template_directory_uri() . '/assets/img/right-sidebar.jpg',
                    'no-sidebar'    => get_template_directory_uri() . '/assets/img/no-sidebar.jpg',
                ],
                'default' => 'right-sidebar',
            ],
            [
                'id'         => 'post-archive-meta',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Post Meta', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
            [
                'id'         => 'post-archive-cat',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Post Category', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
            [
                'id'         => 'post-archive-user',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Post User', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
            [
                'id'      => 'post-archive-redmore',
                'type'    => 'text',
                'title'   => esc_html__( 'Read More', 'yankee' ),
                'default' => esc_html__( 'Read More', 'yankee' ),
            ],
        ],
    ] );

    // Blog Single
    CSF::createSection( $prefix, [
        'parent' => 'blog_options',
        'title'  => esc_html__( 'Blog Single', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Blog Single', 'yankee' ),
            ],
            [
                'id'      => 'blog_single_layout',
                'type'    => 'image_select',
                'title'   => esc_html__( 'Blog Single Layout', 'yankee' ),
                'options' => [
                    'boxed-layout'     => get_template_directory_uri() . '/assets/img/boxed-layout.jpg',
                    'fullwidth-layout' => get_template_directory_uri() . '/assets/img/fullwidth-layout.jpg',
                ],
                'default' => 'boxed-layout',
                'desc'    => esc_html__( 'The Blog layout will also apply on the blog category and tag single pages.', 'yankee' ),
            ],
            [
                'id'      => 'blog_single_sidebar',
                'type'    => 'image_select',
                'title'   => esc_html__( 'Blog Single Sidebar', 'yankee' ),
                'options' => [
                    'left-sidebar'  => get_template_directory_uri() . '/assets/img/left-sidebar.jpg',
                    'right-sidebar' => get_template_directory_uri() . '/assets/img/right-sidebar.jpg',
                    'no-sidebar'    => get_template_directory_uri() . '/assets/img/no-sidebar.jpg',
                ],
                'default' => 'right-sidebar',
            ],
            [
                'id'         => 'show-post-meta',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Post Meta', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
            [
                'id'         => 'show-post-tag',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Post Tag', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
            [
                'id'         => 'post-tag-title',
                'type'       => 'text',
                'title'      => esc_html__( 'Title', 'yankee' ),
                'default'    => esc_html__( 'Releted Tags', 'yankee' ),
                'dependency' => ['show-post-tag', '==', 'true'],
            ],
            [
                'id'         => 'show-post-share',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Social Share', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
            [
                'id'      => 'social-share-item',
                'type'    => 'sorter',
                'title'   => esc_html__( 'Social Share Links', 'yankee' ),
                'default' => [
                    'enabled'  => [
                        'facebook'  => esc_html( 'Facebook', 'yankee' ),
                        'twitter'   => esc_html( 'Twitter', 'yankee' ),
                        'pinterest' => esc_html( 'Pinterest', 'yankee' ),
                        'linkedin'  => esc_html( 'Linkedin', 'yankee' ),
                    ],
                    'disabled' => [
                        'tumblr' => esc_html( 'Tumblr', 'yankee' ),
                        'reddit' => esc_html( 'Reddit', 'yankee' ),
                        'vk'     => esc_html( 'VK', 'yankee' ),
                    ],
                ],
            ],
            [
                'id'         => 'post-share-title',
                'type'       => 'text',
                'title'      => esc_html__( 'Title', 'yankee' ),
                'default'    => esc_html__( 'Social Share', 'yankee' ),
                'dependency' => ['show-post-tag', '==', 'true'],
            ],
            [
                'id'         => 'show-post-nav',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Post Nav', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
            [
                'id'         => 'show-related-post',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Related Post', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
            [
                'id'         => 'post-related-title',
                'type'       => 'text',
                'title'      => esc_html__( 'Title', 'yankee' ),
                'default'    => esc_html__( 'Related Post', 'yankee' ),
                'dependency' => ['show-related-post', '==', 'true'],
            ],
            [
                'id'         => 'related-post-count',
                'type'       => 'spinner',
                'title'      => esc_html__( 'Related posts count', 'yankee' ),
                'min'        => 1,
                'max'        => 20,
                'step'       => 1,
                'default'    => 2,
                'dependency' => ['show-related-post', '==', 'true'],
            ],
            [
                'id'         => 'related-title-limit',
                'type'       => 'spinner',
                'title'      => esc_html__( 'Title Words Limit', 'yankee' ),
                'min'        => 1,
                'max'        => 100,
                'step'       => 1,
                'default'    => 10,
                'dependency' => ['show-related-post', '==', 'true'],
            ],
            [
                'id'         => 'show-author-info',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Show Author Info', 'yankee' ),
                'text_on'    => esc_html__( 'Enable', 'yankee' ),
                'text_off'   => esc_html__( 'Disable', 'yankee' ),
                'text_width' => 100,
                'default'    => true,
            ],
        ],
    ] );

    // Color Scheme
    CSF::createSection( $prefix, [
        'title'  => esc_html__( 'Color Scheme', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Color Scheme', 'yankee' ),
            ],
            [
                'id'     => 'primary-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Primary Color', 'yankee' ),
                'output' => [
                    'background-color' => '.main-btn, .page-inner .post-password-form input[type=submit], .header-nav .nav-container .menu-items li .sub-menu li a:hover, .header-nav .serach-wrap .search-form form button, .header-nav .contact-btn, .entry-single-post .post-categories a, .entry-single-post.format-video .entry-media .popup-video, .entry-single-post.post-details .post-content-area .wp-block-search button, .entry-single-post.post-details .post-content-area .wp-block-tag-cloud a:hover, .entry-single-post.post-details .entry-content .post-password-form input[type=submit], .entry-single-post.post-details .entry-footer .related-tags li a:hover, .page-pagination .page-numbers.current, .page-pagination .page-numbers:hover, .widget .widget-title::before, .widget .widget-title::after, .widget.widget_categories li a:hover, .widget.widget_archive li a:hover, .widget.yankee-service-list li a:hover, .widget.widget_search form button, .widget.widget_tag_cloud .tagcloud a:hover, .widget.yankee-social-links ul a:hover, .widget.yankee-contact-form .wpcf7-form-control.wpcf7-submit, .mc4wp-form input[type=submit], .mc4wp-form button, .comments-area form .form-submit input#submit, .not-found-content form button.search-submit, background-color',

                    'color'            => '.input-group .icon, a, a:hover, .header-nav .nav-container .menu-items li.current-menu-item, .header-nav .nav-container .menu-items li.current-menu-item a, .header-nav .nav-container .menu-items li:hover, .header-nav .nav-container .menu-items li:hover a, .page-haeder, .page-haeder .breadcrumb-nav li.active a, .entry-single-post .entry-meta a:hover, .entry-single-post .summary-footer a:hover, .entry-single-post.format-link .link-box i, .entry-single-post.format-quote .quote-box i, .entry-single-post.post-details .post-content-area ul.wp-block-latest-posts a:hover, .entry-single-post.post-details .post-content-area .wp-block-rss a:hover, .entry-single-post.post-details .post-content-area .wp-block-archives a:hover, .entry-single-post.post-details .entry-meta a, .entry-single-post.post-details .post-nav .prev-post span, .entry-single-post.post-details .post-nav .next-post span, .entry-single-post.post-details .related-post .single-related-post .desc .date, .entry-single-post.post-details .author-info-box .written-by, .entry-single-post.post-details .author-info-box .user-links a:hover, .widget.widget_pages li a:hover, .widget.widget_meta li a:hover, .widget.widget_nav_menu li a:hover, .widget.widget_recent_entries li a:hover, .widget.widget_recent_comments li a:hover, .widget.widget_rss li a.rsswidget:hover, .widget.yankee-contact-form .title-tag, .yankee-nav-widget li a:hover, .comments-area .logged-in-as a:hover, .comments-area form .comment-form-comment .icon, .comments-area form .comment-form-author .icon, .comments-area form .comment-form-email .icon, .comments-area .comment-list li .comment-time, .portfolio-post-nav .prev-post span, .portfolio-post-nav .next-post span, .entry-team-details .position, .entry-team-details .member-contact-info span, .entry-team-details .member-contact-info .social-links li a:hover, .entry-team-details .member-contact-info .contact-info li i, .entry-team-details .member-contact-info .contact-info li a:hover, .footer-widgets .widget.widget_categories li a .posts-count, .footer-widgets .widget.widget_archive li a .posts-count',

                    'border-color'     => '.page-pagination .page-numbers.current, .page-pagination .page-numbers:hover',
                ],
            ],
            [
                'id'     => 'second-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Second Color', 'yankee' ),
                'output' => [
                    'background-color' => '::-webkit-scrollbar-thumb, .main-btn:hover, .page-inner .post-password-form input[type=submit]:hover, .header-nav .nav-container .navbar-toggler span, .header-nav .mobile-menu, .header-nav.header-nav-two .nav-container .menu-items li .sub-menu a:hover, .off-canvas-items, .off-canvas-wrap .canvas-overly, .page-haeder, .entry-single-post .post-categories a:hover, .entry-single-post.post-details .post-content-area .wp-block-search button:hover, .entry-single-post.post-details .entry-content .post-password-form input[type=submit]:hover, .page-links a:hover, .page-links > span, .widget.widget_categories li a, .widget.widget_archive li a, .widget.yankee-service-list li a, .widget.widget_search form button:hover, .widget.yankee-contact-form, .mc4wp-form input[type=submit]:hover, .mc4wp-form button:hover, .comments-area form .form-submit input#submit:hover, .comments-area .comment-list li .comment-reply a:hover',

                    'color'            => 'body, input, textarea, select, h1, h2, h3, h4, h5, h6, h1 a, h2 a, h3 a, h4 a, h5 a, h6 a, .main-btn, .header-nav .nav-container .site-logo a, .header-nav .nav-container .menu-items li a, .header-nav .nav-container .menu-items li .sub-menu li a, .header-nav .serach-wrap .search-icon, .header-nav.header-nav-two .nav-container .menu-items li.current-menu-item, .header-nav.header-nav-two .nav-container .menu-items li.current-menu-item a, .header-nav.header-nav-two .nav-container .menu-items li:hover, .header-nav.header-nav-two .nav-container .menu-items li:hover a, .header-nav.header-nav-three .off-canvas-btn, .header-nav.header-nav-three .search-icon, .header-nav.header-nav-three .navbar-toggler, .off-canvas-items .social-icons a:hover, .page-haeder .breadcrumb-nav li:not(:last-child)::after, .page-haeder .breadcrumb-nav li a, .entry-single-post .post-categories a, .entry-single-post .entry-meta a, .entry-single-post .summary-footer a, .entry-single-post.format-link .link-box a, .entry-single-post.format-quote .quote-box cite, .entry-single-post.format-video .entry-media .popup-video, .entry-single-post.post-details .post-content-area .wp-block-latest-comments__comment-author, .entry-single-post.post-details .post-content-area .wp-block-latest-comments__comment-link, .entry-single-post.post-details .post-content-area .wp-block-tag-cloud a, .entry-single-post.post-details .post-content-area .wp-block-rss a, .entry-single-post.post-details .post-content-area .wp-block-archives a, .entry-single-post.post-details .entry-meta a:hover, .entry-single-post.post-details .entry-footer .related-tags li a, .entry-single-post.post-details .entry-footer .related-tags li a:hover, .entry-single-post.post-details .post-nav .prev-post a, .entry-single-post.post-details .post-nav .next-post a, .page-pagination .page-numbers, .page-links a, .page-links > span, .widget.widget_calendar caption, .widget.widget_pages li a, .widget.widget_meta li a, .widget.widget_nav_menu li a, .widget.widget_recent_entries li a, .widget.widget_recent_comments li a, .widget.widget_rss li a.rsswidget, .widget.widget_tag_cloud .tagcloud a, .widget.yankee-social-links ul a, .widget.yankee-contact-form .wpcf7-form-control.wpcf7-submit:hover, .mc4wp-form input[type=submit], .mc4wp-form button, .yankee-nav-widget li a, .comments-area .logged-in-as a, .comments-area form input, .comments-area form textarea, .comments-area form ::placeholder, .comments-area form .comment-form-cookies-consent label, .comments-area form .form-submit input#submit, .comments-area .comment-list li .comment-reply a, .portfolio-post-nav .prev-post a, .portfolio-post-nav .next-post a, .entry-team-details .member-contact-info .social-links li a, .entry-team-details .member-contact-info .contact-info li, .entry-team-details .member-contact-info .contact-info li a, .footer-widgets .widget.widget_categories li a, .footer-widgets .widget.widget_archive li a, .footer-widgets .widget.widget_categories li a:hover, .footer-widgets .widget.widget_archive li a:hover',
                ],
            ],
        ],
    ] );

    // Typography
    CSF::createSection( $prefix, [
        'id'     => 'typography_options',
        'title'  => esc_html__( 'Typography', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Typography', 'yankee' ),
            ],
            [
                'id'      => 'typo_note_headers',
                'type'    => 'subheading',
                'style'   => 'info',
                'content' => esc_html__( 'Important Note: This tab contains general typography options. Additional typography options for specific areas can be found within other tabs. Example: For menu typography options go to the Menu Settings tab.', 'yankee' ),
            ],
            [
                'id'     => 'body_typo',
                'type'   => 'typography',
                'title'  => esc_html__( 'Body Typography', 'yankee' ),
                'output' => 'body',
            ],
            [
                'id'     => 'heading1_typo',
                'type'   => 'typography',
                'title'  => esc_html__( 'Heading 1', 'yankee' ),
                'output' => 'h1',
            ],
            [
                'id'     => 'heading2_typo',
                'type'   => 'typography',
                'title'  => esc_html__( 'Heading 2', 'yankee' ),
                'output' => 'h2',
            ],
            [
                'id'     => 'heading3_typo',
                'type'   => 'typography',
                'title'  => esc_html__( 'Heading 3', 'yankee' ),
                'output' => 'h3',
            ],
            [
                'id'     => 'heading4_typo',
                'type'   => 'typography',
                'title'  => esc_html__( 'Heading 4', 'yankee' ),
                'output' => 'h4',
            ],
            [
                'id'     => 'heading5_typo',
                'type'   => 'typography',
                'title'  => esc_html__( 'Heading 5', 'yankee' ),
                'output' => 'h5',
            ],
            [
                'id'     => 'heading6_typo',
                'type'   => 'typography',
                'title'  => esc_html__( 'Heading 6', 'yankee' ),
                'output' => 'h6',
            ],
        ],
    ] );

    // Custom Scripts
    CSF::createSection( $prefix, [
        'id'     => 'custom_scripts',
        'title'  => esc_html__( 'Custom Scripts', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Custom Scripts', 'yankee' ),
            ],
            [
                'id'       => 'yankee-custom-scripts',
                'type'     => 'code_editor',
                'title'    => esc_html__( 'Js Code', 'yankee' ),
                'settings' => [
                    'theme' => 'monokai',
                    'mode'  => 'javascript',
                ],
                'desc'     => esc_html__( 'Add your custom js code here. Must Be type without script tag and valid code', 'yankee' ),
            ],
            [
                'type'    => 'submessage',
                'style'   => 'info',
                'content' => esc_html__( 'You Can add also custom css in Appearance>Customize>Additional CSS', 'yankee' ),
            ],
        ],
    ] );

    CSF::createSection( $prefix, [
        'title'  => esc_html__( '404 error Page', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( '404 error page', 'yankee' ),
            ],
            [
                'id'      => 'error_image',
                'type'    => 'media',
                'title'   => esc_html__( 'Error Image', 'yankee' ),
                'library' => 'image',
            ],

            [
                'id'      => 'error_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Title', 'yankee' ),
                'default' => esc_html( 'Page not found' ),
            ],
            [
                'id'      => 'error_msg',
                'type'    => 'textarea',
                'title'   => esc_html__( 'Error Message', 'yankee' ),
                'default' => esc_html( 'Oops! The page you are looking for does not exist. Maybe go to our home page or try to use a search?' ),
            ],
            [
                'id'      => 'error_btn_text',
                'type'    => 'text',
                'title'   => esc_html__( 'Button Text', 'yankee' ),
                'default' => esc_html( 'Back to Home Page' ),
            ],
        ],
    ] );

    // Custom Post Type Slug
    CSF::createSection( $prefix, [
        'title'  => esc_html__( 'Post Type', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Post Type Slugs', 'yankee' ),
            ],
            [
                'type'    => 'notice',
                'style'   => 'warning',
                'content' => esc_html__( 'These are the custom post\'s slugs offered by Saasland. You can customize the permalink structure (site_domain/post_type_slug/post_slug) by changing the post type slug (post_type_slug) from here. Don\'t forget to save the permalinks settings from Settings > Permalinks after changing the slug value.', 'yankee' ),
            ],
            [
                'id'    => 'service_slug',
                'type'  => 'text',
                'title' => esc_html__( 'Service Slug', 'yankee' ),
            ],
            [
                'id'    => 'team_slug',
                'type'  => 'text',
                'title' => esc_html__( 'Team Slug', 'yankee' ),
            ],
            [
                'id'    => 'portfolio_slug',
                'type'  => 'text',
                'title' => esc_html__( 'Portfolio Slug', 'yankee' ),
            ],
        ],
    ] );

    // Backup
    CSF::createSection( $prefix, [
        'title'  => esc_html__( 'Backup', 'yankee' ),
        'fields' => [
            [
                'type'    => 'heading',
                'content' => esc_html__( 'Backup', 'yankee' ),
            ],
            [
                'type' => 'backup',
            ],
        ],
    ] );
}

/**
 * Function for get all options
 *
 * @link http://codestarframework.com/documentation/#/configurations?id=admin-option-framework
 */
function yankee_get_option( $option = '', $default = null ) {
    $options = get_option( 'yankee_options' );
    return ( isset( $options[$option] ) ) ? $options[$option] : $default;
}

// remove menu from setting
if ( class_exists( 'CSF' ) ) {
    add_filter( 'csf_welcome_page', '__return_false' );
}