<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package yankee
 */

/**
 * Get content layout
 *
 * @return string
 */
function yankee_get_layout() {
    $layout = 'boxed-layout';

    if ( is_page() ) {
        $page_meta = get_post_meta( get_the_ID(), 'yankee_page_metaboxes', true );

        if ( isset( $page_meta['page_layout'] ) ) {
            $layout = $page_meta['page_layout'];
        }

    } elseif( is_single() && 'services' == get_post_type() ) {
        $service_meta = get_post_meta( get_the_ID(), 'yankee_service_metaboxes', true );

        if ( isset( $service_meta['service_layout'] ) ) {
            $layout = $service_meta['service_layout'];
        }

    } elseif( is_single() && 'portfolios' == get_post_type() ) {
        $portfolio_meta = get_post_meta( get_the_ID(), 'yankee_portfolios_metaboxes', true );

        if ( isset( $portfolio_meta['portfolio_layout'] ) ) {
            $layout = $portfolio_meta['portfolio_layout'];
        }

    } elseif ( is_single() ) {
        $layout = yankee_get_option( 'blog_single_layout', 'boxed-layout' );
    } elseif ( !is_page() ) {
        $layout = yankee_get_option( 'blog_archive_layout', 'boxed-layout' );
    }

    return $layout;
}

/**
 * Set Content layout
 *
 * @return array
 */
function yankee_content_layout() {
    $classes = [];

    if ( 'boxed-layout' == yankee_get_layout() ) {
        $classes[] = 'container p-0';
    } elseif ( 'fullwidth-layout' == yankee_get_layout() ) {
        $classes[] = 'container-fluid p-0';
    } else {
        $classes[] = 'container p-0';
    }

    echo implode( ' ', $classes );
}

/**
 * Get Content Sidebar
 *
 * @return string
 */
function yankee_get_sidebar() {
    $sidebar = 'no-sidebar';

    if ( is_page() ) {
        $page_meta = get_post_meta( get_the_ID(), 'yankee_page_metaboxes', true );

        if ( isset( $page_meta['page_sidebar'] ) ) {
            $sidebar = $page_meta['page_sidebar'];
        }

    } elseif( is_single() && 'services' == get_post_type() ) {
        $service_meta = get_post_meta( get_the_ID(), 'yankee_service_metaboxes', true );

        if ( isset( $service_meta['service_sidebar'] ) ) {
            $sidebar = $service_meta['service_sidebar'];
        }

    } elseif( is_single() && 'portfolios' == get_post_type() ) {
        $portfolio_meta = get_post_meta( get_the_ID(), 'yankee_portfolios_metaboxes', true );

        if ( isset( $portfolio_meta['portfolio_sidebar'] ) ) {
            $sidebar = $portfolio_meta['portfolio_sidebar'];
        }

    } elseif ( is_single() ) {
        $sidebar = yankee_get_option( 'blog_single_sidebar', 'right-sidebar' );
    } elseif ( !is_page() ) {
        $sidebar = yankee_get_option( 'blog_archive_sidebar', 'right-sidebar' );
    }

    return $sidebar;
}

/**
 * Set content column
 *
 * @return array
 */
function yankee_content_column() {
    $classes = [];

    if ( 'left-sidebar' == yankee_get_sidebar() ) {
        $classes[] = 'col-lg-8 order-last';
    } elseif ( 'right-sidebar' == yankee_get_sidebar() ) {
        $classes[] = 'col-lg-8';
    } elseif ( 'no-sidebar' == yankee_get_sidebar() ) {
        $classes[] = 'col-12';
    } else {
        $classes[] = 'col-12';
    }

    // return the $classes array
    echo implode( ' ', $classes );
}

/**
 * Get Header layout
 *
 * @return string
 */
function yankee_site_header() {
    $header_layout = yankee_get_option( 'header-layout', 'header-one' );

    if ( is_page() ) {
        $page_meta = get_post_meta( get_the_ID(), 'yankee_page_metaboxes', true );

        if ( !empty( $page_meta['page_header_layout'] ) ) {
            $header_layout = $page_meta['page_header_layout'];
        }
    }

    return $header_layout;
}

/**
 * Cheack Sticky Header
 *
 * @return boolean
 */
function yankee_sticky_header() {
    $sticky = yankee_get_option( 'sticky-header', true );

    if ( is_page() ) {
        $page_meta = get_post_meta( get_the_ID(), 'yankee_page_metaboxes', true );

        if ( isset( $page_meta['page_sticky_header'] ) ) {
            $sticky = $page_meta['page_sticky_header'];
        }
    }

    return $sticky;
}

/**
 * Get site footer
 *
 * @return Integer
 */
function yankee_site_footer() {
    $footer_id = yankee_get_option( 'site-footer' );

    if ( is_page() ) {
        $page_meta = get_post_meta( get_the_ID(), 'yankee_page_metaboxes', true );

        if ( !empty( $page_meta['page_footer_template'] ) ) {
            $footer_id = $page_meta['page_footer_template'];
        }
    }

    if ( !empty( $footer_id ) ) {
        $footer = (int) $footer_id;
    } else {
        $footer = '';
    }

    return $footer;
}

/**
 * Undocumented function
 *
 * @return boolean
 */
function yankee_page_padding() {
    $page_padding = false;

    if ( is_page() ) {
        $page_meta = get_post_meta( get_the_ID(), 'yankee_page_metaboxes', true );

        if ( is_array( $page_meta ) ) {
            if ( array_key_exists( 'remove_padding', $page_meta ) ) {
                $page_padding = $page_meta['remove_padding'];
            }
        }

    } elseif( is_single() && 'services' == get_post_type() ) {
        $service_meta = get_post_meta( get_the_ID(), 'yankee_service_metaboxes', true );

        if ( is_array( $service_meta ) ) {
            if ( array_key_exists( 'service_remove_padding', $service_meta ) ) {
                $page_padding = $service_meta['service_remove_padding'];
            }
        }

    } elseif( is_single() && 'portfolios' == get_post_type() ) {
        $portfolio_meta = get_post_meta( get_the_ID(), 'yankee_portfolios_metaboxes', true );

        if ( is_array( $portfolio_meta ) ) {
            if ( array_key_exists( 'portfolio_remove_padding', $portfolio_meta ) ) {
                $page_padding = $portfolio_meta['portfolio_remove_padding'];
            }
        }
    }

    return $page_padding;
}

/**
 * Hedaer Contact Buttom
 */
function ynakee_header_contact_btn() {
    ?>

    <div class="contact-btn">
        <div class="contact-info">
            <i class="fal fa-phone"></i>
            <span class="title"><?php echo esc_html( yankee_get_option( 'contact-btn-title' ) ) ?></span>
            <span class="info"><?php echo esc_html( yankee_get_option( 'contact-btn-number' ) ) ?></span>
        </div>
    </div>

    <?php
}

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function yankee_body_classes( $classes ) {
    // Adds a class of hfeed to non-singular pages.
    if ( !is_singular() ) {
        $classes[] = 'hfeed';
    }

    if ( 'header-one' == yankee_site_header() ) {
        $classes[] = 'header-version-one';
    } elseif ( 'header-two' == yankee_site_header() ) {
        $classes[] = 'header-version-two';
    } elseif ( 'header-three' == yankee_site_header() ) {
        $classes[] = 'header-version-three';
    } elseif ( 'header-four' == yankee_site_header() ) {
        $classes[] = 'header-version-four';
    }

    if ( 'no-sidebar' === yankee_get_sidebar() ){
        $classes[] = 'no-sidebar';
    }

    if ( yankee_sticky_header() ) {
        $classes[] = 'sticky-haeder';
    }

    return $classes;
}
add_filter( 'body_class', 'yankee_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function yankee_pingback_header() {
    if ( is_singular() && pings_open() ) {
        printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
    }
}
add_action( 'wp_head', 'yankee_pingback_header' );


/**
 * Yankee js hook
 */
if ( ! function_exists( 'yankee_hook_javascript' ) ) {
	function yankee_hook_javascript() {
		?>
			<script>
				<?php echo yankee_get_option('yankee-custom-scripts'); ?>
			</script>
		<?php
	}
	add_action('wp_head', 'yankee_hook_javascript');
}