<?php
/**
 * The template for displaying all single portfolio
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package yankee
 */

get_header();
?>
<div class="entry-service-details<?php if( !yankee_page_padding() ) : ?> entry-page-padding<?php endif; ?>">
    <div class="<?php yankee_content_layout() ?>">
        <div class="row">
            <div class="<?php yankee_content_column() ?>">
                <?php
					if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                        <div id="post-<?php the_ID(); ?>" <?php post_class('poftfolio-details-content'); ?>>
                            <?php the_content(); ?>
                        </div>
					<?php endwhile; endif;
				?>
                <div class="portfolio-post-nav">
                    <div class="row align-items-center justify-content-between">
                        <?php
                            $prev_post = get_previous_post();
                            $next_post = get_next_post();

                            if ( $prev_post ) : ?>
                                <div class="col">
                                    <div class="prev-post">
                                        <span><?php echo esc_html_e( 'Prev Work', 'yankee' ) ?></span>
                                        <a href="<?php echo get_permalink( $prev_post->ID ) ?>"><?php echo esc_html( get_the_title( $prev_post->ID ) ) ?></a>
                                    </div>
                                </div>
                            <?php endif;
                            if ( $next_post ) : ?>
                                <div class="col">
                                    <div class="next-post">
                                        <span><?php echo esc_html_e( 'Next Work', 'yankee' ) ?></span>
                                        <a href="<?php echo get_permalink( $next_post->ID ) ?>"><?php echo esc_html( get_the_title( $next_post->ID ) ) ?></a>
                                    </div>
                                </div>
                            <?php endif;
                        ?>
                    </div>
                </div>
            </div>
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>

<?php
get_footer();