<?php
/**
 * The template for displaying all single team member
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package yankee
 */

get_header();
$team_meta = get_post_meta( get_the_ID(), 'yankee_team_metaboxes', true );
?>
<div class="entry-team-details entry-page-padding">
    <div class="container">
        <?php
            if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                <div id="post-<?php the_ID(); ?>" <?php post_class('team-details-content'); ?>>
                    <div class="member-details-top row justify-content-center">
                        <div class="col-lg-3 col-md-6 col-sm-8">
                            <div class="member-photo">
                                <?php the_post_thumbnail('full'); ?>
                            </div>
                        </div>
                        <div class="col-lg-9">
                            <div class="row justify-content-center">
                                <div class="col-md-6 col-sm-10">
                                    <div class="member-short-desc">
                                        <?php
                                            the_title( '<h3 class="name">', '</h3>' );

                                            if( !empty( $team_meta['member_position'] ) ) {
                                                printf( '<span class="position">%1$s</span>',
                                                    esc_html( $team_meta['member_position'] )
                                                );
                                            }

                                            if ( !empty( $team_meta['short_info'] ) ) {
                                                printf( '<p>%1$s</p>',
                                                    esc_html( $team_meta['short_info'] )
                                                );
                                            }
                                        ?>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-10">
                                    <div class="member-contact-info">
                                        <?php
                                            if( !empty( $team_meta['info_box_heading'] ) ) {
                                                printf( '<h3>%1$s</h3>',
                                                    esc_html( $team_meta['info_box_heading'] )
                                                );
                                            }

                                            if( !empty( $team_meta['info_box_heading_tag'] ) ) {
                                                printf( '<span>%1$s</span>',
                                                    esc_html( $team_meta['info_box_heading_tag'] )
                                                );
                                            }

                                            if( !empty( $team_meta['member_contact_info'] ) ) : ?>
                                                <ul class="contact-info">
                                                    <?php foreach ( $team_meta['member_contact_info'] as $info ) : ?>
                                                        <li>
                                                            <?php if( !empty( $info['info_link'] ) ) : ?>
                                                                <a href="<?php echo esc_url( $info['info_link'] ) ?>">
                                                                    <i class="<?php echo esc_attr( $info['info_icon'] ) ?>"></i>
                                                                    <?php echo esc_html( $info['info_text'] ) ?>
                                                                </a>
                                                            <?php else : ?>
                                                                <i class="<?php echo esc_attr( $info['info_icon'] ) ?>"></i>
                                                                <?php echo esc_html( $info['info_text'] ) ?>
                                                            <?php endif; ?>
                                                        </li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            <?php endif;
                                            if( !empty( $team_meta['member_social_links'] ) ) : ?>
                                                <ul class="social-links">
                                                    <?php foreach ( $team_meta['member_social_links'] as $social ) : ?>
                                                        <li>
                                                            <a href="<?php echo esc_url( $social['link_text'] ) ?>">
                                                                <i class="<?php echo esc_attr( $social['link_icon'] ) ?>"></i>
                                                            </a>
                                                        </li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            <?php endif;
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php the_content(); ?>
                </div>
            <?php endwhile; endif;
        ?>
    </div>
</div>
<?php
get_footer();