<?php
/**
 * Template part for displaying gallery posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package yankee
 */

$gallery_meta = get_post_meta( get_the_ID(), 'yankee_post_gallry_meta', true);

if ( isset( $gallery_meta['post_gallery'] ) ) {
	$gallery_images = explode( ',', $gallery_meta['post_gallery'] );
} else {
	$gallery_images = array();
}

?>

<div id="post-<?php the_ID(); ?>" <?php post_class('entry-single-post'); ?>>

	<?php if ( ! empty( $gallery_images ) ) : ?>
		<div class="entry-media clearfix yankee-gallery-slider">
			<?php
				foreach ( $gallery_images as $gallery_image ) : ?>
				<div class="single-gallery-img">
					<?php echo wp_get_attachment_image( $gallery_image, 'yankee-post-thumbnail' ); ?>
				</div>
				<?php endforeach;
			?>
		</div>
	<?php endif; ?>

	<div class="entry-summary">
		<?php
			if ( yankee_get_option( 'post-archive-cat' ) ) {
				echo yankee_posted_in();
			}
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			if ( yankee_get_option('post-archive-meta') ) {
				echo yankee_post_meta();
			}
			the_excerpt();
		?>
		<div class="summary-footer">
			<?php
				if ( yankee_get_option( 'post-archive-user' ) ) {
					echo '<a href="'. esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) .'"> '. get_avatar( get_the_author_meta('ID') , 40 ) .' '. esc_html( get_the_author() ) .'</a>';
				}
				if ( !empty( yankee_get_option( 'post-archive-redmore' ) ) ) {
					echo '<a href="'. esc_url(get_permalink()). '" class="read-more"><i class="far fa-arrow-right"></i> '. esc_html( yankee_get_option( 'post-archive-redmore' )). ' </a>';
				} else {
					echo '<a href="'. esc_url(get_permalink()). '" class="read-more"><i class="far fa-arrow-right"></i> '. esc_html__( 'Read More', 'yankee'). ' </a>';
				}
			?>
		</div>
	</div>
</div>